/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.tableswithspacesmodel;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.descriptors.VersionLockingPolicy;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.mappings.TransformationMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.InMemoryQueryIndirectionPolicy;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.EmploymentPeriod;
import org.eclipse.persistence.testing.models.employee.domain.LargeProject;
import org.eclipse.persistence.testing.models.employee.domain.PhoneNumber;
import org.eclipse.persistence.testing.models.employee.interfaces.SmallProject;

public class EmployeeWithSpacesProject
extends Project {
    public EmployeeWithSpacesProject() {
        this.setName("Employee");
        this.applyLogin();
        this.addDescriptor(this.buildAddressDescriptor());
        this.addDescriptor(this.buildEmployeeDescriptor());
        this.addDescriptor(this.buildEmploymentPeriodDescriptor());
        this.addDescriptor(this.buildLargeProjectDescriptor());
        this.addDescriptor(this.buildPhoneNumberDescriptor());
        this.addDescriptor(this.buildProjectDescriptor());
        this.addDescriptor(this.buildSmallProjectDescriptor());
    }

    public void applyLogin() {
        DatabaseLogin login = new DatabaseLogin();
        this.setDatasourceLogin((Login)login);
    }

    public ClassDescriptor buildAddressDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Address.class);
        descriptor.addTableName("ADDRESS TABLE");
        descriptor.addPrimaryKeyFieldName("ADDRESS TABLE.ADDRESS_ID");
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.useRemoteSoftCacheWeakIdentityMap();
        descriptor.setRemoteIdentityMapSize(100);
        descriptor.setSequenceNumberFieldName("ADDRESS TABLE.ADDRESS_ID");
        descriptor.setSequenceNumberName("ADDRESS_SEQ");
        descriptor.setAlias("Address");
        descriptor.getQueryManager().checkCacheForDoesExist();
        descriptor.getQueryManager().setQueryTimeout(0);
        DirectToFieldMapping cityMapping = new DirectToFieldMapping();
        cityMapping.setAttributeName("city");
        cityMapping.setFieldName("ADDRESS TABLE.CITY");
        descriptor.addMapping((DatabaseMapping)cityMapping);
        DirectToFieldMapping countryMapping = new DirectToFieldMapping();
        countryMapping.setAttributeName("country");
        countryMapping.setFieldName("ADDRESS TABLE.COUNTRY");
        descriptor.addMapping((DatabaseMapping)countryMapping);
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("ADDRESS TABLE.ADDRESS_ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        DirectToFieldMapping postalCodeMapping = new DirectToFieldMapping();
        postalCodeMapping.setAttributeName("postalCode");
        postalCodeMapping.setFieldName("ADDRESS TABLE.P_CODE");
        descriptor.addMapping((DatabaseMapping)postalCodeMapping);
        DirectToFieldMapping provinceMapping = new DirectToFieldMapping();
        provinceMapping.setAttributeName("province");
        provinceMapping.setFieldName("ADDRESS TABLE.PROVINCE");
        descriptor.addMapping((DatabaseMapping)provinceMapping);
        DirectToFieldMapping streetMapping = new DirectToFieldMapping();
        streetMapping.setAttributeName("street");
        streetMapping.setFieldName("ADDRESS TABLE.STREET");
        descriptor.addMapping((DatabaseMapping)streetMapping);
        return descriptor;
    }

    public ClassDescriptor buildEmployeeDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Employee.class);
        descriptor.addTableName("EMPLOYEE TABLE");
        descriptor.addTableName("SALARY TABLE");
        descriptor.addPrimaryKeyFieldName("EMPLOYEE TABLE.EMP_ID");
        descriptor.getInterfacePolicy().addParentInterface(org.eclipse.persistence.testing.models.employee.interfaces.Employee.class);
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.useRemoteSoftCacheWeakIdentityMap();
        descriptor.setRemoteIdentityMapSize(100);
        descriptor.setSequenceNumberFieldName("EMPLOYEE TABLE.EMP_ID");
        descriptor.setSequenceNumberName("EMP_SEQ");
        VersionLockingPolicy lockingPolicy = new VersionLockingPolicy();
        lockingPolicy.setWriteLockFieldName("EMPLOYEE TABLE.VERSION");
        descriptor.setOptimisticLockingPolicy((OptimisticLockingPolicy)lockingPolicy);
        descriptor.setAlias("Employee");
        descriptor.getQueryManager().checkCacheForDoesExist();
        descriptor.getQueryManager().setQueryTimeout(0);
        DirectToFieldMapping firstNameMapping = new DirectToFieldMapping();
        firstNameMapping.setAttributeName("firstName");
        firstNameMapping.setFieldName("EMPLOYEE TABLE.F_NAME");
        firstNameMapping.setNullValue((Object)"");
        descriptor.addMapping((DatabaseMapping)firstNameMapping);
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("EMPLOYEE TABLE.EMP_ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        DirectToFieldMapping lastNameMapping = new DirectToFieldMapping();
        lastNameMapping.setAttributeName("lastName");
        lastNameMapping.setFieldName("EMPLOYEE TABLE.L_NAME");
        lastNameMapping.setNullValue((Object)"");
        descriptor.addMapping((DatabaseMapping)lastNameMapping);
        DirectToFieldMapping salaryMapping = new DirectToFieldMapping();
        salaryMapping.setAttributeName("salary");
        salaryMapping.setFieldName("SALARY TABLE.SALARY");
        descriptor.addMapping((DatabaseMapping)salaryMapping);
        DirectToFieldMapping genderMapping = new DirectToFieldMapping();
        genderMapping.setAttributeName("gender");
        genderMapping.setFieldName("EMPLOYEE TABLE.GENDER");
        ObjectTypeConverter genderMappingConverter = new ObjectTypeConverter();
        genderMappingConverter.addConversionValue((Object)"F", (Object)"Female");
        genderMappingConverter.addConversionValue((Object)"M", (Object)"Male");
        genderMapping.setConverter((Converter)genderMappingConverter);
        descriptor.addMapping((DatabaseMapping)genderMapping);
        TransformationMapping normalHoursMapping = new TransformationMapping();
        normalHoursMapping.setAttributeName("normalHours");
        normalHoursMapping.setAttributeTransformation("buildNormalHours");
        normalHoursMapping.addFieldTransformation("EMPLOYEE TABLE.START_TIME", "getStartTime");
        normalHoursMapping.addFieldTransformation("EMPLOYEE TABLE.END_TIME", "getEndTime");
        normalHoursMapping.setIsMutable(true);
        descriptor.addMapping((DatabaseMapping)normalHoursMapping);
        AggregateObjectMapping periodMapping = new AggregateObjectMapping();
        periodMapping.setAttributeName("period");
        periodMapping.setReferenceClass(EmploymentPeriod.class);
        periodMapping.setIsNullAllowed(true);
        periodMapping.addFieldNameTranslation("EMPLOYEE TABLE.END_DATE", "endDate->DIRECT");
        periodMapping.addFieldNameTranslation("EMPLOYEE TABLE.START_DATE", "startDate->DIRECT");
        descriptor.addMapping((DatabaseMapping)periodMapping);
        DirectCollectionMapping responsibilitiesListMapping = new DirectCollectionMapping();
        responsibilitiesListMapping.setAttributeName("responsibilitiesList");
        responsibilitiesListMapping.useBasicIndirection();
        responsibilitiesListMapping.setReferenceTableName("RESPONS TABLE");
        responsibilitiesListMapping.setDirectFieldName("RESPONS TABLE.DESCRIP");
        responsibilitiesListMapping.addReferenceKeyFieldName("RESPONS TABLE.EMP_ID", "EMPLOYEE TABLE.EMP_ID");
        descriptor.addMapping((DatabaseMapping)responsibilitiesListMapping);
        OneToOneMapping addressMapping = new OneToOneMapping();
        addressMapping.setAttributeName("address");
        addressMapping.setReferenceClass(Address.class);
        addressMapping.useBasicIndirection();
        addressMapping.privateOwnedRelationship();
        addressMapping.addForeignKeyFieldName("EMPLOYEE TABLE.ADDR_ID", "ADDRESS TABLE.ADDRESS_ID");
        descriptor.addMapping((DatabaseMapping)addressMapping);
        OneToOneMapping managerMapping = new OneToOneMapping();
        managerMapping.setAttributeName("manager");
        managerMapping.setReferenceClass(Employee.class);
        managerMapping.useBasicIndirection();
        managerMapping.addForeignKeyFieldName("EMPLOYEE TABLE.MANAGER_ID", "EMPLOYEE TABLE.EMP_ID");
        descriptor.addMapping((DatabaseMapping)managerMapping);
        OneToManyMapping managedEmployeesMapping = new OneToManyMapping();
        managedEmployeesMapping.setAttributeName("managedEmployees");
        managedEmployeesMapping.setReferenceClass(Employee.class);
        managedEmployeesMapping.useBasicIndirection();
        managedEmployeesMapping.addTargetForeignKeyFieldName("EMPLOYEE TABLE.MANAGER_ID", "EMPLOYEE TABLE.EMP_ID");
        descriptor.addMapping((DatabaseMapping)managedEmployeesMapping);
        OneToManyMapping phoneNumbersMapping = new OneToManyMapping();
        phoneNumbersMapping.setAttributeName("phoneNumbers");
        phoneNumbersMapping.setReferenceClass(PhoneNumber.class);
        phoneNumbersMapping.useBasicIndirection();
        phoneNumbersMapping.privateOwnedRelationship();
        phoneNumbersMapping.addTargetForeignKeyFieldName("PHONE NUM.EMP_ID", "EMPLOYEE TABLE.EMP_ID");
        descriptor.addMapping((DatabaseMapping)phoneNumbersMapping);
        ManyToManyMapping projectsMapping = new ManyToManyMapping();
        projectsMapping.setAttributeName("projects");
        projectsMapping.setReferenceClass(org.eclipse.persistence.testing.models.employee.domain.Project.class);
        projectsMapping.useBasicIndirection();
        projectsMapping.setRelationTableName("PROJ EMP");
        projectsMapping.addSourceRelationKeyFieldName("PROJ EMP.EMP_ID", "EMPLOYEE TABLE.EMP_ID");
        projectsMapping.addTargetRelationKeyFieldName("PROJ EMP.PROJ_ID", "PROJECT TABLE.PROJ_ID");
        descriptor.addMapping((DatabaseMapping)projectsMapping);
        return descriptor;
    }

    public ClassDescriptor buildEmploymentPeriodDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.descriptorIsAggregate();
        descriptor.setJavaClass(EmploymentPeriod.class);
        descriptor.setAlias("EmploymentPeriod");
        DirectToFieldMapping endDateMapping = new DirectToFieldMapping();
        endDateMapping.setAttributeName("endDate");
        endDateMapping.setFieldName("endDate->DIRECT");
        descriptor.addMapping((DatabaseMapping)endDateMapping);
        DirectToFieldMapping startDateMapping = new DirectToFieldMapping();
        startDateMapping.setAttributeName("startDate");
        startDateMapping.setFieldName("startDate->DIRECT");
        descriptor.addMapping((DatabaseMapping)startDateMapping);
        return descriptor;
    }

    public ClassDescriptor buildLargeProjectDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(LargeProject.class);
        descriptor.addTableName("L PROJECT TABLE");
        descriptor.getInheritancePolicy().setParentClass(org.eclipse.persistence.testing.models.employee.domain.Project.class);
        descriptor.getInheritancePolicy().dontReadSubclassesOnQueries();
        descriptor.getInterfacePolicy().addParentInterface(org.eclipse.persistence.testing.models.employee.interfaces.LargeProject.class);
        descriptor.setAlias("LargeProject");
        descriptor.getQueryManager().checkCacheForDoesExist();
        descriptor.getQueryManager().setQueryTimeout(0);
        DirectToFieldMapping budgetMapping = new DirectToFieldMapping();
        budgetMapping.setAttributeName("budget");
        budgetMapping.setFieldName("L PROJECT TABLE.BUDGET");
        descriptor.addMapping((DatabaseMapping)budgetMapping);
        DirectToFieldMapping milestoneVersionMapping = new DirectToFieldMapping();
        milestoneVersionMapping.setAttributeName("milestoneVersion");
        milestoneVersionMapping.setFieldName("L PROJECT TABLE.MILESTONE");
        descriptor.addMapping((DatabaseMapping)milestoneVersionMapping);
        return descriptor;
    }

    public ClassDescriptor buildPhoneNumberDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(PhoneNumber.class);
        descriptor.addTableName("PHONE NUM");
        descriptor.addPrimaryKeyFieldName("PHONE NUM.EMP_ID");
        descriptor.addPrimaryKeyFieldName("PHONE NUM.TYPE");
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.useRemoteSoftCacheWeakIdentityMap();
        descriptor.setRemoteIdentityMapSize(100);
        descriptor.setAlias("PhoneNumber");
        descriptor.getQueryManager().checkCacheForDoesExist();
        descriptor.getQueryManager().setQueryTimeout(0);
        ReadObjectQuery namedQuery0 = new ReadObjectQuery(PhoneNumber.class);
        namedQuery0.setName("localNumbers");
        namedQuery0.setCascadePolicy(1);
        namedQuery0.setQueryTimeout(-1);
        namedQuery0.setShouldUseWrapperPolicy(true);
        namedQuery0.setShouldMaintainCache(true);
        namedQuery0.setShouldPrepare(true);
        namedQuery0.setMaxRows(0);
        namedQuery0.setShouldRefreshIdentityMapResult(false);
        namedQuery0.setCacheUsage(2);
        namedQuery0.setLockMode((short)0);
        namedQuery0.setShouldRefreshRemoteIdentityMapResult(false);
        namedQuery0.setDistinctState((short)0);
        namedQuery0.setInMemoryQueryIndirectionPolicy(new InMemoryQueryIndirectionPolicy(0));
        ExpressionBuilder expBuilder0 = namedQuery0.getExpressionBuilder();
        namedQuery0.setSelectionCriteria(expBuilder0.get("id").equal(expBuilder0.getParameter("ID")).and(expBuilder0.get("areaCode").equal((Object)"613")));
        namedQuery0.addArgument("ID", Number.class);
        descriptor.getQueryManager().addQuery("localNumbers", (DatabaseQuery)namedQuery0);
        descriptor.addDirectQueryKey("id", "PHONE NUM.EMP_ID");
        DirectToFieldMapping areaCodeMapping = new DirectToFieldMapping();
        areaCodeMapping.setAttributeName("areaCode");
        areaCodeMapping.setFieldName("PHONE NUM.AREA_CODE");
        descriptor.addMapping((DatabaseMapping)areaCodeMapping);
        DirectToFieldMapping numberMapping = new DirectToFieldMapping();
        numberMapping.setAttributeName("number");
        numberMapping.setFieldName("PHONE NUM.P_NUMBER");
        descriptor.addMapping((DatabaseMapping)numberMapping);
        DirectToFieldMapping typeMapping = new DirectToFieldMapping();
        typeMapping.setAttributeName("type");
        typeMapping.setFieldName("PHONE NUM.TYPE");
        descriptor.addMapping((DatabaseMapping)typeMapping);
        OneToOneMapping ownerMapping = new OneToOneMapping();
        ownerMapping.setAttributeName("owner");
        ownerMapping.setReferenceClass(Employee.class);
        ownerMapping.useBasicIndirection();
        ownerMapping.addForeignKeyFieldName("PHONE NUM.EMP_ID", "EMPLOYEE TABLE.EMP_ID");
        descriptor.addMapping((DatabaseMapping)ownerMapping);
        return descriptor;
    }

    public ClassDescriptor buildProjectDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(org.eclipse.persistence.testing.models.employee.domain.Project.class);
        descriptor.addTableName("PROJECT TABLE");
        descriptor.addPrimaryKeyFieldName("PROJECT TABLE.PROJ_ID");
        descriptor.getInheritancePolicy().setClassIndicatorFieldName("PROJECT TABLE.PROJ_TYPE");
        descriptor.getInheritancePolicy().addClassIndicator(org.eclipse.persistence.testing.models.employee.domain.SmallProject.class, (Object)"S");
        descriptor.getInheritancePolicy().addClassIndicator(LargeProject.class, (Object)"L");
        descriptor.getInterfacePolicy().addParentInterface(org.eclipse.persistence.testing.models.employee.interfaces.Project.class);
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.useRemoteSoftCacheWeakIdentityMap();
        descriptor.setRemoteIdentityMapSize(100);
        descriptor.setSequenceNumberFieldName("PROJECT TABLE.PROJ_ID");
        descriptor.setSequenceNumberName("PROJ_SEQ");
        VersionLockingPolicy lockingPolicy = new VersionLockingPolicy();
        lockingPolicy.setWriteLockFieldName("PROJECT TABLE.VERSION");
        descriptor.setOptimisticLockingPolicy((OptimisticLockingPolicy)lockingPolicy);
        descriptor.setAlias("Project");
        descriptor.getQueryManager().checkCacheForDoesExist();
        descriptor.getQueryManager().setQueryTimeout(0);
        DirectToFieldMapping descriptionMapping = new DirectToFieldMapping();
        descriptionMapping.setAttributeName("description");
        descriptionMapping.setFieldName("PROJECT TABLE.DESCRIP");
        descriptionMapping.setNullValue((Object)"");
        descriptor.addMapping((DatabaseMapping)descriptionMapping);
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("PROJECT TABLE.PROJ_ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        DirectToFieldMapping nameMapping = new DirectToFieldMapping();
        nameMapping.setAttributeName("name");
        nameMapping.setFieldName("PROJECT TABLE.PROJ_NAME");
        nameMapping.setNullValue((Object)"");
        descriptor.addMapping((DatabaseMapping)nameMapping);
        OneToOneMapping teamLeaderMapping = new OneToOneMapping();
        teamLeaderMapping.setAttributeName("teamLeader");
        teamLeaderMapping.setReferenceClass(Employee.class);
        teamLeaderMapping.useBasicIndirection();
        teamLeaderMapping.addForeignKeyFieldName("PROJECT TABLE.LEADER_ID", "EMPLOYEE TABLE.EMP_ID");
        descriptor.addMapping((DatabaseMapping)teamLeaderMapping);
        return descriptor;
    }

    public ClassDescriptor buildSmallProjectDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(org.eclipse.persistence.testing.models.employee.domain.SmallProject.class);
        descriptor.addTableName("PROJECT TABLE");
        descriptor.getInheritancePolicy().setParentClass(org.eclipse.persistence.testing.models.employee.domain.Project.class);
        descriptor.getInheritancePolicy().dontReadSubclassesOnQueries();
        descriptor.getInterfacePolicy().addParentInterface(SmallProject.class);
        descriptor.setAlias("SmallProject");
        descriptor.getQueryManager().checkCacheForDoesExist();
        descriptor.getQueryManager().setQueryTimeout(0);
        return descriptor;
    }
}

