/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.interceptors;

import com.sun.corba.ee.impl.corba.RequestImpl;
import com.sun.corba.ee.impl.interceptors.ClientRequestInfoImpl;
import com.sun.corba.ee.impl.interceptors.CodecFactoryImpl;
import com.sun.corba.ee.impl.interceptors.InterceptorInvoker;
import com.sun.corba.ee.impl.interceptors.InterceptorList;
import com.sun.corba.ee.impl.interceptors.ORBInitInfoImpl;
import com.sun.corba.ee.impl.interceptors.PICurrent;
import com.sun.corba.ee.impl.interceptors.RequestInfoImpl;
import com.sun.corba.ee.impl.interceptors.ServerRequestInfoImpl;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.ReplyMessage;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.ior.ObjectKeyTemplate;
import com.sun.corba.ee.spi.logging.InterceptorsSystemException;
import com.sun.corba.ee.spi.logging.OMGSystemException;
import com.sun.corba.ee.spi.logging.ORBUtilSystemException;
import com.sun.corba.ee.spi.oa.ObjectAdapter;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.protocol.ForwardException;
import com.sun.corba.ee.spi.protocol.MessageMediator;
import com.sun.corba.ee.spi.protocol.PIHandler;
import com.sun.corba.ee.spi.protocol.RetryType;
import com.sun.corba.ee.spi.trace.TraceInterceptor;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.glassfish.pfl.basic.func.NullaryFunction;
import org.glassfish.pfl.tf.spi.annotation.InfoMethod;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.NVList;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyError;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UserException;
import org.omg.CORBA.portable.ApplicationException;
import org.omg.CORBA.portable.RemarshalException;
import org.omg.IOP.CodecFactory;
import org.omg.PortableInterceptor.Current;
import org.omg.PortableInterceptor.Interceptor;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ORBInitializer;
import org.omg.PortableInterceptor.ObjectReferenceTemplate;
import org.omg.PortableInterceptor.PolicyFactory;

@TraceInterceptor
public class PIHandlerImpl
implements PIHandler {
    private ORB orb;
    static final InterceptorsSystemException wrapper = InterceptorsSystemException.self;
    static final ORBUtilSystemException orbutilWrapper = ORBUtilSystemException.self;
    static final OMGSystemException omgWrapper = OMGSystemException.self;
    private int serverRequestIdCounter = 0;
    CodecFactory codecFactory = null;
    String[] arguments = null;
    private InterceptorList interceptorList;
    private boolean hasIORInterceptors;
    private boolean hasClientInterceptors;
    private boolean hasServerInterceptors;
    private InterceptorInvoker interceptorInvoker;
    private PICurrent current;
    private Map<Integer, PolicyFactory> policyFactoryTable;
    private static final short[] REPLY_MESSAGE_TO_PI_REPLY_STATUS = new short[]{0, 2, 1, 3, 3, 4};
    private ThreadLocal<RequestInfoStack<ClientRequestInfoImpl>> threadLocalClientRequestInfoStack = new ThreadLocal<RequestInfoStack<ClientRequestInfoImpl>>(){

        @Override
        protected RequestInfoStack<ClientRequestInfoImpl> initialValue() {
            return new RequestInfoStack<ClientRequestInfoImpl>();
        }
    };
    private ThreadLocal<RequestInfoStack<ServerRequestInfoImpl>> threadLocalServerRequestInfoStack = new ThreadLocal<RequestInfoStack<ServerRequestInfoImpl>>(){

        @Override
        protected RequestInfoStack<ServerRequestInfoImpl> initialValue() {
            return new RequestInfoStack<ServerRequestInfoImpl>();
        }
    };

    static String getReplyStatus(int piReplyStatus) {
        switch (piReplyStatus) {
            case 0: {
                return "SUCCESSFUL";
            }
            case 2: {
                return "USER_EXCEPTION";
            }
            case 1: {
                return "SYSTEM_EXCEPTION";
            }
            case 3: {
                return "LOCATION_FORWARD";
            }
            case 4: {
                return "TRANSPORT_RETRY";
            }
        }
        return "UNINITIALIZED";
    }

    @Override
    @TraceInterceptor
    public void close() {
        this.orb = null;
        this.codecFactory = null;
        this.arguments = null;
        this.interceptorList = null;
        this.interceptorInvoker = null;
        this.current = null;
        this.policyFactoryTable = null;
        this.threadLocalClientRequestInfoStack = null;
        this.threadLocalServerRequestInfoStack = null;
    }

    public PIHandlerImpl(ORB orb, String[] args) {
        this.orb = orb;
        this.arguments = args == null ? null : (String[])args.clone();
        this.codecFactory = new CodecFactoryImpl((org.omg.CORBA.ORB)orb);
        this.interceptorList = new InterceptorList();
        this.current = new PICurrent(orb);
        this.interceptorInvoker = new InterceptorInvoker(orb, this.interceptorList, this.current);
        orb.getLocalResolver().register("PICurrent", (NullaryFunction<Object>)NullaryFunction.Factory.makeConstant((java.lang.Object)((java.lang.Object)this.current)));
        orb.getLocalResolver().register("CodecFactory", (NullaryFunction<Object>)NullaryFunction.Factory.makeConstant((java.lang.Object)this.codecFactory));
        this.hasClientInterceptors = true;
        this.hasServerInterceptors = true;
    }

    @Override
    @TraceInterceptor
    public void initialize() {
        if (this.orb.getORBData().getORBInitializers() != null) {
            ORBInitInfoImpl orbInitInfo = this.createORBInitInfo();
            this.current.setORBInitializing(true);
            this.preInitORBInitializers(orbInitInfo);
            this.postInitORBInitializers(orbInitInfo);
            this.interceptorList.sortInterceptors();
            this.current.setORBInitializing(false);
            orbInitInfo.setStage(2);
            this.hasIORInterceptors = this.interceptorList.hasInterceptorsOfType(2);
            this.interceptorInvoker.setEnabled(true);
        }
    }

    @Override
    @TraceInterceptor
    public void destroyInterceptors() {
        this.interceptorList.destroyAll();
    }

    @Override
    @TraceInterceptor
    public void objectAdapterCreated(ObjectAdapter oa) {
        if (!this.hasIORInterceptors) {
            return;
        }
        this.interceptorInvoker.objectAdapterCreated(oa);
    }

    @Override
    @TraceInterceptor
    public void adapterManagerStateChanged(int managerId, short newState) {
        if (!this.hasIORInterceptors) {
            return;
        }
        this.interceptorInvoker.adapterManagerStateChanged(managerId, newState);
    }

    @Override
    @TraceInterceptor
    public void adapterStateChanged(ObjectReferenceTemplate[] templates, short newState) {
        if (!this.hasIORInterceptors) {
            return;
        }
        this.interceptorInvoker.adapterStateChanged(templates, newState);
    }

    @Override
    @TraceInterceptor
    public void disableInterceptorsThisThread() {
        if (!this.hasClientInterceptors) {
            return;
        }
        RequestInfoStack<ClientRequestInfoImpl> infoStack = this.threadLocalClientRequestInfoStack.get();
        ++infoStack.disableCount;
    }

    @Override
    @TraceInterceptor
    public void enableInterceptorsThisThread() {
        if (!this.hasClientInterceptors) {
            return;
        }
        RequestInfoStack<ClientRequestInfoImpl> infoStack = this.threadLocalClientRequestInfoStack.get();
        --infoStack.disableCount;
    }

    @Override
    @TraceInterceptor
    public void invokeClientPIStartingPoint() throws RemarshalException {
        if (!this.hasClientInterceptors) {
            return;
        }
        if (!this.isClientPIEnabledForThisThread()) {
            return;
        }
        ClientRequestInfoImpl info = this.peekClientRequestInfoImplStack();
        this.interceptorInvoker.invokeClientInterceptorStartingPoint(info);
        short replyStatus = info.getReplyStatus();
        if (replyStatus == 1 || replyStatus == 3) {
            Exception exception = this.invokeClientPIEndingPoint(this.convertPIReplyStatusToReplyMessage(replyStatus), info.getException());
            if (exception == null) {
                // empty if block
            }
            if (exception instanceof SystemException) {
                throw (SystemException)((java.lang.Object)exception);
            }
            if (exception instanceof RemarshalException) {
                throw (RemarshalException)((java.lang.Object)exception);
            }
            if (exception instanceof UserException || exception instanceof ApplicationException) {
                throw wrapper.exceptionInvalid();
            }
        } else if (replyStatus != -1) {
            throw wrapper.replyStatusNotInit();
        }
    }

    @Override
    public Exception makeCompletedClientRequest(int replyStatus, Exception exception) {
        return this.handleClientPIEndingPoint(replyStatus, exception, false);
    }

    @Override
    public Exception invokeClientPIEndingPoint(int replyStatus, Exception exception) {
        return this.handleClientPIEndingPoint(replyStatus, exception, true);
    }

    @TraceInterceptor
    public Exception handleClientPIEndingPoint(int replyStatus, Exception exception, boolean invokeEndingPoint) {
        if (!this.hasClientInterceptors) {
            return exception;
        }
        if (!this.isClientPIEnabledForThisThread()) {
            return exception;
        }
        short piReplyStatus = REPLY_MESSAGE_TO_PI_REPLY_STATUS[replyStatus];
        ClientRequestInfoImpl info = this.peekClientRequestInfoImplStack();
        info.setReplyStatus(piReplyStatus);
        info.setException((Exception)exception);
        if (invokeEndingPoint) {
            this.interceptorInvoker.invokeClientInterceptorEndingPoint(info);
            piReplyStatus = info.getReplyStatus();
        }
        if (piReplyStatus == 3 || piReplyStatus == 4) {
            info.reset();
            if (invokeEndingPoint) {
                info.setRetryRequest(RetryType.AFTER_RESPONSE);
            } else {
                info.setRetryRequest(RetryType.BEFORE_RESPONSE);
            }
            exception = new RemarshalException();
        } else if (piReplyStatus == 1 || piReplyStatus == 2) {
            exception = info.getException();
        }
        return exception;
    }

    @InfoMethod
    private void secondCallForADIIRequest() {
    }

    @InfoMethod
    private void normalCall() {
    }

    @InfoMethod
    private void clientInfoStackWasPushed() {
    }

    @Override
    @TraceInterceptor
    public void initiateClientPIRequest(boolean diiRequest) {
        if (!this.hasClientInterceptors) {
            return;
        }
        if (!this.isClientPIEnabledForThisThread()) {
            return;
        }
        RequestInfoStack<ClientRequestInfoImpl> infoStack = this.threadLocalClientRequestInfoStack.get();
        ClientRequestInfoImpl info = null;
        if (!infoStack.empty()) {
            info = (ClientRequestInfoImpl)infoStack.peek();
        }
        if (!diiRequest && info != null && info.isDIIInitiate()) {
            this.secondCallForADIIRequest();
            info.setDIIInitiate(false);
        } else {
            this.normalCall();
            if (info == null || !info.getRetryRequest().isRetry()) {
                info = new ClientRequestInfoImpl(this.orb);
                infoStack.push(info);
                this.clientInfoStackWasPushed();
            }
            info.setRetryRequest(RetryType.NONE);
            info.incrementEntryCount();
            info.setReplyStatus((short)-1);
            if (diiRequest) {
                info.setDIIInitiate(true);
            }
        }
    }

    @InfoMethod
    private void clientInfoStackWasPopped() {
    }

    @Override
    @TraceInterceptor
    public void cleanupClientPIRequest() {
        short replyStatus;
        if (!this.hasClientInterceptors) {
            return;
        }
        if (!this.isClientPIEnabledForThisThread()) {
            return;
        }
        ClientRequestInfoImpl info = this.peekClientRequestInfoImplStack();
        RetryType rt = info.getRetryRequest();
        if (!rt.equals((java.lang.Object)RetryType.BEFORE_RESPONSE) && (replyStatus = info.getReplyStatus()) == -1) {
            this.invokeClientPIEndingPoint(2, (Exception)((java.lang.Object)wrapper.unknownRequestInvoke()));
        }
        info.decrementEntryCount();
        if (info.getEntryCount() == 0 && !info.getRetryRequest().isRetry()) {
            RequestInfoStack<ClientRequestInfoImpl> infoStack = this.threadLocalClientRequestInfoStack.get();
            infoStack.pop();
            this.clientInfoStackWasPopped();
        }
    }

    @Override
    @TraceInterceptor
    public void setClientPIInfo(MessageMediator messageMediator) {
        if (!this.hasClientInterceptors) {
            return;
        }
        if (!this.isClientPIEnabledForThisThread()) {
            return;
        }
        this.peekClientRequestInfoImplStack().setInfo(messageMediator);
    }

    @Override
    @TraceInterceptor
    public void setClientPIInfo(RequestImpl requestImpl) {
        if (!this.hasClientInterceptors) {
            return;
        }
        if (!this.isClientPIEnabledForThisThread()) {
            return;
        }
        this.peekClientRequestInfoImplStack().setDIIRequest(requestImpl);
    }

    @Override
    @TraceInterceptor
    public void invokeServerPIStartingPoint() {
        if (!this.hasServerInterceptors) {
            return;
        }
        ServerRequestInfoImpl info = this.peekServerRequestInfoImplStack();
        this.interceptorInvoker.invokeServerInterceptorStartingPoint(info);
        this.serverPIHandleExceptions(info);
    }

    @Override
    @TraceInterceptor
    public void invokeServerPIIntermediatePoint() {
        if (!this.hasServerInterceptors) {
            return;
        }
        ServerRequestInfoImpl info = this.peekServerRequestInfoImplStack();
        this.interceptorInvoker.invokeServerInterceptorIntermediatePoint(info);
        info.releaseServant();
        this.serverPIHandleExceptions(info);
    }

    @Override
    @TraceInterceptor
    public void invokeServerPIEndingPoint(ReplyMessage replyMessage) {
        if (!this.hasServerInterceptors) {
            return;
        }
        ServerRequestInfoImpl info = this.peekServerRequestInfoImplStack();
        info.setReplyMessage(replyMessage);
        info.setCurrentExecutionPoint(2);
        if (!info.getAlreadyExecuted()) {
            int replyStatus = replyMessage.getReplyStatus();
            short piReplyStatus = REPLY_MESSAGE_TO_PI_REPLY_STATUS[replyStatus];
            if (piReplyStatus == 3 || piReplyStatus == 4) {
                info.setForwardRequest(replyMessage.getIOR());
            }
            Exception prevException = info.getException();
            if (!info.isDynamic() && piReplyStatus == 2) {
                info.setException((Exception)((java.lang.Object)omgWrapper.unknownUserException()));
            }
            info.setReplyStatus(piReplyStatus);
            this.interceptorInvoker.invokeServerInterceptorEndingPoint(info);
            short newPIReplyStatus = info.getReplyStatus();
            Exception newException = info.getException();
            if (newPIReplyStatus == 1 && newException != prevException) {
                throw (SystemException)((java.lang.Object)newException);
            }
            if (newPIReplyStatus == 3) {
                if (piReplyStatus != 3) {
                    IOR ior = info.getForwardRequestIOR();
                    throw new ForwardException(this.orb, ior);
                }
                if (info.isForwardRequestRaisedInEnding()) {
                    replyMessage.setIOR(info.getForwardRequestIOR());
                }
            }
        }
    }

    @Override
    @TraceInterceptor
    public void setServerPIInfo(Exception exception) {
        if (!this.hasServerInterceptors) {
            return;
        }
        ServerRequestInfoImpl info = this.peekServerRequestInfoImplStack();
        info.setException(exception);
    }

    @Override
    @TraceInterceptor
    public void setServerPIInfo(NVList arguments) {
        if (!this.hasServerInterceptors) {
            return;
        }
        ServerRequestInfoImpl info = this.peekServerRequestInfoImplStack();
        info.setDSIArguments(arguments);
    }

    @Override
    @TraceInterceptor
    public void setServerPIExceptionInfo(Any exception) {
        if (!this.hasServerInterceptors) {
            return;
        }
        ServerRequestInfoImpl info = this.peekServerRequestInfoImplStack();
        info.setDSIException(exception);
    }

    @Override
    @TraceInterceptor
    public void setServerPIInfo(Any result) {
        if (!this.hasServerInterceptors) {
            return;
        }
        ServerRequestInfoImpl info = this.peekServerRequestInfoImplStack();
        info.setDSIResult(result);
    }

    @InfoMethod
    private void serverInfoStackWasPushed() {
    }

    @InfoMethod
    private void serverInfoStackWasPopped() {
    }

    @Override
    @TraceInterceptor
    public void initializeServerPIInfo(MessageMediator request, ObjectAdapter oa, byte[] objectId, ObjectKeyTemplate oktemp) {
        if (!this.hasServerInterceptors) {
            return;
        }
        RequestInfoStack<ServerRequestInfoImpl> infoStack = this.threadLocalServerRequestInfoStack.get();
        ServerRequestInfoImpl info = new ServerRequestInfoImpl(this.orb);
        infoStack.push(info);
        this.serverInfoStackWasPushed();
        request.setExecutePIInResponseConstructor(true);
        info.setInfo(request, oa, objectId, oktemp);
    }

    @Override
    @TraceInterceptor
    public void setServerPIInfo(java.lang.Object servant, String targetMostDerivedInterface) {
        if (!this.hasServerInterceptors) {
            return;
        }
        ServerRequestInfoImpl info = this.peekServerRequestInfoImplStack();
        info.setInfo(servant, targetMostDerivedInterface);
    }

    @Override
    @TraceInterceptor
    public void cleanupServerPIRequest() {
        if (!this.hasServerInterceptors) {
            return;
        }
        RequestInfoStack<ServerRequestInfoImpl> infoStack = this.threadLocalServerRequestInfoStack.get();
        infoStack.pop();
        this.serverInfoStackWasPopped();
    }

    @TraceInterceptor
    private void serverPIHandleExceptions(ServerRequestInfoImpl info) {
        int endingPointCall = info.getEndingPointCall();
        if (endingPointCall == 1) {
            throw (SystemException)((java.lang.Object)info.getException());
        }
        if (endingPointCall == 2 && info.getForwardRequestException() != null) {
            IOR ior = info.getForwardRequestIOR();
            throw new ForwardException(this.orb, ior);
        }
    }

    @TraceInterceptor
    private int convertPIReplyStatusToReplyMessage(short replyStatus) {
        int result = 0;
        for (int i = 0; i < REPLY_MESSAGE_TO_PI_REPLY_STATUS.length; ++i) {
            if (REPLY_MESSAGE_TO_PI_REPLY_STATUS[i] != replyStatus) continue;
            result = i;
            break;
        }
        return result;
    }

    @TraceInterceptor
    private ClientRequestInfoImpl peekClientRequestInfoImplStack() {
        RequestInfoStack<ClientRequestInfoImpl> infoStack = this.threadLocalClientRequestInfoStack.get();
        ClientRequestInfoImpl info = null;
        if (infoStack.empty()) {
            throw wrapper.clientInfoStackNull();
        }
        info = (ClientRequestInfoImpl)infoStack.peek();
        return info;
    }

    @TraceInterceptor
    private ServerRequestInfoImpl peekServerRequestInfoImplStack() {
        RequestInfoStack<ServerRequestInfoImpl> infoStack = this.threadLocalServerRequestInfoStack.get();
        ServerRequestInfoImpl info = null;
        if (infoStack.empty()) {
            throw wrapper.serverInfoStackNull();
        }
        info = (ServerRequestInfoImpl)infoStack.peek();
        return info;
    }

    @TraceInterceptor
    private boolean isClientPIEnabledForThisThread() {
        RequestInfoStack<ClientRequestInfoImpl> infoStack = this.threadLocalClientRequestInfoStack.get();
        return infoStack.disableCount == 0;
    }

    @TraceInterceptor
    private void preInitORBInitializers(ORBInitInfoImpl info) {
        info.setStage(0);
        for (int i = 0; i < this.orb.getORBData().getORBInitializers().length; ++i) {
            ORBInitializer init = this.orb.getORBData().getORBInitializers()[i];
            if (init == null) continue;
            try {
                init.pre_init((ORBInitInfo)info);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @TraceInterceptor
    private void postInitORBInitializers(ORBInitInfoImpl info) {
        info.setStage(1);
        for (int i = 0; i < this.orb.getORBData().getORBInitializers().length; ++i) {
            ORBInitializer init = this.orb.getORBData().getORBInitializers()[i];
            if (init == null) continue;
            try {
                init.post_init((ORBInitInfo)info);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @TraceInterceptor
    private ORBInitInfoImpl createORBInitInfo() {
        ORBInitInfoImpl result = null;
        String orbId = this.orb.getORBData().getORBId();
        result = new ORBInitInfoImpl(this.orb, this.arguments, orbId, this.codecFactory);
        return result;
    }

    @Override
    @TraceInterceptor
    public void register_interceptor(Interceptor interceptor, int type) throws DuplicateName {
        if (type >= 3 || type < 0) {
            throw wrapper.typeOutOfRange(type);
        }
        String interceptorName = interceptor.name();
        if (interceptorName == null) {
            throw wrapper.nameNull();
        }
        this.interceptorList.register_interceptor(interceptor, type);
    }

    @Override
    public Current getPICurrent() {
        return this.current;
    }

    private void nullParam() throws BAD_PARAM {
        throw orbutilWrapper.nullParam();
    }

    @Override
    @TraceInterceptor
    public Policy create_policy(int type, Any val) throws PolicyError {
        if (val == null) {
            this.nullParam();
        }
        if (this.policyFactoryTable == null) {
            throw new PolicyError("There is no PolicyFactory Registered for type " + type, 0);
        }
        PolicyFactory factory = this.policyFactoryTable.get(type);
        if (factory == null) {
            throw new PolicyError(" Could Not Find PolicyFactory for the Type " + type, 0);
        }
        Policy policy = factory.create_policy(type, val);
        return policy;
    }

    @Override
    @TraceInterceptor
    public void registerPolicyFactory(int type, PolicyFactory factory) {
        Integer key;
        PolicyFactory val;
        if (this.policyFactoryTable == null) {
            this.policyFactoryTable = new HashMap<Integer, PolicyFactory>();
        }
        if ((val = this.policyFactoryTable.get(key = Integer.valueOf(type))) != null) {
            throw omgWrapper.policyFactoryRegFailed(type);
        }
        this.policyFactoryTable.put(key, factory);
    }

    @Override
    public synchronized int allocateServerRequestId() {
        return this.serverRequestIdCounter++;
    }

    private static final class RequestInfoStack<C extends RequestInfoImpl>
    extends Stack<C> {
        public int disableCount = 0;

        private RequestInfoStack() {
        }

        @Override
        public boolean equals(java.lang.Object o) {
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }
}

