/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.returning;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.ReturningPolicy;
import org.eclipse.persistence.queries.DataModifyQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.sequencing.NativeSequence;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.tests.returning.ProjectAndDatabaseAdapter;
import org.eclipse.persistence.tools.schemaframework.DatabaseObjectDefinition;
import org.eclipse.persistence.tools.schemaframework.SchemaManager;
import org.eclipse.persistence.tools.schemaframework.SequenceObjectDefinition;

public class SubstituteSequencingWithReturningPolicyAdapter
implements ProjectAndDatabaseAdapter {
    protected Hashtable tableToField;
    protected Hashtable tableToSequence;
    protected boolean isReadOnly;

    public SubstituteSequencingWithReturningPolicyAdapter() {
        this(true);
    }

    public SubstituteSequencingWithReturningPolicyAdapter(boolean isReadOnly) {
        this(isReadOnly, true);
    }

    public SubstituteSequencingWithReturningPolicyAdapter(boolean isReadOnly, boolean useExistingSequenceName) {
        this.isReadOnly = isReadOnly;
        this.tableToField = new Hashtable();
        if (useExistingSequenceName) {
            this.tableToSequence = new Hashtable();
        }
    }

    public boolean usesExistingSequenceNames() {
        return this.tableToSequence != null;
    }

    @Override
    public boolean isOriginalSetupRequired() {
        return true;
    }

    @Override
    public void updateProject(Project project, Session session) {
        for (ClassDescriptor desc : project.getDescriptors().values()) {
            if (desc.isAggregateDescriptor()) continue;
            String sequenceName = desc.getSequenceNumberName();
            String fieldName = desc.getSequenceNumberFieldName();
            if (fieldName == null || sequenceName == null) continue;
            String tableName = desc.getTableName();
            int indexOfDot = fieldName.indexOf(46);
            if (indexOfDot != -1) {
                fieldName = fieldName.substring(indexOfDot + 1);
            }
            this.tableToField.put(tableName, fieldName);
            if (this.tableToSequence != null) {
                this.tableToSequence.put(tableName, sequenceName);
            }
            desc.setSequenceNumberFieldName(null);
            desc.setSequenceNumberName(null);
            String fieldQualifiedName = tableName + '.' + fieldName;
            desc.setReturningPolicy(new ReturningPolicy());
            if (this.isReadOnly) {
                desc.getReturningPolicy().addFieldForInsertReturnOnly(fieldQualifiedName);
                continue;
            }
            desc.getReturningPolicy().addFieldForInsert(fieldQualifiedName);
        }
    }

    @Override
    public void updateDatabase(Session session) {
        try {
            this.createSequences(session);
            this.replaceOrCreateTriggers(session);
        }
        finally {
            this.clear();
        }
    }

    public void createSequences(Session session) {
        if (!session.getPlatform().supportsSequenceObjects()) {
            throw new TestWarningException("Requires database platform that supports sequence objects (like Oracle) - they will be used by triggers");
        }
        SchemaManager schemaManager = new SchemaManager((DatabaseSession)session);
        Hashtable<String, SequenceObjectDefinition> sequenceNameToDefinition = new Hashtable<String, SequenceObjectDefinition>();
        Enumeration tableNames = this.tableToField.keys();
        while (tableNames.hasMoreElements()) {
            String tableName = (String)tableNames.nextElement();
            String sequenceName = this.getSequenceNameFromTableName(tableName);
            if (sequenceNameToDefinition.containsKey(sequenceName)) continue;
            SequenceObjectDefinition definition = new SequenceObjectDefinition((Sequence)new NativeSequence(sequenceName, 1, false));
            sequenceNameToDefinition.put(sequenceName, definition);
            schemaManager.createObject((DatabaseObjectDefinition)definition);
        }
    }

    public void replaceOrCreateTriggers(Session session) {
        if (!session.getPlatform().isOracle()) {
            throw new TestWarningException("Currently supports Oracle platform only");
        }
        Enumeration tableNames = this.tableToField.keys();
        while (tableNames.hasMoreElements()) {
            String tableName = (String)tableNames.nextElement();
            String fieldName = (String)this.tableToField.get(tableName);
            String sequenceName = this.getSequenceNameFromTableName(tableName);
            String triggerName = this.getTriggerNameFromTableName(tableName);
            String strCommand = "CREATE OR REPLACE TRIGGER " + triggerName + " BEFORE INSERT ON " + tableName + " FOR EACH ROW ";
            String strBegin = "BEGIN\n";
            String strIf = "  IF (:new." + fieldName + " IS NULL) OR (:new." + fieldName + " = 0) THEN\n  ";
            String strSeq = "  SELECT " + sequenceName + ".NEXTVAL INTO :new." + fieldName + " FROM DUAL;\n";
            String strEndIf = "  END IF;\n";
            String strEnd = "END;";
            String str = this.isReadOnly ? strCommand + strBegin + strSeq + strEnd : strCommand + strBegin + strIf + strSeq + strEndIf + strEnd;
            this.execute(session, str, true);
        }
    }

    public Map getTableToField() {
        return this.tableToField;
    }

    public Map getTableToSequence() {
        return this.tableToSequence;
    }

    protected String getSequenceNameFromTableName(String tableName) {
        String sequenceName = this.tableToSequence != null ? (String)this.tableToSequence.get(tableName) : tableName + "_SEQ";
        return sequenceName;
    }

    protected String getTriggerNameFromTableName(String tableName) {
        return tableName + "_TRIGGER";
    }

    protected void execute(Session session, String str, boolean shouldThrowException) {
        block2: {
            try {
                DataModifyQuery query = new DataModifyQuery(str);
                query.setShouldBindAllParameters(false);
                session.executeQuery((DatabaseQuery)query);
            }
            catch (Exception e) {
                if (!shouldThrowException) break block2;
                throw new TestErrorException("FAILED: " + str, (Throwable)e);
            }
        }
    }

    protected void clear() {
        this.tableToField.clear();
        if (this.tableToSequence != null) {
            this.tableToSequence.clear();
        }
    }
}

