/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.validation;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.IntegrityChecker;
import org.eclipse.persistence.internal.indirection.ProxyIndirectionPolicy;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.validation.ExceptionTest;
import org.eclipse.persistence.testing.tests.validation.InvalidAttributeTypeForProxyIndirectionTest;

public class InvalidSetMethodParameterTypeForProxyIndirectionTest
extends ExceptionTest {
    IntegrityChecker orgIntegrityChecker;
    Class attributeType = Employee.class;
    Class[] targetInterfaces = new Class[]{InvalidAttributeTypeForProxyIndirectionTest.class};
    OneToManyMapping mapping = new OneToManyMapping();

    public InvalidSetMethodParameterTypeForProxyIndirectionTest() {
        this.setDescription("This tests Invalid Set Method Parameter Type For Proxy Indirection (TL-ERROR 162)");
    }

    protected void setup() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(this.attributeType);
        this.mapping.setDescriptor((ClassDescriptor)descriptor);
        this.mapping.setAttributeName("manager");
        this.expectedException = DescriptorException.invalidSetMethodParameterTypeForProxyIndirection((Class)this.attributeType, (Class[])this.targetInterfaces, (DatabaseMapping)this.mapping);
        this.orgIntegrityChecker = this.getSession().getIntegrityChecker();
        this.getSession().setIntegrityChecker(new IntegrityChecker());
        this.getSession().getIntegrityChecker().dontCatchExceptions();
    }

    @Override
    public void reset() {
        if (this.orgIntegrityChecker != null) {
            this.getSession().setIntegrityChecker(this.orgIntegrityChecker);
        }
    }

    public void test() {
        ProxyIndirectionPolicy policy = new ProxyIndirectionPolicy();
        this.mapping.setReferenceClass(this.attributeType);
        this.mapping.addTargetForeignKeyFieldName("EMPLOYEE.MANAGER_ID", "EMPLOYEE.EMP_ID");
        policy.setMapping((DatabaseMapping)this.mapping);
        try {
            policy.validateSetMethodParameterType(this.attributeType, this.getSession().getIntegrityChecker());
        }
        catch (EclipseLinkException exception) {
            this.caughtException = exception;
        }
    }
}

