/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.plugin.hwlb;

import com.sun.corba.ee.impl.encoding.CDRInputObject;
import com.sun.corba.ee.impl.protocol.ClientRequestDispatcherImpl;
import com.sun.corba.ee.impl.transport.ConnectionCacheBase;
import com.sun.corba.ee.impl.transport.ConnectionImpl;
import com.sun.corba.ee.impl.transport.ContactInfoImpl;
import com.sun.corba.ee.impl.transport.ContactInfoListImpl;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.orb.DataCollector;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orb.ORBConfigurator;
import com.sun.corba.ee.spi.protocol.ClientRequestDispatcher;
import com.sun.corba.ee.spi.protocol.RequestDispatcherRegistry;
import com.sun.corba.ee.spi.trace.Transport;
import com.sun.corba.ee.spi.transport.Connection;
import com.sun.corba.ee.spi.transport.ContactInfo;
import com.sun.corba.ee.spi.transport.ContactInfoList;
import com.sun.corba.ee.spi.transport.ContactInfoListFactory;
import com.sun.corba.ee.spi.transport.OutboundConnectionCache;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.glassfish.pfl.tf.spi.annotation.InfoMethod;
import org.omg.CORBA.LocalObject;

@Transport
public class NoConnectionCacheImpl
extends LocalObject
implements ORBConfigurator {
    private static ThreadLocal connectionCache = new ThreadLocal();

    private static NCCConnectionCacheImpl getConnectionCache(ORB orb) {
        NCCConnectionCacheImpl result = (NCCConnectionCacheImpl)connectionCache.get();
        if (result == null) {
            result = new NCCConnectionCacheImpl(orb);
            connectionCache.set(result);
        }
        return result;
    }

    @Override
    public void configure(DataCollector dc, final ORB orb) {
        ContactInfoListFactory factory = new ContactInfoListFactory(){

            @Override
            public void setORB(ORB orb2) {
            }

            @Override
            public ContactInfoList create(IOR ior) {
                return new NCCContactInfoListImpl(orb, ior);
            }
        };
        orb.getORBData().alwaysEnterBlockingRead(false);
        orb.setCorbaContactInfoListFactory(factory);
        NCCClientRequestDispatcherImpl crd = new NCCClientRequestDispatcherImpl();
        RequestDispatcherRegistry rdr = orb.getRequestDispatcherRegistry();
        for (int ctr = 0; ctr < 63; ++ctr) {
            ClientRequestDispatcher disp = rdr.getClientRequestDispatcher(ctr);
            if (disp == null) continue;
            rdr.registerClientRequestDispatcher(crd, ctr);
        }
    }

    private static class NCCClientRequestDispatcherImpl
    extends ClientRequestDispatcherImpl {
        private NCCClientRequestDispatcherImpl() {
        }

        @Override
        public void endRequest(ORB broker, Object self, CDRInputObject inputObject) {
            super.endRequest(broker, self, inputObject);
            NoConnectionCacheImpl.getConnectionCache(broker).remove(null);
        }
    }

    public static class NCCContactInfoListImpl
    extends ContactInfoListImpl {
        public NCCContactInfoListImpl(ORB orb, IOR ior) {
            super(orb, ior);
        }

        @Override
        public ContactInfo createContactInfo(String type, String hostname, int port) {
            return new NCCContactInfoImpl(this.orb, this, this.effectiveTargetIOR, this.orb.getORBData().getGIOPAddressDisposition(), type, hostname, port);
        }
    }

    @Transport
    private static class NCCContactInfoImpl
    extends ContactInfoImpl {
        public NCCContactInfoImpl(ORB orb, ContactInfoList contactInfoList, IOR effectiveTargetIOR, short addressingDisposition, String socketType, String hostname, int port) {
            super(orb, contactInfoList, effectiveTargetIOR, addressingDisposition, socketType, hostname, port);
        }

        @Override
        @Transport
        public boolean shouldCacheConnection() {
            return false;
        }

        @InfoMethod
        private void createdConnection(Connection conn) {
        }

        @Override
        @Transport
        public Connection createConnection() {
            NCCConnectionImpl connection = new NCCConnectionImpl(this.orb, this, this.socketType, this.hostname, this.port);
            this.createdConnection(connection);
            NCCConnectionCacheImpl cc = NoConnectionCacheImpl.getConnectionCache(this.orb);
            cc.put(this, connection);
            connection.setConnectionCache(cc);
            return connection;
        }
    }

    @Transport
    private static class NCCConnectionImpl
    extends ConnectionImpl {
        private static int count = 0;
        private int myCount = count++;

        @Transport
        private void constructedNCCConnectionImpl(String str) {
        }

        public NCCConnectionImpl(ORB orb, ContactInfo contactInfo, String socketType, String hostname, int port) {
            super(orb, contactInfo, socketType, hostname, port);
            this.constructedNCCConnectionImpl(this.toString());
        }

        @Override
        public String toString() {
            return "NCCConnectionImpl(" + this.myCount + ")[" + super.toString() + "]";
        }

        @Override
        @Transport
        public synchronized void close() {
            super.closeConnectionResources();
        }
    }

    @Transport
    private static class NCCConnectionCacheImpl
    extends ConnectionCacheBase
    implements OutboundConnectionCache {
        private Map store = new HashMap();
        private Connection connection = null;

        public NCCConnectionCacheImpl(ORB orb) {
            super(orb, "Dummy", "Dummy");
        }

        @Override
        public Collection values() {
            return this.store.values();
        }

        @Override
        protected Object backingStore() {
            return this.store;
        }

        @Override
        public Connection get(ContactInfo contactInfo) {
            return this.connection;
        }

        @Override
        @Transport
        public void put(ContactInfo contactInfo, Connection conn) {
            this.remove(contactInfo);
            this.connection = conn;
        }

        @InfoMethod
        private void removeConnectionInfo(Connection conn) {
        }

        @InfoMethod
        private void connectionIsNull() {
        }

        @Override
        @Transport
        public void remove(ContactInfo contactInfo) {
            if (this.connection != null) {
                this.removeConnectionInfo(this.connection);
                this.connection.close();
                this.connection = null;
            } else {
                this.connectionIsNull();
            }
        }
    }
}

