/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.feature;

import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeProject;

public class ReconnectFlushStatementCacheTest
extends AutoVerifyTestCase {
    protected DatabaseSession session = null;
    protected Exception reestablishErrorException = null;
    protected Exception logoutErrorException = null;

    public ReconnectFlushStatementCacheTest() {
        this.setDescription("Ensure the statement cache gets flushed on a reconnect.");
    }

    public void setup() {
        ((DatabaseSession)this.getSession()).logout();
        DatabaseLogin login = (DatabaseLogin)this.getSession().getLogin().clone();
        EmployeeProject project = new EmployeeProject();
        project.setLogin(login);
        this.session = project.createDatabaseSession();
        this.session.setSessionLog(this.getSession().getSessionLog());
        this.session.login();
    }

    public void test() {
        this.session.getLogin().bindAllParameters();
        this.session.getLogin().cacheAllStatements();
        ExpressionBuilder builder = new ExpressionBuilder();
        ReadAllQuery query = new ReadAllQuery(Employee.class, builder);
        Expression exp = builder.get("firstName").equal(builder.getParameter("NAME"));
        query.setSelectionCriteria(exp);
        query.addArgument("NAME");
        Vector<String> params = new Vector<String>();
        params.addElement("Bob");
        Vector result = (Vector)this.session.executeQuery((DatabaseQuery)query, params);
        ((DatabaseAccessor)((AbstractSession)this.session).getAccessor()).closeConnection();
        ((DatabaseAccessor)((AbstractSession)this.session).getAccessor()).reestablishConnection((AbstractSession)this.session);
        try {
            result = (Vector)this.session.executeQuery((DatabaseQuery)query, params);
        }
        catch (Exception exception) {
            this.reestablishErrorException = exception;
        }
        this.session.logout();
        this.session.login();
        try {
            result = (Vector)this.session.executeQuery((DatabaseQuery)query, params);
        }
        catch (Exception exception) {
            this.logoutErrorException = exception;
        }
    }

    public void verify() {
        if (this.reestablishErrorException != null) {
            throw new TestErrorException("The statement cache was not properly flushed when a connection was reestablished.");
        }
        if (this.logoutErrorException != null) {
            throw new TestErrorException("The statement cache was not properly flushed when a connection was disconnected.");
        }
    }

    public void reset() {
        this.session.logout();
        ((DatabaseSession)this.getSession()).login();
    }
}

