/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.mapping;

import java.math.BigDecimal;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.mapping.Baby;
import org.eclipse.persistence.testing.models.mapping.BabyMonitor;
import org.eclipse.persistence.testing.models.mapping.Crib;

public class TwoLevelJoinedAttributeTest
extends AutoVerifyTestCase {
    protected int cribMonitorUseJoining;
    protected int babyCribUseJoining;
    protected BigDecimal babyId = null;
    protected Baby baby = null;

    public TwoLevelJoinedAttributeTest() {
        this.setDescription("Ensure objects that use joining to two levels execute join queries properly.");
    }

    public void setup() {
        this.beginTransaction();
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Baby populationBaby = new Baby();
        populationBaby.setName("Bobby");
        BabyMonitor monitor = new BabyMonitor();
        monitor.setBrandName("Nokia");
        monitor.setBaby(populationBaby);
        Crib crib = new Crib();
        crib.setColor("yellow");
        crib.setBabyMonitor(monitor);
        crib.setBaby(populationBaby);
        monitor.setCrib(crib);
        populationBaby.setBabyMonitor(monitor);
        populationBaby.setCrib(crib);
        uow.registerObject((Object)populationBaby);
        uow.commit();
        this.babyId = populationBaby.getId();
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        ClassDescriptor descriptor = this.getSession().getClassDescriptor(Baby.class);
        this.babyCribUseJoining = ((OneToOneMapping)descriptor.getMappingForAttributeName("crib")).getJoinFetch();
        ((OneToOneMapping)descriptor.getMappingForAttributeName("crib")).useInnerJoinFetch();
        descriptor.reInitializeJoinedAttributes();
        descriptor = this.getSession().getClassDescriptor(Crib.class);
        this.cribMonitorUseJoining = ((OneToOneMapping)descriptor.getMappingForAttributeName("babyMonitor")).getJoinFetch();
        ((OneToOneMapping)descriptor.getMappingForAttributeName("babyMonitor")).useInnerJoinFetch();
        descriptor.reInitializeJoinedAttributes();
    }

    public void test() {
        ExpressionBuilder babys = new ExpressionBuilder();
        Expression expression = babys.get("id").equal((Object)this.babyId);
        this.baby = (Baby)this.getSession().readObject(Baby.class, expression);
    }

    public void verify() {
        if (this.baby.getCrib() == null || this.baby.getCrib().getBabyMonitor() == null) {
            throw new TestErrorException("TopLink did not properly process multiple levels of joining within  descriptors.");
        }
    }

    public void reset() {
        this.rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        ClassDescriptor descriptor = this.getSession().getClassDescriptor(Baby.class);
        ((OneToOneMapping)descriptor.getMappingForAttributeName("crib")).setJoinFetch(this.babyCribUseJoining);
        descriptor.reInitializeJoinedAttributes();
        descriptor = this.getSession().getClassDescriptor(Crib.class);
        ((OneToOneMapping)descriptor.getMappingForAttributeName("babyMonitor")).setJoinFetch(this.cribMonitorUseJoining);
        descriptor.reInitializeJoinedAttributes();
    }
}

