/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.workbenchintegration.ExpressionPersistence;

import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class ExpressionPersistenceTest
extends AutoVerifyTestCase {
    protected DatabaseQuery basicQuery;
    protected DatabaseQuery systemQuery;
    protected String queryName;

    public ExpressionPersistenceTest(String queryName, DatabaseQuery query) {
        this.basicQuery = query;
        this.queryName = queryName;
        this.setName(this.getName() + ":" + queryName);
        this.setDescription("Test that expressions persisted by the WorkBench in the deployent XML works correctly");
    }

    public void setup() {
        if ((this.queryName.startsWith("AddStandardDeviationReportQuery") || this.queryName.startsWith("AddVarianceReportQuery")) && (this.getSession().getPlatform().isSybase() || this.getSession().getPlatform().isSQLAnywhere() || this.getSession().getPlatform().isSQLServer()) || this.getSession().getPlatform().isDB2() || this.getSession().getPlatform().isDerby() || this.getSession().getPlatform().isSymfoware()) {
            throw new TestWarningException("The test is not supported on this database.");
        }
    }

    public void test() {
        this.getSession().executeQuery(this.basicQuery);
        this.systemQuery = this.getSession().getDescriptor(Employee.class).getQueryManager().getQuery(this.queryName);
        this.getSession().executeQuery(this.systemQuery);
    }

    public void verify() {
        if (!this.basicQuery.getCall().getSQLString().equals(this.systemQuery.getCall().getSQLString())) {
            throw new TestErrorException("Persisted query not the same as original");
        }
    }
}

