/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.advanced;

import jakarta.persistence.EntityManager;
import jakarta.persistence.LockModeType;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.advanced.Address;
import org.eclipse.persistence.testing.models.jpa.advanced.AdvancedTableCreator;

public class PessimisticLockEntityRefreshTestSuite
extends JUnitTestCase {
    public PessimisticLockEntityRefreshTestSuite(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("PessimisticLocking Entity Refresh TestSuite");
        if (!PessimisticLockEntityRefreshTestSuite.isJPA10()) {
            suite.addTest((Test)new PessimisticLockEntityRefreshTestSuite("testSetup"));
            suite.addTest((Test)new PessimisticLockEntityRefreshTestSuite("testPessimisticWriteLockFind"));
            suite.addTest((Test)new PessimisticLockEntityRefreshTestSuite("testPessimisticReadLockFind"));
            suite.addTest((Test)new PessimisticLockEntityRefreshTestSuite("testPessimisticForceIncrementLockFind"));
            suite.addTest((Test)new PessimisticLockEntityRefreshTestSuite("testPessimisticReadLockAndNormalFind"));
            suite.addTest((Test)new PessimisticLockEntityRefreshTestSuite("testPessimisticWriteLockAndNormalFind"));
            suite.addTest((Test)new PessimisticLockEntityRefreshTestSuite("testPessimisticForceIncrementLockAndNormalFind"));
            suite.addTest((Test)new PessimisticLockEntityRefreshTestSuite("testPessimisticReadThenWriteLockFind"));
            suite.addTest((Test)new PessimisticLockEntityRefreshTestSuite("testPessimisticWriteThenReadLockFind"));
            suite.addTest((Test)new PessimisticLockEntityRefreshTestSuite("testPessimisticForceIncrementThenReadLockFind"));
            suite.addTest((Test)new PessimisticLockEntityRefreshTestSuite("testPessimisticForceIncrementThenWriteLockFind"));
            suite.addTest((Test)new PessimisticLockEntityRefreshTestSuite("testPessimisticWriteLockFindAndLock"));
            suite.addTest((Test)new PessimisticLockEntityRefreshTestSuite("testPessimisticReadLockFindAndLock"));
            suite.addTest((Test)new PessimisticLockEntityRefreshTestSuite("testPessimisticForceIncrementLockFindAndLock"));
            suite.addTest((Test)new PessimisticLockEntityRefreshTestSuite("testPessimisticReadLockAndNormalFindAndLock"));
            suite.addTest((Test)new PessimisticLockEntityRefreshTestSuite("testPessimisticWriteLockAndNormalFindAndLock"));
            suite.addTest((Test)new PessimisticLockEntityRefreshTestSuite("testPessimisticForceIncrementLockAndNormalFindAndLock"));
            suite.addTest((Test)new PessimisticLockEntityRefreshTestSuite("testPessimisticReadThenWriteLockFindAndLock"));
            suite.addTest((Test)new PessimisticLockEntityRefreshTestSuite("testPessimisticWriteThenReadLockFindAndLock"));
            suite.addTest((Test)new PessimisticLockEntityRefreshTestSuite("testPessimisticForceIncrementThenReadLockFindAndLock"));
            suite.addTest((Test)new PessimisticLockEntityRefreshTestSuite("testPessimisticForceIncrementThenWriteLockFindAndLock"));
        }
        return suite;
    }

    public void testSetup() {
        ServerSession session = JUnitTestCase.getServerSession();
        new AdvancedTableCreator().replaceTables((DatabaseSession)session);
        this.clearCache();
    }

    public void testPessimisticReadLockAndNormalFind() {
        this.doFindWithLockModes(LockModeType.PESSIMISTIC_READ, LockModeType.NONE);
    }

    public void testPessimisticWriteLockAndNormalFind() {
        this.doFindWithLockModes(LockModeType.PESSIMISTIC_WRITE, LockModeType.NONE);
    }

    public void testPessimisticForceIncrementLockAndNormalFind() {
        this.doFindWithLockModes(LockModeType.PESSIMISTIC_WRITE, LockModeType.NONE);
    }

    public void testPessimisticReadLockFind() {
        this.doFindWithLockModes(LockModeType.PESSIMISTIC_READ, LockModeType.PESSIMISTIC_READ);
    }

    public void testPessimisticWriteLockFind() {
        this.doFindWithLockModes(LockModeType.PESSIMISTIC_WRITE, LockModeType.PESSIMISTIC_WRITE);
    }

    public void testPessimisticForceIncrementLockFind() {
        this.doFindWithLockModes(LockModeType.PESSIMISTIC_FORCE_INCREMENT, LockModeType.PESSIMISTIC_FORCE_INCREMENT);
    }

    public void testPessimisticReadThenWriteLockFind() {
        this.doFindWithLockModes(LockModeType.PESSIMISTIC_READ, LockModeType.PESSIMISTIC_WRITE);
    }

    public void testPessimisticWriteThenReadLockFind() {
        this.doFindWithLockModes(LockModeType.PESSIMISTIC_WRITE, LockModeType.PESSIMISTIC_READ);
    }

    public void testPessimisticForceIncrementThenReadLockFind() {
        this.doFindWithLockModes(LockModeType.PESSIMISTIC_FORCE_INCREMENT, LockModeType.PESSIMISTIC_READ);
    }

    public void testPessimisticForceIncrementThenWriteLockFind() {
        this.doFindWithLockModes(LockModeType.PESSIMISTIC_FORCE_INCREMENT, LockModeType.PESSIMISTIC_WRITE);
    }

    public void testPessimisticReadLockAndNormalFindAndLock() {
        this.doFindAndLockWithLockModes(LockModeType.PESSIMISTIC_READ, LockModeType.NONE);
    }

    public void testPessimisticWriteLockAndNormalFindAndLock() {
        this.doFindAndLockWithLockModes(LockModeType.PESSIMISTIC_WRITE, LockModeType.NONE);
    }

    public void testPessimisticForceIncrementLockAndNormalFindAndLock() {
        this.doFindAndLockWithLockModes(LockModeType.PESSIMISTIC_WRITE, LockModeType.NONE);
    }

    public void testPessimisticReadLockFindAndLock() {
        this.doFindAndLockWithLockModes(LockModeType.PESSIMISTIC_READ, LockModeType.PESSIMISTIC_READ);
    }

    public void testPessimisticWriteLockFindAndLock() {
        this.doFindAndLockWithLockModes(LockModeType.PESSIMISTIC_WRITE, LockModeType.PESSIMISTIC_WRITE);
    }

    public void testPessimisticForceIncrementLockFindAndLock() {
        this.doFindAndLockWithLockModes(LockModeType.PESSIMISTIC_FORCE_INCREMENT, LockModeType.PESSIMISTIC_FORCE_INCREMENT);
    }

    public void testPessimisticReadThenWriteLockFindAndLock() {
        this.doFindAndLockWithLockModes(LockModeType.PESSIMISTIC_READ, LockModeType.PESSIMISTIC_WRITE);
    }

    public void testPessimisticWriteThenReadLockFindAndLock() {
        this.doFindAndLockWithLockModes(LockModeType.PESSIMISTIC_WRITE, LockModeType.PESSIMISTIC_READ);
    }

    public void testPessimisticForceIncrementThenReadLockFindAndLock() {
        this.doFindAndLockWithLockModes(LockModeType.PESSIMISTIC_FORCE_INCREMENT, LockModeType.PESSIMISTIC_READ);
    }

    public void testPessimisticForceIncrementThenWriteLockFindAndLock() {
        this.doFindAndLockWithLockModes(LockModeType.PESSIMISTIC_FORCE_INCREMENT, LockModeType.PESSIMISTIC_WRITE);
    }

    public void doFindWithLockModes(LockModeType lockMode1, LockModeType lockMode2) {
        if (!this.isSelectForUpateSupported()) {
            return;
        }
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Address entity = new Address("Wellington St.", "Ottawa", "ON", "Canada", "K1A0A6");
            em.persist((Object)entity);
            em.flush();
            int entityId = entity.getID();
            entity = (Address)em.find(Address.class, (Object)entityId, lockMode1);
            PessimisticLockEntityRefreshTestSuite.assertNotNull((String)"Test data: entity should not be null", (Object)entity);
            entity.setCountry("changed");
            Address entityRetrievedAgain = (Address)em.find(Address.class, (Object)entityId, lockMode2);
            PessimisticLockEntityRefreshTestSuite.assertNotNull((String)"Test data: entity retrieved again should not be null", (Object)entityRetrievedAgain);
            PessimisticLockEntityRefreshTestSuite.assertTrue((String)"Same entity instance should be returned from find", (entity == entityRetrievedAgain ? 1 : 0) != 0);
            PessimisticLockEntityRefreshTestSuite.assertEquals((String)"Field value is expected to be the same", (String)"changed", (String)entityRetrievedAgain.getCountry());
            PessimisticLockEntityRefreshTestSuite.assertEquals((String)"Version field is expected to be the same", (Object)entity.getVersion(), (Object)entityRetrievedAgain.getVersion());
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            this.closeEntityManagerAndTransaction(em);
        }
    }

    public void doFindAndLockWithLockModes(LockModeType lockMode1, LockModeType lockMode2) {
        if (!this.isSelectForUpateSupported()) {
            return;
        }
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Address entity = new Address("Wellington St.", "Ottawa", "ON", "Canada", "K1A0A6");
            em.persist((Object)entity);
            em.flush();
            int entityId = entity.getID();
            entity = (Address)em.find(Address.class, (Object)entityId);
            em.lock((Object)entity, lockMode1);
            PessimisticLockEntityRefreshTestSuite.assertNotNull((String)"Test data: entity should not be null", (Object)entity);
            entity.setCountry("changed");
            Address entityRetrievedAgain = (Address)em.find(Address.class, (Object)entityId);
            em.lock((Object)entityRetrievedAgain, lockMode2);
            PessimisticLockEntityRefreshTestSuite.assertNotNull((String)"Test data: entity retrieved again should not be null", (Object)entityRetrievedAgain);
            PessimisticLockEntityRefreshTestSuite.assertTrue((String)"Same entity instance should be returned from find", (entity == entityRetrievedAgain ? 1 : 0) != 0);
            PessimisticLockEntityRefreshTestSuite.assertEquals((String)"Field value is expected to be the same", (String)"changed", (String)entityRetrievedAgain.getCountry());
            PessimisticLockEntityRefreshTestSuite.assertEquals((String)"Version field is expected to be the same", (Object)entity.getVersion(), (Object)entityRetrievedAgain.getVersion());
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            this.closeEntityManagerAndTransaction(em);
        }
    }
}

