/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.fieldaccess.advanced;

import jakarta.persistence.EntityManager;
import jakarta.persistence.OptimisticLockException;
import java.util.Arrays;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.queries.AttributeGroup;
import org.eclipse.persistence.sessions.CopyGroup;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.Address;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.AdvancedTableCreator;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.Child;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.Golfer;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.GolferPK;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.Man;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.Parent;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.PartnerLink;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.Vegetable;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.VegetablePK;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.Woman;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.WorldRank;

public class AdvancedJunitTest
extends JUnitTestCase {
    public AdvancedJunitTest() {
    }

    public AdvancedJunitTest(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.clearCache();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("AdvancedJunitTest");
        suite.addTest((Test)new AdvancedJunitTest("testSetup"));
        suite.addTest((Test)new AdvancedJunitTest("testGF1818"));
        suite.addTest((Test)new AdvancedJunitTest("testGF1894"));
        suite.addTest((Test)new AdvancedJunitTest("testGF894"));
        suite.addTest((Test)new AdvancedJunitTest("testManAndWoman"));
        suite.addTest((Test)new AdvancedJunitTest("testStringArrayField"));
        suite.addTest((Test)new AdvancedJunitTest("testBUG241388"));
        suite.addTest((Test)new AdvancedJunitTest("testZeroId"));
        suite.addTest((Test)new AdvancedJunitTest("testLazyToInterface"));
        return suite;
    }

    public String getPersistenceUnitName() {
        return "fieldaccess";
    }

    public void testSetup() {
        new AdvancedTableCreator().replaceTables((DatabaseSession)this.getDatabaseSession());
        this.clearCache();
    }

    public void testGF1818() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Vegetable vegetable = new Vegetable();
            vegetable.setId(new VegetablePK("Carrot", "Orange"));
            vegetable.setCost(2.09);
            em.persist((Object)vegetable);
            this.commitTransaction(em);
        }
        catch (Exception e) {
            AdvancedJunitTest.fail((String)("An exception was caught: [" + e.getMessage() + "]"));
        }
        this.closeEntityManager(em);
    }

    public void testGF1894() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Employee emp = new Employee();
        emp.setFirstName("Guy");
        emp.setLastName("Pelletier");
        Address address = new Address();
        address.setCity("College Town");
        emp.setAddress(address);
        try {
            Employee empClone = (Employee)em.merge((Object)emp);
            AdvancedJunitTest.assertNotNull((String)"The id field for the merged new employee object was not generated.", (Object)empClone.getId());
            this.commitTransaction(em);
            Employee empFromDB = (Employee)em.find(Employee.class, (Object)empClone.getId());
            AdvancedJunitTest.assertNotNull((String)"The version locking field for the merged new employee object was not updated after commit.", (Object)empFromDB.getVersion());
            this.beginTransaction(em);
            Employee empClone2 = (Employee)em.merge((Object)empFromDB);
            AdvancedJunitTest.assertTrue((String)"The id field on a existing merged employee object was modified on a subsequent merge.", (boolean)empFromDB.getId().equals(empClone2.getId()));
            this.commitTransaction(em);
        }
        catch (OptimisticLockException e) {
            AdvancedJunitTest.fail((String)"An optimistic locking exception was caught on the merge of a new object. An insert should of occurred instead.");
        }
        this.closeEntityManager(em);
    }

    public void testZeroId() {
        EntityManager entityManager = this.createEntityManager();
        this.beginTransaction(entityManager);
        Golfer golfer = (Golfer)entityManager.find(Golfer.class, (Object)new GolferPK(0));
        WorldRank rank = (WorldRank)entityManager.find(WorldRank.class, (Object)0);
        if (golfer != null) {
            entityManager.remove((Object)golfer);
        }
        if (rank != null) {
            entityManager.remove((Object)rank);
        }
        this.commitTransaction(entityManager);
        this.beginTransaction(entityManager);
        rank = new WorldRank();
        rank.setId(0);
        entityManager.persist((Object)rank);
        this.commitTransaction(entityManager);
        AdvancedJunitTest.assertTrue((String)"Zero id assigned sequence value.", (rank.getId() == 0 ? 1 : 0) != 0);
        this.closeEntityManager(entityManager);
        this.clearCache();
        entityManager = this.createEntityManager();
        this.beginTransaction(entityManager);
        rank = new WorldRank();
        rank.setId(0);
        rank = (WorldRank)entityManager.merge((Object)rank);
        this.commitTransaction(entityManager);
        AdvancedJunitTest.assertTrue((String)"Zero id assigned sequence value.", (rank.getId() == 0 ? 1 : 0) != 0);
        this.beginTransaction(entityManager);
        rank = (WorldRank)entityManager.find(WorldRank.class, (Object)0);
        AdvancedJunitTest.assertTrue((String)"Zero id assigned sequence value.", (rank.getId() == 0 ? 1 : 0) != 0);
        entityManager.remove((Object)rank);
        this.commitTransaction(entityManager);
        this.closeEntityManager(entityManager);
    }

    public void testGF894() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            int i = 0;
            while (true) {
                GolferPK golferPK;
                Golfer golfer;
                if ((golfer = (Golfer)em.find(Golfer.class, (Object)(golferPK = new GolferPK(i)))) == null) {
                    golfer = new Golfer();
                    golfer.setGolferPK(golferPK);
                    WorldRank worldRank = new WorldRank();
                    worldRank.setId(i);
                    golfer.setWorldRank(worldRank);
                    em.persist((Object)worldRank);
                    em.persist((Object)golfer);
                    this.commitTransaction(em);
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            AdvancedJunitTest.fail((String)("An exception was caught: [" + e.getMessage() + "]"));
        }
        this.closeEntityManager(em);
    }

    public void testManAndWoman() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            PartnerLink pLink1 = new PartnerLink();
            pLink1.setMan(new Man());
            em.persist((Object)pLink1);
            PartnerLink pLink2 = new PartnerLink();
            pLink2.setWoman(new Woman());
            em.persist((Object)pLink2);
            PartnerLink pLink3 = new PartnerLink();
            pLink3.setMan(new Man());
            pLink3.setWoman(new Woman());
            em.persist((Object)pLink3);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            AdvancedJunitTest.fail((String)("An exception was caught: [" + e.getMessage() + "]"));
        }
        this.closeEntityManager(em);
    }

    public void testStringArrayField() {
        Vegetable vegetable;
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        VegetablePK pk = new VegetablePK("Tomato", "Red");
        Object[] tags = new String[]{"California", "XE"};
        try {
            vegetable = new Vegetable();
            vegetable.setId(pk);
            vegetable.setCost(2.09);
            vegetable.setTags((String[])tags);
            em.persist((Object)vegetable);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        finally {
            this.closeEntityManager(em);
        }
        em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            vegetable = (Vegetable)em.find(Vegetable.class, (Object)pk);
            this.commitTransaction(em);
            AdvancedJunitTest.assertNotNull((Object)vegetable);
            AdvancedJunitTest.assertTrue((boolean)Arrays.equals(tags, vegetable.getTags()));
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBUG241388() {
        int childCount;
        Integer id;
        block5: {
            Parent pa;
            id = null;
            EntityManager em1 = this.createEntityManager();
            this.beginTransaction(em1);
            try {
                Parent p0 = new Parent(false);
                em1.persist((Object)p0);
                em1.flush();
                id = p0.getId();
                Parent p1 = (Parent)em1.find(Parent.class, (Object)id);
                p1.setSerialNumber("12345678");
                Child cs_1_1 = new Child();
                p1.addChild(cs_1_1);
                em1.flush();
                Child cs_1_2 = new Child();
                p1.addChild(cs_1_2);
                em1.flush();
                Parent chassis2 = (Parent)em1.find(Parent.class, (Object)id);
                Child cs_2_1 = new Child();
                chassis2.addChild(cs_2_1);
                em1.flush();
                this.commitTransaction(em1);
                pa = (Parent)em1.find(Parent.class, (Object)id);
                childCount = pa.getChildren().size();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.rollbackTransaction(em1);
                break block5;
            }
            finally {
                pa = (Parent)em1.find(Parent.class, id);
                childCount = pa.getChildren().size();
                this.closeEntityManager(em1);
            }
            this.closeEntityManager(em1);
        }
        Parent chassis = (Parent)this.createEntityManager().find(Parent.class, (Object)id);
        AdvancedJunitTest.assertTrue((String)"The same number of children where not returned from the cache", (childCount == chassis.getChildren().size() ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLazyToInterface() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Parent parent = null;
        Child child = null;
        try {
            parent = new Parent(false);
            child = (Child)parent.getChildren().get(0);
            em.persist((Object)parent);
            this.commitTransaction(em);
        }
        finally {
            this.closeEntityManagerAndTransaction(em);
        }
        this.clearCache();
        em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            child = (Child)em.find(Child.class, (Object)child.getId());
            ((JpaEntityManager)em.getDelegate()).copy((Object)child, (AttributeGroup)new CopyGroup());
            this.commitTransaction(em);
        }
        finally {
            this.closeEntityManagerAndTransaction(em);
        }
    }
}

