/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import org.eclipse.persistence.exceptions.JPQLException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.jpa.parsing.AliasableNode;
import org.eclipse.persistence.internal.jpa.parsing.AttributeNode;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.LogicalOperatorNode;
import org.eclipse.persistence.internal.jpa.parsing.MapKeyNode;
import org.eclipse.persistence.internal.jpa.parsing.Node;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.internal.jpa.parsing.TypeHelper;
import org.eclipse.persistence.internal.jpa.parsing.VariableNode;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReportQuery;

public class DotNode
extends LogicalOperatorNode
implements AliasableNode {
    private Object enumConstant;

    @Override
    public void applyToQuery(ObjectLevelReadQuery theQuery, GenerationContext context) {
        if (theQuery.isReportQuery()) {
            ReportQuery reportQuery = (ReportQuery)theQuery;
            reportQuery.addAttribute(this.resolveAttribute(), this.generateExpression(context));
            reportQuery.dontRetrievePrimaryKeys();
        }
    }

    @Override
    public Node qualifyAttributeAccess(ParseTreeContext context) {
        if (this.getLeft() != null) {
            this.setLeft(this.getLeft().qualifyAttributeAccess(context));
        }
        return this;
    }

    @Override
    public void validate(ParseTreeContext context) {
        TypeHelper typeHelper = context.getTypeHelper();
        String name = ((AttributeNode)this.right).getAttributeName();
        Node leftMost = this.getLeftMostNode();
        if (this.isDeclaredVariable(leftMost, context)) {
            Node path;
            this.left.validate(context);
            this.checkNavigation(this.left, context);
            Object type = null;
            if (this.left.isVariableNode() && (path = context.pathForVariable(((VariableNode)this.left).getVariableName())) != null) {
                type = path.getType();
                type = typeHelper.resolveAttribute(type, name);
            }
            if (type == null) {
                type = typeHelper.resolveAttribute(this.left.getType(), name);
            }
            if (type == null) {
                throw JPQLException.unknownAttribute(context.getQueryInfo(), this.right.getLine(), this.right.getColumn(), name, typeHelper.getTypeName(this.left.getType()));
            }
            if (this.right.isAttributeNode()) {
                type = ((AttributeNode)this.right).computeActualType(type, typeHelper);
                ((AttributeNode)this.right).checkForQueryKey(this.left.getType(), typeHelper);
            }
            this.setType(type);
            this.right.setType(type);
        } else {
            String typeName = this.left.getAsString();
            Object type = this.resolveEnumTypeName(typeName, typeHelper);
            if (type != null && typeHelper.isEnumType(type)) {
                this.enumConstant = typeHelper.resolveEnumConstant(type, name);
                if (this.enumConstant == null) {
                    throw JPQLException.invalidEnumLiteral(context.getQueryInfo(), this.right.getLine(), this.right.getColumn(), typeName, name);
                }
            } else {
                throw JPQLException.aliasResolutionException(context.getQueryInfo(), leftMost.getLine(), leftMost.getColumn(), leftMost.getAsString());
            }
            this.setType(type);
            this.right.setType(type);
        }
    }

    private void checkNavigation(Node node, ParseTreeContext context) {
        Object type;
        TypeHelper typeHelper = context.getTypeHelper();
        if (!(typeHelper.isEntityClass(type = node.getType()) || typeHelper.isEmbeddable(type) || typeHelper.isEnumType(type))) {
            throw JPQLException.invalidNavigation(context.getQueryInfo(), node.getLine(), node.getColumn(), this.getAsString(), node.getAsString(), typeHelper.getTypeName(type));
        }
        if (node.isDotNode()) {
            Node left = node.getLeft();
            AttributeNode right = (AttributeNode)node.getRight();
            if (typeHelper.isCollectionValuedRelationship(left.getType(), right.getAttributeName())) {
                throw JPQLException.invalidCollectionNavigation(context.getQueryInfo(), right.getLine(), right.getColumn(), this.getAsString(), right.getAttributeName());
            }
        }
    }

    private boolean isDeclaredVariable(Node node, ParseTreeContext context) {
        if (node.isVariableNode()) {
            String name = ((VariableNode)node).getCanonicalVariableName();
            return context.isVariable(name);
        }
        return false;
    }

    @Override
    public Expression generateExpression(GenerationContext context) {
        Node right = this.getRight();
        if (this.enumConstant != null) {
            return new ConstantExpression(this.enumConstant, new ExpressionBuilder());
        }
        Expression whereClause = this.getLeft().generateExpression(context);
        if (right.isAttributeNode()) {
            ((AttributeNode)right).setMapping(this.resolveMapping(context));
        }
        whereClause = right.addToExpression(whereClause, context);
        if (this.alias != null) {
            context.addExpression(whereClause, this.alias);
        }
        return whereClause;
    }

    @Override
    public boolean isDotNode() {
        return true;
    }

    public boolean endsWithDirectToField(GenerationContext context) {
        DatabaseMapping mapping = this.resolveMapping(context);
        return mapping != null && mapping.isDirectToFieldMapping();
    }

    public Class getTypeOfDirectToField(GenerationContext context) {
        DatabaseMapping mapping = this.resolveMapping(context);
        if (mapping != null && mapping.isDirectToFieldMapping()) {
            return ((AbstractDirectMapping)mapping).getAttributeClassification();
        }
        return null;
    }

    public Object getTypeForMapKey(ParseTreeContext context) {
        Object type = null;
        String name = ((AttributeNode)this.right).getAttributeName();
        Node leftMost = this.getLeftMostNode();
        if (this.isDeclaredVariable(leftMost, context)) {
            type = context.getTypeHelper().resolveMapKey(this.left.getType(), name);
        }
        return type;
    }

    public boolean endsWithCollectionField(GenerationContext context) {
        DatabaseMapping mapping = this.resolveMapping(context);
        return mapping != null && mapping.isCollectionMapping();
    }

    @Override
    public String resolveAttribute() {
        return ((AttributeNode)this.getRight()).getAttributeName();
    }

    @Override
    public DatabaseMapping resolveMapping(GenerationContext context) {
        Class leftClass = this.getLeft().resolveClass(context);
        return this.getRight().resolveMapping(context, leftClass);
    }

    @Override
    public Class resolveClass(GenerationContext context) {
        Class leftClass = this.getLeft().resolveClass(context);
        return this.getRight().resolveClass(context, leftClass);
    }

    @Override
    public String getAsString() {
        return this.left.getAsString() + "." + this.right.getAsString();
    }

    public Node getLeftMostNode() {
        if (this.left.isDotNode()) {
            return ((DotNode)this.left).getLeftMostNode();
        }
        if (this.left.isMapKeyNode()) {
            return ((MapKeyNode)this.left).getLeftMostNode();
        }
        return this.left;
    }

    public Node getRightMostNode() {
        if (this.right.isDotNode()) {
            return ((DotNode)this.right).getRightMostNode();
        }
        return this.right;
    }

    private Object resolveEnumTypeName(String name, TypeHelper helper) {
        int index;
        Object type = helper.resolveTypeName(name);
        if (type == null && (index = name.lastIndexOf(46)) != -1) {
            name = name.substring(0, index) + '$' + name.substring(index + 1);
            type = helper.resolveTypeName(name);
        }
        return type;
    }

    @Override
    public boolean isAliasableNode() {
        return true;
    }
}

