/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.server.was;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.platform.server.ServerPlatformDetector;

public class WebSpherePlatformDetector
implements ServerPlatformDetector {
    private static final String[] LIBERTY_PROPS = new String[]{"server.config.dir", "server.output.dir"};
    private static final String LIBERTY_PROFILE_INFO_INT = "com.ibm.websphere.config.mbeans.FeatureListMBean";
    private static final String FULL_PROFILE_WAS_DIR_CLS = "com.ibm.websphere.product.WASDirectory";

    @Override
    public String checkPlatform() {
        if (this.isLiberty()) {
            return "WebSphere_Liberty";
        }
        if (this.isFullProfile()) {
            return "WebSphere_7";
        }
        return null;
    }

    private boolean isLiberty() {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return WebSpherePlatformDetector.this.isLibertyInternal();
                }
            });
        }
        return this.isLibertyInternal();
    }

    private boolean isFullProfile() {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return WebSpherePlatformDetector.this.isFullProfileInternal();
                }
            });
        }
        return this.isFullProfileInternal();
    }

    private Boolean isLibertyInternal() {
        return this.checkProperties(LIBERTY_PROPS) != false || this.checkClassLoader(LIBERTY_PROFILE_INFO_INT) != false;
    }

    private Boolean isFullProfileInternal() {
        return this.checkClassLoader(FULL_PROFILE_WAS_DIR_CLS);
    }

    private Boolean checkProperties(String[] props) {
        for (String prop : props) {
            if (System.getProperty(prop) != null) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Boolean checkClassLoader(String className) {
        try {
            ClassLoader loader = WebSpherePlatformDetector.class.getClassLoader();
            Class<?> cls = loader.loadClass(className);
            if (cls != null) {
                return Boolean.TRUE;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Boolean.FALSE;
    }
}

