/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.coordination.corba;

import java.io.IOException;
import java.net.InetAddress;
import javax.naming.Context;
import org.eclipse.persistence.exceptions.RemoteCommandManagerException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.SerializationHelper;
import org.eclipse.persistence.internal.sessions.coordination.RemoteConnection;
import org.eclipse.persistence.internal.sessions.coordination.corba.CORBAConnection;
import org.eclipse.persistence.internal.sessions.coordination.corba.CORBARemoteCommandConnection;
import org.eclipse.persistence.sessions.coordination.Command;
import org.eclipse.persistence.sessions.coordination.RemoteCommandManager;
import org.eclipse.persistence.sessions.coordination.ServiceId;
import org.eclipse.persistence.sessions.coordination.TransportManager;
import org.omg.CORBA.Object;

public abstract class CORBATransportManager
extends TransportManager {
    public CORBATransportManager(RemoteCommandManager rcm) {
        this.rcm = rcm;
        this.initialize();
    }

    public void initialize() {
        super.initialize();
        if (this.rcm.getServiceId().getURL() == null) {
            this.rcm.getServiceId().setURL(this.getDefaultLocalUrl());
        }
        this.namingServiceType = 0;
        this.setInitialContextFactoryName(this.getDefaultInitialContextFactoryName());
    }

    public String getDefaultLocalUrl() {
        try {
            String localHost = InetAddress.getLocalHost().getHostName();
            return "iiop://" + localHost + ":" + "23791";
        }
        catch (IOException exception) {
            throw RemoteCommandManagerException.errorGettingHostName((Exception)exception);
        }
    }

    public void removeLocalConnection() {
        String unbindName = null;
        try {
            if (this.namingServiceType != 0) {
                return;
            }
            unbindName = this.rcm.getServiceId().getId();
            this.getContext(this.getLocalContextProperties()).unbind(unbindName);
        }
        catch (Exception exception) {
            this.rcm.handleException((RuntimeException)RemoteCommandManagerException.errorUnbindingLocalConnection(unbindName, (Exception)exception));
        }
        this.localConnection = null;
    }

    public int getNamingServiceType() {
        return 0;
    }

    public abstract String getDefaultInitialContextFactoryName();

    public abstract CORBAConnection narrow(Object var1);

    public abstract CORBAConnection buildCORBAConnection();

    public RemoteConnection createConnection(ServiceId connectionServiceId) {
        CORBARemoteCommandConnection connection = null;
        java.lang.Object[] args = new java.lang.Object[]{connectionServiceId.getId(), connectionServiceId.getURL()};
        this.rcm.logDebug("looking_up_remote_conn_in_jndi", args);
        try {
            Context context = this.getRemoteHostContext(connectionServiceId.getURL());
            CORBAConnection connectionImpl = this.narrow((Object)context.lookup(connectionServiceId.getId()));
            connection = new CORBARemoteCommandConnection(connectionImpl);
            connection.setServiceId(connectionServiceId);
        }
        catch (Exception e) {
            this.rcm.handleException((RuntimeException)RemoteCommandManagerException.errorLookingUpRemoteConnection((String)connectionServiceId.getId(), (String)connectionServiceId.getURL(), (Exception)e));
        }
        return connection;
    }

    public static byte[] processCommand(byte[] command, RemoteCommandManager rcm) {
        try {
            if (rcm.getSerializer() != null) {
                rcm.processCommandFromRemoteConnection(command);
            } else {
                Command deserializedCmd = (Command)SerializationHelper.deserialize((byte[])command);
                rcm.processCommandFromRemoteConnection(deserializedCmd);
            }
        }
        catch (Exception e) {
            java.lang.Object[] args = new java.lang.Object[]{Helper.getShortClassName((java.lang.Object)command), Helper.printStackTraceToString((Throwable)e)};
            rcm.logWarning("error_executing_remote_command", args);
            return e.toString().getBytes();
        }
        return null;
    }

    public void createLocalConnection() {
        CORBAConnection connectionImpl = this.buildCORBAConnection();
        java.lang.Object[] args = new java.lang.Object[]{this.rcm.getServiceId().getId()};
        this.rcm.logDebug("register_local_connection_in_jndi", args);
        try {
            this.getRemoteHostContext(this.rcm.getUrl()).rebind(this.rcm.getServiceId().getId(), (java.lang.Object)connectionImpl);
        }
        catch (Exception exception) {
            this.rcm.handleException((RuntimeException)RemoteCommandManagerException.errorBindingConnection((String)this.rcm.getServiceId().toString(), (Exception)exception));
            return;
        }
        this.localConnection = new CORBARemoteCommandConnection(connectionImpl);
        this.localConnection.setServiceId(this.rcm.getServiceId());
    }
}

