/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.client.admin;

import java.net.URI;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import oracle.kv.impl.client.admin.ClientAdminServiceAPI;
import oracle.kv.impl.security.login.LoginManager;
import oracle.kv.impl.topo.StorageNode;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.registry.RegistryUtils;

class FindClientAdminService {
    private final List<StorageNodeId> inspected = new ArrayList<StorageNodeId>();
    private final List<StorageNodeId> problematic = new ArrayList<StorageNodeId>();
    private final RegistryUtils regUtils;
    private final Logger logger;
    private final LoginManager loginManager;
    private ClientAdminServiceAPI foundService;

    FindClientAdminService(Topology topo, Logger logger, LoginManager loginManager) {
        this.logger = logger;
        this.loginManager = loginManager;
        this.regUtils = new RegistryUtils(topo, loginManager);
        for (StorageNode sn : topo.getSortedStorageNodes()) {
            StorageNodeId snId = (StorageNodeId)sn.getResourceId();
            try {
                String[] bound;
                logger.fine("Checking sn " + snId);
                Registry reg = this.regUtils.getRegistry(snId);
                this.inspected.add(snId);
                for (String boundName : bound = reg.list()) {
                    if (!boundName.equals("admin:CLIENT_ADMIN")) continue;
                    this.foundService = this.connectDDL(snId);
                    if (this.foundService == null) continue;
                    return;
                }
            }
            catch (RemoteException e) {
                this.problematic.add(snId);
            }
        }
    }

    private ClientAdminServiceAPI connectDDL(StorageNodeId hostingSNId) {
        ClientAdminServiceAPI ddlService = null;
        try {
            ddlService = this.regUtils.getAdminDDL(hostingSNId);
            if (ddlService.canHandleDDL()) {
                return ddlService;
            }
            URI rmiaddr = ddlService.getMasterRmiAddress();
            if (rmiaddr == null) {
                return null;
            }
            this.logger.fine("DDL redirecting to master at " + rmiaddr);
            String adminHostname = rmiaddr.getHost();
            int adminRegistryPort = rmiaddr.getPort();
            ddlService = RegistryUtils.getAdminDDL(adminHostname, adminRegistryPort, this.loginManager);
            if (ddlService.canHandleDDL()) {
                return ddlService;
            }
        }
        catch (RemoteException re) {
            this.logger.fine("Couldn't connect to ClientAdmin service on admin on " + hostingSNId);
        }
        catch (NotBoundException nbe) {
            this.logger.fine("Couldn't connect to ClientAdmin service on admin on " + hostingSNId);
        }
        return null;
    }

    ClientAdminServiceAPI getDDLService() {
        return this.foundService;
    }

    public String getTargets() {
        StringBuilder sb = new StringBuilder();
        sb.append("Inspected nodes: ").append(this.inspected).append("\n");
        sb.append("experienced problems at: ").append(this.problematic);
        return sb.toString();
    }

    List<StorageNodeId> getInspected() {
        return this.inspected;
    }

    List<StorageNodeId> getProblematic() {
        return this.problematic;
    }
}

