/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.QueryControlBlock;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.compiler.SortSpec;
import oracle.kv.impl.query.compiler.StaticContext;
import oracle.kv.impl.query.types.ExprType;

class ExprSort
extends Expr {
    private Expr theInput;
    private int[] theSortFieldPositions;
    private SortSpec[] theSortSpecs;

    ExprSort(QueryControlBlock qcb, StaticContext sctx, QueryException.Location loc, int[] sortFieldPositions, SortSpec[] sortSpecs) {
        super(qcb, sctx, Expr.ExprKind.SORT, loc);
        this.theSortFieldPositions = sortFieldPositions;
        this.theSortSpecs = sortSpecs;
    }

    void setInput(Expr newExpr, boolean destroy) {
        if (this.theInput != null) {
            this.theInput.removeParent(this, destroy);
        }
        this.theInput = newExpr;
        this.theInput.addParent(this);
        this.theType = this.computeType();
        this.setLocation(newExpr.getLocation());
    }

    @Override
    int getNumChildren() {
        return 1;
    }

    @Override
    Expr getInput() {
        return this.theInput;
    }

    int[] getSortFieldPositions() {
        return this.theSortFieldPositions;
    }

    SortSpec[] getSortSpecs() {
        return this.theSortSpecs;
    }

    @Override
    ExprType computeType() {
        return this.theInput.getType();
    }

    @Override
    public boolean mayReturnNULL() {
        return this.theInput.mayReturnNULL();
    }

    @Override
    void displayContent(StringBuilder sb, QueryFormatter formatter) {
        formatter.indent(sb);
        sb.append("Sort Field Positions : ").append(this.theSortFieldPositions);
        sb.append(",\n");
        formatter.indent(sb);
        this.theInput.display(sb, formatter);
    }
}

