/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import java.util.ArrayList;
import oracle.kv.impl.query.compiler.FuncAndOr;
import oracle.kv.impl.query.compiler.FuncAnyOp;
import oracle.kv.impl.query.compiler.FuncArithOp;
import oracle.kv.impl.query.compiler.FuncArithUnaryOp;
import oracle.kv.impl.query.compiler.FuncAvg;
import oracle.kv.impl.query.compiler.FuncCompOp;
import oracle.kv.impl.query.compiler.FuncConcat;
import oracle.kv.impl.query.compiler.FuncCount;
import oracle.kv.impl.query.compiler.FuncCountStar;
import oracle.kv.impl.query.compiler.FuncCurrentTime;
import oracle.kv.impl.query.compiler.FuncCurrentTimeMillis;
import oracle.kv.impl.query.compiler.FuncExists;
import oracle.kv.impl.query.compiler.FuncExpirationTime;
import oracle.kv.impl.query.compiler.FuncExpirationTimeMillis;
import oracle.kv.impl.query.compiler.FuncExtractFromTimestamp;
import oracle.kv.impl.query.compiler.FuncGeoDistance;
import oracle.kv.impl.query.compiler.FuncGeoIsGeometry;
import oracle.kv.impl.query.compiler.FuncGeoSearch;
import oracle.kv.impl.query.compiler.FuncIsNull;
import oracle.kv.impl.query.compiler.FuncMinMax;
import oracle.kv.impl.query.compiler.FuncNot;
import oracle.kv.impl.query.compiler.FuncParseJson;
import oracle.kv.impl.query.compiler.FuncRemainingDays;
import oracle.kv.impl.query.compiler.FuncRemainingHours;
import oracle.kv.impl.query.compiler.FuncRowVersion;
import oracle.kv.impl.query.compiler.FuncSeqAggr;
import oracle.kv.impl.query.compiler.FuncSize;
import oracle.kv.impl.query.compiler.FuncSum;
import oracle.kv.impl.query.compiler.Function;
import oracle.kv.impl.query.compiler.StaticContext;
import oracle.kv.impl.query.types.ExprType;
import oracle.kv.impl.query.types.TypeManager;

public class FunctionLib {
    ArrayList<Function> theFunctions = new ArrayList(64);

    FunctionLib(StaticContext sctx) {
        this.theFunctions.add(new FuncAndOr(FuncCode.OP_AND, "AND"));
        this.theFunctions.add(new FuncAndOr(FuncCode.OP_OR, "OR"));
        this.theFunctions.add(new FuncCompOp(FuncCode.OP_EQ, "EQ"));
        this.theFunctions.add(new FuncCompOp(FuncCode.OP_NEQ, "NEQ"));
        this.theFunctions.add(new FuncCompOp(FuncCode.OP_GT, "GT"));
        this.theFunctions.add(new FuncCompOp(FuncCode.OP_GE, "GE"));
        this.theFunctions.add(new FuncCompOp(FuncCode.OP_LT, "LT"));
        this.theFunctions.add(new FuncCompOp(FuncCode.OP_LE, "LE"));
        this.theFunctions.add(new FuncAnyOp(FuncCode.OP_EQ_ANY, "EQ_ANY"));
        this.theFunctions.add(new FuncAnyOp(FuncCode.OP_NEQ_ANY, "NEQ_ANY"));
        this.theFunctions.add(new FuncAnyOp(FuncCode.OP_GT_ANY, "GT_ANY"));
        this.theFunctions.add(new FuncAnyOp(FuncCode.OP_GE_ANY, "GE_ANY"));
        this.theFunctions.add(new FuncAnyOp(FuncCode.OP_LT_ANY, "LT_ANY"));
        this.theFunctions.add(new FuncAnyOp(FuncCode.OP_LE_ANY, "LE_ANY"));
        this.theFunctions.add(new FuncArithOp(FuncCode.OP_ADD_SUB, "+-"));
        this.theFunctions.add(new FuncArithOp(FuncCode.OP_MULT_DIV, "*/"));
        this.theFunctions.add(new FuncArithUnaryOp(FuncCode.OP_ARITH_UNARY, "-"));
        this.theFunctions.add(new FuncConcat());
        this.theFunctions.add(new FuncExists(FuncCode.OP_EXISTS, "EXISTS"));
        this.theFunctions.add(new FuncExists(FuncCode.OP_NOT_EXISTS, "NOT_EXISTS"));
        this.theFunctions.add(new FuncNot());
        this.theFunctions.add(new FuncSize());
        this.theFunctions.add(new FuncIsNull(FuncCode.OP_IS_NULL, "IS_NULL"));
        this.theFunctions.add(new FuncIsNull(FuncCode.OP_IS_NOT_NULL, "IS_NOT_NULL"));
        this.theFunctions.add(new FuncExtractFromTimestamp(FuncCode.FN_YEAR, "year"));
        this.theFunctions.add(new FuncExtractFromTimestamp(FuncCode.FN_MONTH, "month"));
        this.theFunctions.add(new FuncExtractFromTimestamp(FuncCode.FN_DAY, "day"));
        this.theFunctions.add(new FuncExtractFromTimestamp(FuncCode.FN_HOUR, "hour"));
        this.theFunctions.add(new FuncExtractFromTimestamp(FuncCode.FN_MINUTE, "minute"));
        this.theFunctions.add(new FuncExtractFromTimestamp(FuncCode.FN_SECOND, "second"));
        this.theFunctions.add(new FuncExtractFromTimestamp(FuncCode.FN_MILLISECOND, "millisecond"));
        this.theFunctions.add(new FuncExtractFromTimestamp(FuncCode.FN_MICROSECOND, "microsecond"));
        this.theFunctions.add(new FuncExtractFromTimestamp(FuncCode.FN_NANOSECOND, "nanosecond"));
        this.theFunctions.add(new FuncExtractFromTimestamp(FuncCode.FN_WEEK, "week"));
        this.theFunctions.add(new FuncExtractFromTimestamp(FuncCode.FN_ISOWEEK, "isoweek"));
        this.theFunctions.add(new FuncCurrentTime());
        this.theFunctions.add(new FuncCurrentTimeMillis());
        this.theFunctions.add(new FuncExpirationTime());
        this.theFunctions.add(new FuncExpirationTimeMillis());
        this.theFunctions.add(new FuncRemainingHours());
        this.theFunctions.add(new FuncRemainingDays());
        this.theFunctions.add(new FuncRowVersion());
        this.theFunctions.add(new FuncCountStar());
        this.theFunctions.add(new FuncCount(FuncCode.FN_COUNT, "count"));
        this.theFunctions.add(new FuncCount(FuncCode.FN_COUNT_NUMBERS, "count_numbers"));
        this.theFunctions.add(new FuncSum());
        this.theFunctions.add(new FuncAvg());
        this.theFunctions.add(new FuncMinMax(FuncCode.FN_MIN, "min"));
        this.theFunctions.add(new FuncMinMax(FuncCode.FN_MAX, "max"));
        this.theFunctions.add(new FuncSeqAggr(FuncCode.FN_SEQ_COUNT, "seq_count"));
        this.theFunctions.add(new FuncSeqAggr(FuncCode.FN_SEQ_SUM, "seq_sum"));
        this.theFunctions.add(new FuncSeqAggr(FuncCode.FN_SEQ_AVG, "seq_avg"));
        this.theFunctions.add(new FuncSeqAggr(FuncCode.FN_SEQ_MIN, "seq_min"));
        this.theFunctions.add(new FuncSeqAggr(FuncCode.FN_SEQ_MAX, "seq_max"));
        ArrayList<ExprType> geoTypes = new ArrayList<ExprType>(2);
        geoTypes.add(TypeManager.JSON_STAR());
        geoTypes.add(TypeManager.JSON_STAR());
        this.theFunctions.add(new FuncGeoSearch(FuncCode.FN_GEO_INTERSECT, "geo_intersect", geoTypes));
        this.theFunctions.add(new FuncGeoSearch(FuncCode.FN_GEO_INSIDE, "geo_inside", geoTypes));
        geoTypes = new ArrayList(3);
        geoTypes.add(TypeManager.ANY_STAR());
        geoTypes.add(TypeManager.ANY_STAR());
        geoTypes.add(TypeManager.DOUBLE_ONE());
        this.theFunctions.add(new FuncGeoSearch(FuncCode.FN_GEO_NEAR, "geo_near", geoTypes));
        this.theFunctions.add(new FuncGeoSearch(FuncCode.FN_GEO_WITHIN_DISTANCE, "geo_within_distance", geoTypes));
        this.theFunctions.add(new FuncGeoDistance());
        this.theFunctions.add(new FuncGeoIsGeometry());
        this.theFunctions.add(new FuncParseJson());
        for (Function func : this.theFunctions) {
            sctx.addFunction(func);
        }
    }

    Function getFunc(FuncCode c) {
        return this.theFunctions.get(c.ordinal());
    }

    public static enum FuncCode {
        OP_AND,
        OP_OR,
        OP_EQ,
        OP_NEQ,
        OP_GT,
        OP_GE,
        OP_LT,
        OP_LE,
        OP_EQ_ANY,
        OP_NEQ_ANY,
        OP_GT_ANY,
        OP_GE_ANY,
        OP_LT_ANY,
        OP_LE_ANY,
        OP_ADD_SUB,
        OP_MULT_DIV,
        OP_ARITH_UNARY,
        FN_SEQ_CONCAT,
        OP_EXISTS,
        OP_NOT_EXISTS,
        OP_NOT,
        FN_SIZE,
        OP_IS_NULL,
        OP_IS_NOT_NULL,
        FN_YEAR,
        FN_MONTH,
        FN_DAY,
        FN_HOUR,
        FN_MINUTE,
        FN_SECOND,
        FN_MILLISECOND,
        FN_MICROSECOND,
        FN_NANOSECOND,
        FN_WEEK,
        FN_ISOWEEK,
        FN_CURRENT_TIME,
        FN_CURRENT_TIME_MILLIS,
        FN_EXPIRATION_TIME,
        FN_EXPIRATION_TIME_MILLIS,
        FN_REMAINING_HOURS,
        FN_REMAINING_DAYS,
        FN_ROW_VERSION,
        FN_COUNT_STAR,
        FN_COUNT,
        FN_COUNT_NUMBERS,
        FN_SUM,
        FN_AVG,
        FN_MIN,
        FN_MAX,
        FN_SEQ_COUNT,
        FN_SEQ_SUM,
        FN_SEQ_AVG,
        FN_SEQ_MIN,
        FN_SEQ_MAX,
        FN_GEO_INTERSECT,
        FN_GEO_INSIDE,
        FN_GEO_NEAR,
        FN_GEO_WITHIN_DISTANCE,
        FN_GEO_DISTANCE,
        FN_GEO_IS_GEOMETRY,
        FN_PARSE_JSON;

        private static final FuncCode[] VALUES;

        public static FuncCode valueOf(int ordinal) {
            return VALUES[ordinal];
        }

        static {
            VALUES = FuncCode.values();
        }
    }
}

