/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.runtime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.runtime.PlanIterState;
import oracle.kv.impl.query.runtime.RuntimeControlBlock;
import oracle.kv.impl.query.runtime.ServerIterFactory;
import oracle.kv.impl.util.SerializationUtil;

public class DeleteRowIter
extends PlanIter {
    protected final String theNamespace;
    protected final String theTableName;
    protected final PlanIter theInput;
    protected final boolean theHasReturningClause;
    protected final int[] thePrimKeyPositions;

    public DeleteRowIter(Expr e, int resultReg, TableImpl table, PlanIter input, boolean hasReturningClause, int[] primKeyPositions) {
        super(e, resultReg);
        this.theNamespace = table.getInternalNamespace();
        this.theTableName = table.getFullName();
        this.theInput = input;
        this.theHasReturningClause = hasReturningClause;
        this.thePrimKeyPositions = primKeyPositions;
    }

    public DeleteRowIter(DeleteRowIter parent) {
        super(parent.theStatePos, parent.theResultReg, parent.getLocation());
        this.theNamespace = parent.theNamespace;
        this.theTableName = parent.theTableName;
        this.theInput = parent.theInput;
        this.theHasReturningClause = parent.theHasReturningClause;
        this.thePrimKeyPositions = parent.thePrimKeyPositions;
    }

    public DeleteRowIter(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.theNamespace = SerializationUtil.readString(in, serialVersion);
        this.theTableName = SerializationUtil.readString(in, serialVersion);
        this.theInput = DeleteRowIter.deserializeIter(in, serialVersion);
        this.theHasReturningClause = in.readBoolean();
        this.thePrimKeyPositions = DeleteRowIter.deserializeIntArray(in, serialVersion);
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        SerializationUtil.writeString(out, serialVersion, this.theNamespace);
        SerializationUtil.writeString(out, serialVersion, this.theTableName);
        DeleteRowIter.serializeIter(this.theInput, out, serialVersion);
        out.writeBoolean(this.theHasReturningClause);
        DeleteRowIter.serializeIntArray(this.thePrimKeyPositions, out, serialVersion);
    }

    @Override
    public PlanIter.PlanIterKind getKind() {
        return PlanIter.PlanIterKind.DELETE_ROW;
    }

    @Override
    public void open(RuntimeControlBlock rcb) {
        ServerIterFactory serverIterFactory = rcb.getServerIterFactory();
        if (serverIterFactory != null) {
            PlanIter worker = serverIterFactory.createDeleteRowIter(rcb, this);
            worker.open(rcb);
        } else {
            rcb.setState(this.theStatePos, new DeleteRowState(null));
        }
    }

    @Override
    public void reset(RuntimeControlBlock rcb) {
        DeleteRowState state = (DeleteRowState)rcb.getState(this.theStatePos);
        if (state.theWorkerIter != null) {
            state.theWorkerIter.reset(rcb);
        }
    }

    @Override
    public void close(RuntimeControlBlock rcb) {
        DeleteRowState state = (DeleteRowState)rcb.getState(this.theStatePos);
        if (state == null) {
            return;
        }
        if (state.theWorkerIter != null) {
            state.theWorkerIter.close(rcb);
        }
    }

    @Override
    public boolean next(RuntimeControlBlock rcb) {
        DeleteRowState state = (DeleteRowState)rcb.getState(this.theStatePos);
        if (state.theWorkerIter != null) {
            return state.theWorkerIter.next(rcb);
        }
        if (state.isDone()) {
            return false;
        }
        if (this.theHasReturningClause) {
            state.done();
            return false;
        }
        rcb.setRegVal(this.theResultReg, FieldDefImpl.longDef.createLong(0L));
        state.done();
        return true;
    }

    @Override
    protected void displayContent(StringBuilder sb, QueryFormatter formatter) {
        if (this.thePrimKeyPositions != null) {
            formatter.indent(sb);
            sb.append("Primary Key Positions : ");
            for (int i = 0; i < this.thePrimKeyPositions.length; ++i) {
                sb.append(this.thePrimKeyPositions[i]);
                if (i >= this.thePrimKeyPositions.length - 1) continue;
                sb.append(", ");
            }
            sb.append(",\n");
        }
        this.theInput.display(sb, formatter);
    }

    public static class DeleteRowState
    extends PlanIterState {
        PlanIter theWorkerIter;

        public DeleteRowState(PlanIter worker) {
            this.theWorkerIter = worker;
        }
    }
}

