/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util.sklogger;

import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import oracle.kv.impl.util.sklogger.MetricFamilySamples;
import oracle.kv.impl.util.sklogger.RateMetric;
import oracle.kv.impl.util.sklogger.StatsData;

public class SizeQuantile
extends RateMetric<RateResult, Element> {
    private static final double[] DEFAULT_QUANTILES = new double[]{0.5, 0.95, 0.99};
    private static final int DEFAULT_VAL = 0;
    private final double[] quantiles;

    public SizeQuantile(String name, String ... labelNames) {
        this(name, DEFAULT_QUANTILES, labelNames);
    }

    public SizeQuantile(String name, double[] quantiles, String ... labelNames) {
        super(name, labelNames);
        if (quantiles == null || quantiles.length == 0) {
            throw new IllegalArgumentException("quantiles cannot be empty");
        }
        this.quantiles = quantiles;
        this.initializeNoLabelsElement();
    }

    @Override
    protected Element newElement() {
        return new Element(this.quantiles);
    }

    public void observe(int v) {
        ((Element)this.noLabelsElement).observe(v);
    }

    public void observe(int v, int times) {
        ((Element)this.noLabelsElement).observe(v, times);
    }

    @Override
    public MetricFamilySamples<RateResult> collect() {
        return this.collect(StatsData.Type.SIZE_QUANTILE);
    }

    @Override
    public MetricFamilySamples<RateResult> collectSinceLastTime(String watcherName) {
        return this.collectSinceLastTime(StatsData.Type.SIZE_QUANTILE, watcherName);
    }

    private static final class Frugal2UQuantiles {
        private final Quantile[] quantiles;

        private Frugal2UQuantiles(Quantile[] quantiles) {
            this.quantiles = quantiles;
        }

        private Frugal2UQuantiles(double[] quantiles) {
            this.quantiles = new Quantile[quantiles.length];
            for (int i = 0; i < quantiles.length; ++i) {
                this.quantiles[i] = new Quantile(quantiles[i]);
            }
        }

        private synchronized void observe(int value) {
            for (Quantile q : this.quantiles) {
                q.observe(value);
            }
        }

        private int[] getQuantileValues() {
            int[] quantileValues = new int[this.quantiles.length];
            for (int i = 0; i < quantileValues.length; ++i) {
                quantileValues[i] = this.quantiles[i].estimatedVal;
            }
            return quantileValues;
        }

        private static class Quantile {
            private int estimatedVal = 0;
            private final double q;
            private int step = 1;
            private int sign = 0;
            private Random r = new Random();

            Quantile(double quantile) {
                this.q = quantile;
            }

            private void observe(int item) {
                if (this.sign == 0) {
                    this.estimatedVal = item;
                    this.sign = 1;
                    return;
                }
                if (item > this.estimatedVal && this.r.nextDouble() > 1.0 - this.q) {
                    this.step += this.sign * this.f(this.step);
                    this.estimatedVal = this.step > 0 ? (this.estimatedVal += this.step) : ++this.estimatedVal;
                    if (this.estimatedVal > item) {
                        this.step += item - this.estimatedVal;
                        this.estimatedVal = item;
                    }
                    if (this.sign < 0) {
                        this.step = 1;
                    }
                    this.sign = 1;
                } else if (item < this.estimatedVal && this.r.nextDouble() > this.q) {
                    this.step += -this.sign * this.f(this.step);
                    this.estimatedVal = this.step > 0 ? (this.estimatedVal -= this.step) : --this.estimatedVal;
                    if (this.estimatedVal < item) {
                        this.step += this.estimatedVal - item;
                        this.estimatedVal = item;
                    }
                    if (this.sign > 0) {
                        this.step = 1;
                    }
                    this.sign = -1;
                }
            }

            private int f(int currentStep) {
                return 1;
            }
        }
    }

    private static class WatchersQuantiles {
        private final double[] quantiles;
        private final Map<String, Frugal2UQuantiles> watchersBuffer;
        private final Frugal2UQuantiles wholeStream;

        public WatchersQuantiles(double[] quantiles) {
            this.quantiles = quantiles;
            this.watchersBuffer = new ConcurrentHashMap<String, Frugal2UQuantiles>();
            this.wholeStream = new Frugal2UQuantiles(quantiles);
        }

        public int[] getQuantileValues() {
            return this.wholeStream.getQuantileValues();
        }

        public int[] getQuantileValues(String watcherName) {
            Frugal2UQuantiles watcherStream = this.watchersBuffer.put(watcherName, new Frugal2UQuantiles(this.quantiles));
            if (watcherStream == null) {
                return this.wholeStream.getQuantileValues();
            }
            return watcherStream.getQuantileValues();
        }

        public void observe(int value) {
            this.wholeStream.observe(value);
            for (Frugal2UQuantiles fQuantiles : this.watchersBuffer.values()) {
                fQuantiles.observe(value);
            }
        }
    }

    public static class RateResult
    extends RateMetric.RateResult {
        private static final long serialVersionUID = 1L;
        private final long sum;
        private final double[] quantiles;
        private final int[] quantileValues;

        public RateResult(long duration, long sum, double[] quantiles, int[] quantileValues) {
            super(duration);
            this.sum = sum;
            this.quantiles = quantiles;
            this.quantileValues = quantileValues;
        }

        public long getSum() {
            return this.sum;
        }

        public double[] getQuantile() {
            return this.quantiles;
        }

        public int[] getQuantileValues() {
            return this.quantileValues;
        }

        @Override
        public Map<String, Object> toMap() {
            Map<String, Object> map = super.toMap();
            map.put("sum", this.sum);
            for (int i = 0; i < this.quantiles.length; ++i) {
                String key = "quantile_" + this.quantiles[i];
                map.put(key, this.quantileValues[i]);
            }
            return map;
        }
    }

    public static final class Element
    extends RateMetric.Element<RateResult> {
        private AtomicLong sum;
        private final WatchersQuantiles watchersQuantiles;
        private final ConcurrentHashMap<String, HistoryItem> watchers;
        private final double[] quantiles;

        private Element(double[] quantiles) {
            this.quantiles = quantiles;
            this.sum = new AtomicLong();
            this.watchersQuantiles = new WatchersQuantiles(quantiles);
            this.watchers = new ConcurrentHashMap();
            this.initialTime = System.nanoTime();
        }

        public void observe(int v) {
            this.observe(v, 1);
        }

        public void observe(int v, int times) {
            this.sum.addAndGet(v * times);
            for (int i = 0; i < times; ++i) {
                this.watchersQuantiles.observe(v);
            }
        }

        @Override
        public RateResult rate() {
            int[] quantileValues = this.watchersQuantiles.getQuantileValues();
            return new RateResult(System.nanoTime() - this.initialTime, this.sum.get(), this.quantiles, quantileValues);
        }

        @Override
        public RateResult rateSinceLastTime(String watcherName) {
            long currentTime = System.nanoTime();
            long currentSum = this.sum.get();
            long lastSum = 0L;
            long lastTime = this.initialTime;
            HistoryItem historyItem = this.watchers.get(watcherName);
            if (historyItem != null) {
                lastTime = historyItem.lastTime;
                lastSum = historyItem.lastSum;
                historyItem.lastTime = currentTime;
                historyItem.lastSum = currentSum;
            } else {
                this.watchers.put(watcherName, new HistoryItem(currentTime, currentSum));
            }
            int[] quantileValues = this.watchersQuantiles.getQuantileValues(watcherName);
            return new RateResult(currentTime - lastTime, currentSum - lastSum, this.quantiles, quantileValues);
        }

        private static final class HistoryItem {
            private long lastTime;
            private long lastSum;

            private HistoryItem(long time, long sum) {
                this.lastTime = time;
                this.lastSum = sum;
            }
        }
    }
}

