/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.interfaces;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.interfaces.InterfaceHashtableProject;

public class DescriptorInitTest
extends TestCase {
    public Project project;
    public DatabaseSession dbsession;

    public DescriptorInitTest() {
        this.setName("DescriptorInitTest");
        this.setDescription("Tests initialization of descriptors while adding during enumeration.");
    }

    public void reset() {
        ((DatabaseSession)this.getSession()).login();
    }

    public void setup() {
        this.project = new InterfaceHashtableProject();
        this.project.setLogin((DatabaseLogin)this.getSession().getLogin().clone());
        this.dbsession = this.project.createDatabaseSession();
        this.dbsession.setSessionLog(this.getSession().getSessionLog());
        ((DatabaseSession)this.getSession()).logout();
    }

    public void test() {
        for (ClassDescriptor descriptor : this.project.getDescriptors().values()) {
            String part2;
            String part1;
            String className = descriptor.getJavaClass().toString();
            Character ch = new Character(className.charAt(className.length() - 2));
            if (ch.equals(new Character('0'))) {
                part1 = className.substring(6, className.length() - 3);
                part2 = className.substring(className.length() - 3);
            } else if (Character.isDigit(ch.charValue())) {
                part1 = className.substring(6, className.length() - 2);
                part2 = className.substring(className.length() - 2);
            } else {
                part1 = className.substring(6, className.length() - 1);
                part2 = className.substring(className.length() - 1);
            }
            String interfaceName = part1 + "I" + part2;
            try {
                descriptor.getInterfacePolicy().addParentInterface(Class.forName(interfaceName));
            }
            catch (Throwable e) {
                throw new TestErrorException("Specified class was not found: " + interfaceName);
            }
        }
        this.dbsession.login();
        this.dbsession.logout();
    }

    public void verify() {
        for (ClassDescriptor descriptor : this.project.getDescriptors().values()) {
            if (descriptor.isFullyInitialized()) continue;
            throw new TestErrorException("Descriptor \"" + descriptor + "\" is NOT INITIALIZED");
        }
    }
}

