/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.performance.jdbc;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Vector;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.testing.framework.PerformanceComparisonTestCase;
import org.eclipse.persistence.testing.framework.TestCase;

public class TimestampTest
extends PerformanceComparisonTestCase {
    protected Connection connection;
    protected Number id;
    protected String sql;

    public TimestampTest() {
        this.setName("getTimestamp vs getString PerformanceComparisonTest");
        this.setDescription("Compares the performance between accessing timestamps as objects vs as strings.");
        this.addGetString();
        this.addGetDATE();
    }

    public void setup() throws Exception {
        this.connection = (Connection)((AbstractSession)this.getSession()).getAccessor().getDatasourceConnection();
        this.sql = "SELECT START_DATE FROM EMPLOYEE";
    }

    public void test() throws Exception {
        PreparedStatement statement = this.connection.prepareStatement(this.sql);
        ResultSet result = statement.executeQuery();
        int size = result.getMetaData().getColumnCount();
        Vector rows = new Vector();
        while (result.next()) {
            Vector<Object> row = new Vector<Object>(size);
            for (int column = 1; column <= size; ++column) {
                row.add(result.getObject(column));
            }
            rows.add(row);
        }
        result.close();
        statement.close();
    }

    public void addGetString() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() throws Exception {
                PreparedStatement statement = TimestampTest.this.connection.prepareStatement(TimestampTest.this.sql);
                ResultSet result = statement.executeQuery();
                int size = result.getMetaData().getColumnCount();
                Vector rows = new Vector();
                while (result.next()) {
                    Vector<String> row = new Vector<String>(size);
                    for (int column = 1; column <= size; ++column) {
                        row.add(result.getString(column));
                    }
                    rows.add(row);
                }
                result.close();
                statement.close();
            }
        };
        test.setAllowableDecrease(-30.0);
        test.setName("GetStringTest");
        this.addTest((TestCase)test);
    }

    public void addGetDATE() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() throws Exception {
                PreparedStatement statement = TimestampTest.this.connection.prepareStatement(TimestampTest.this.sql);
                ResultSet result = statement.executeQuery();
                int size = result.getMetaData().getColumnCount();
                Vector rows = new Vector();
                while (result.next()) {
                    Vector<Date> row = new Vector<Date>(size);
                    for (int column = 1; column <= size; ++column) {
                        row.add(result.getDate(column));
                    }
                    rows.add(row);
                }
                result.close();
                statement.close();
            }
        };
        test.setName("GetDATETest");
        this.addTest((TestCase)test);
    }
}

