/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.report;

import java.math.BigDecimal;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.queries.ReportQueryResult;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.queries.report.ReportQueryTestCase;

public class Scenario1_9b
extends ReportQueryTestCase {
    public Scenario1_9b() {
        this.setDescription("SUM aggregate function");
    }

    @Override
    protected void buildExpectedResults() {
        Vector employees = this.getSession().readAllObjects(Employee.class);
        BigDecimal sum = new BigDecimal(0);
        Enumeration e = employees.elements();
        while (e.hasMoreElements()) {
            Employee emp = (Employee)e.nextElement();
            sum = sum.add(new BigDecimal(emp.getSalary()));
        }
        this.addResult(new Object[]{sum}, null);
    }

    @Override
    protected void setup() throws Exception {
        super.setup();
        this.reportQuery = new ReportQuery(new ExpressionBuilder());
        this.reportQuery.setReferenceClass(Employee.class);
        this.reportQuery.addSum("salary");
    }

    @Override
    protected void verify() {
        BigDecimal result;
        if (this.results.size() != this.expectedResults.size()) {
            throw new TestErrorException("ReportQuery test failed: The result size are different");
        }
        BigDecimal expected = (BigDecimal)((ReportQueryResult)this.expectedResults.firstElement()).getByIndex(0);
        if (!Helper.compareBigDecimals((BigDecimal)expected, (BigDecimal)(result = (BigDecimal)ConversionManager.getDefaultManager().convertObject(((ReportQueryResult)this.results.firstElement()).getByIndex(0), BigDecimal.class)))) {
            throw new TestErrorException("ReportQuery test failed: The results did not match (" + expected + ", " + result + ")");
        }
    }
}

