/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class CurrentChangeSetTest
extends AutoVerifyTestCase {
    int countBeforeCommit;
    int countAfterCommit;

    public void reset() {
        if (this.getAbstractSession().isInTransaction()) {
            this.getAbstractSession().rollbackTransaction();
            this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        }
    }

    public void setup() {
        this.getAbstractSession().beginTransaction();
        this.countBeforeCommit = 0;
        this.countAfterCommit = 0;
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Employee emp = (Employee)uow.registerObject((Object)new Employee());
        this.countBeforeCommit = uow.getCurrentChanges().getAllChangeSets().size();
        uow.commit();
        this.countAfterCommit = uow.getCurrentChanges().getAllChangeSets().size();
    }

    public void verify() {
        if (this.countBeforeCommit == 0) {
            throw new TestErrorException("Invalid number of change sets before commit [" + this.countBeforeCommit + "]. ");
        }
    }
}

