/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import oracle.kv.Depth;
import oracle.kv.KeyRange;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.MultiKeyOperation;
import oracle.kv.impl.util.SerializationUtil;
import oracle.kv.impl.util.UserDataControl;

abstract class MultiGetBatchIterateOperation
extends MultiKeyOperation {
    private final List<byte[]> parentKeys;
    private final int batchSize;
    private final byte[] resumeKey;

    public MultiGetBatchIterateOperation(InternalOperation.OpCode opCode, List<byte[]> parentKeys, byte[] resumekey, KeyRange subRange, Depth depth, int batchSize) {
        super(opCode, parentKeys.get(0), subRange, depth);
        this.parentKeys = parentKeys;
        this.resumeKey = resumekey;
        this.batchSize = batchSize;
    }

    protected MultiGetBatchIterateOperation(InternalOperation.OpCode opCode, DataInput in, short serialVersion) throws IOException {
        super(opCode, in, serialVersion);
        int nkeys;
        int n = nkeys = serialVersion >= 14 ? SerializationUtil.readSequenceLength(in) : (int)in.readShort();
        if (nkeys >= 0) {
            this.parentKeys = new ArrayList<byte[]>(nkeys);
            for (int i = 0; i < nkeys; ++i) {
                this.parentKeys.add(SerializationUtil.readNonNullByteArrayOldShortLength(in, serialVersion));
            }
        } else {
            this.parentKeys = null;
        }
        if (serialVersion >= 14) {
            this.resumeKey = SerializationUtil.readByteArray(in);
        } else {
            short len = in.readShort();
            if (len > 0) {
                this.resumeKey = new byte[len];
                in.readFully(this.resumeKey);
            } else {
                this.resumeKey = null;
            }
        }
        this.batchSize = in.readInt();
    }

    List<byte[]> getParentKeys() {
        return this.parentKeys;
    }

    int getBatchSize() {
        return this.batchSize;
    }

    byte[] getResumeKey() {
        return this.resumeKey;
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        if (serialVersion >= 14) {
            SerializationUtil.writeCollectionLength(out, this.parentKeys);
        } else {
            out.writeShort(this.parentKeys != null ? this.parentKeys.size() : -1);
        }
        if (this.parentKeys != null) {
            for (byte[] key : this.parentKeys) {
                SerializationUtil.writeNonNullByteArrayOldShortLength(out, serialVersion, key);
            }
        }
        if (serialVersion >= 14) {
            SerializationUtil.writeByteArray(out, this.resumeKey);
        } else if (this.resumeKey != null && this.resumeKey.length > 0) {
            out.writeShort(this.resumeKey.length);
            out.write(this.resumeKey);
        } else {
            out.writeShort(-1);
        }
        out.writeInt(this.batchSize);
    }

    @Override
    public String toString() {
        return "parentKeys: " + this.parentKeys.size() + " resumeKey: " + UserDataControl.displayKey(this.resumeKey) + " subRange: " + UserDataControl.displayKeyRange(this.getSubRange()) + " depth: " + this.getDepth();
    }
}

