/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.IndexImpl;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.QueryStateException;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.ExprSFW;
import oracle.kv.impl.query.compiler.QueryControlBlock;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.compiler.StaticContext;
import oracle.kv.impl.query.types.ExprType;
import oracle.kv.impl.query.types.TypeManager;

class ExprVar
extends Expr {
    static final String theCtxVarName = "$";
    static final String theElementVarName = "$element";
    static final String theElementPosVarName = "$pos";
    static final String theKeyVarName = "$key";
    static final String theValueVarName = "$value";
    private VarKind theVarKind;
    private final String theName;
    private final TableImpl theTable;
    private Expr theDomainExpr;
    private Expr theCtxExpr;
    private ExprType theDeclaredType;
    private int theId;
    private IndexImpl theIndex;

    ExprVar(QueryControlBlock qcb, StaticContext sctx, QueryException.Location location, String name, TableImpl table, ExprSFW.FromClause fromClause) {
        super(qcb, sctx, Expr.ExprKind.VAR, location);
        this.theVarKind = VarKind.FOR;
        this.theName = name;
        this.theTable = table;
        this.theDomainExpr = fromClause.getDomainExpr();
        assert (table == null || this.theDomainExpr.getKind() == Expr.ExprKind.BASE_TABLE || this.theDomainExpr.getKind() == Expr.ExprKind.UPDATE_ROW || this.theDomainExpr.getKind() == Expr.ExprKind.INSERT_ROW || this.theDomainExpr.getKind() == Expr.ExprKind.DELETE_ROW);
        assert (this.theDomainExpr.getKind() != Expr.ExprKind.BASE_TABLE && this.theDomainExpr.getKind() != Expr.ExprKind.UPDATE_ROW && this.theDomainExpr.getKind() != Expr.ExprKind.INSERT_ROW || table != null);
        if (table != null) {
            this.theType = TypeManager.createTableRecordType(table, ExprType.Quantifier.ONE);
        }
    }

    ExprVar(QueryControlBlock qcb, StaticContext sctx, QueryException.Location location, String name, Expr ctxExpr) {
        super(qcb, sctx, Expr.ExprKind.VAR, location);
        this.theName = name;
        this.theTable = null;
        this.theCtxExpr = ctxExpr;
        if (this.theName.equals(theCtxVarName)) {
            this.theVarKind = VarKind.CTX_ITEM;
            this.theDomainExpr = this.theCtxExpr.getKind() == Expr.ExprKind.SEQ_MAP ? this.theCtxExpr.getInput() : ctxExpr;
        } else if (this.theName.equals(theElementVarName)) {
            this.theVarKind = VarKind.CTX_ELEM;
        } else if (this.theName.equals(theValueVarName)) {
            this.theVarKind = VarKind.CTX_ELEM;
        } else if (this.theName.equals(theElementPosVarName)) {
            this.theVarKind = VarKind.CTX_ELEM_POS;
        } else if (this.theName.equals(theKeyVarName)) {
            this.theVarKind = VarKind.CTX_KEY;
        } else {
            throw new QueryStateException("Implicit context variable does not have one of the expected names. Var name = " + name);
        }
    }

    ExprVar(QueryControlBlock qcb, StaticContext sctx, QueryException.Location location, String name, FieldDefImpl type, int id) {
        super(qcb, sctx, Expr.ExprKind.VAR, location);
        this.theName = name;
        this.theTable = null;
        this.theVarKind = VarKind.EXTERNAL;
        this.theDeclaredType = TypeManager.createType(type, ExprType.Quantifier.ONE);
        this.theId = id;
    }

    String getName() {
        return this.theName;
    }

    int getId() {
        return this.theId;
    }

    VarKind getVarKind() {
        return this.theVarKind;
    }

    boolean isFor() {
        return this.theVarKind == VarKind.FOR;
    }

    boolean isExternal() {
        return this.theVarKind == VarKind.EXTERNAL;
    }

    boolean isContext() {
        return this.theVarKind == VarKind.CTX_ELEM || this.theVarKind == VarKind.CTX_ELEM_POS || this.theVarKind == VarKind.CTX_KEY || this.theVarKind == VarKind.CTX_ITEM;
    }

    Expr getDomainExpr() {
        return this.theDomainExpr;
    }

    Expr getCtxExpr() {
        return this.theCtxExpr;
    }

    TableImpl getTable() {
        return this.theTable;
    }

    static String createVarNameFromTableAlias(String alias) {
        return alias.charAt(0) == '$' ? alias : "$$" + alias;
    }

    String createIndexVarName() {
        return this.theName + "_idx";
    }

    String getTableAlias() {
        String alias;
        if (this.theTable == null) {
            return null;
        }
        String string = alias = this.theName.startsWith("$$") ? this.theName.substring(2) : this.theName;
        if (this.theIndex != null) {
            assert (alias.endsWith("_idx"));
            return alias.substring(0, alias.length() - 4);
        }
        return alias;
    }

    IndexImpl getIndex() {
        return this.theIndex;
    }

    void setIndex(IndexImpl index, ExprType indexType) {
        this.theIndex = index;
        this.theType = indexType;
    }

    @Override
    int getNumChildren() {
        return 0;
    }

    @Override
    ExprType computeType() {
        switch (this.theVarKind) {
            case EXTERNAL: {
                return this.theDeclaredType;
            }
            case CTX_ELEM_POS: {
                return TypeManager.LONG_ONE();
            }
            case CTX_ITEM: {
                Expr.ExprKind exprKind = this.theCtxExpr.getKind();
                Expr input = this.theCtxExpr.getInput();
                ExprType inType = input.getType();
                switch (exprKind) {
                    case FIELD_STEP: 
                    case MAP_FILTER: {
                        while (inType.isArray()) {
                            inType = inType.getArrayElementType(ExprType.Quantifier.ONE);
                        }
                        return inType.getItemType();
                    }
                    case ARRAY_SLICE: 
                    case ARRAY_FILTER: {
                        if (!inType.isArray()) {
                            return TypeManager.createArrayType(inType, ExprType.Quantifier.ONE);
                        }
                        return inType.getItemType();
                    }
                    case SEQ_MAP: 
                    case UPDATE_FIELD: {
                        return inType.getItemType();
                    }
                }
                throw new QueryStateException("Unexpected input expression: " + (Object)((Object)exprKind));
            }
            case CTX_ELEM: {
                Expr.ExprKind exprKind = this.theCtxExpr.getKind();
                Expr input = this.theCtxExpr.getInput();
                ExprType inType = input.getType();
                if (exprKind == Expr.ExprKind.ARRAY_FILTER) {
                    return inType.getArrayElementType(ExprType.Quantifier.ONE);
                }
                if (exprKind == Expr.ExprKind.MAP_FILTER) {
                    while (inType.isArray()) {
                        inType = inType.getArrayElementType(ExprType.Quantifier.ONE);
                    }
                    return inType.getMapElementType(ExprType.Quantifier.ONE);
                }
                throw new QueryStateException("Unexpected input expression: " + (Object)((Object)exprKind));
            }
            case CTX_KEY: {
                assert (this.theCtxExpr.getKind() == Expr.ExprKind.MAP_FILTER);
                return TypeManager.STRING_ONE();
            }
            case FOR: {
                if (this.theTable != null) {
                    return this.theType;
                }
                return this.theDomainExpr.getType().getItemType();
            }
        }
        throw new QueryStateException("Unknown variable kind: " + (Object)((Object)this.theVarKind));
    }

    @Override
    public boolean mayReturnNULL() {
        switch (this.theVarKind) {
            case EXTERNAL: {
                return this.theDeclaredType.isAnyJson();
            }
            case CTX_ITEM: {
                if (this.theCtxExpr.getKind() == Expr.ExprKind.SEQ_MAP) {
                    Expr input = this.theCtxExpr.getInput();
                    return input.mayReturnNULL();
                }
            }
            case CTX_ELEM_POS: 
            case CTX_KEY: {
                return false;
            }
            case CTX_ELEM: {
                Expr input = this.theCtxExpr.getInput();
                ExprType inType = input.getType();
                return inType.isRecord() || inType.isSubType(TypeManager.JSON_STAR());
            }
            case FOR: {
                return this.theDomainExpr.mayReturnNULL();
            }
        }
        throw new QueryStateException("Unknown variable kind: " + (Object)((Object)this.theVarKind));
    }

    @Override
    void display(StringBuilder sb, QueryFormatter formatter) {
        formatter.indent(sb);
        this.displayContent(sb, formatter);
    }

    @Override
    void displayContent(StringBuilder sb, QueryFormatter formatter) {
        sb.append(this.theName);
    }

    static enum VarKind {
        FOR,
        CTX_ITEM,
        CTX_ELEM,
        CTX_ELEM_POS,
        CTX_KEY,
        EXTERNAL;

    }
}

