/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.runtime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.IntegerValueImpl;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.impl.api.table.TimestampUtils;
import oracle.kv.impl.query.QueryStateException;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.FuncExtractFromTimestamp;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.runtime.PlanIterState;
import oracle.kv.impl.query.runtime.RuntimeControlBlock;
import oracle.kv.table.TimestampValue;

public class FuncExtractFromTimestampIter
extends PlanIter {
    private final FuncExtractFromTimestamp.Unit unit;
    private final PlanIter theInput;

    public FuncExtractFromTimestampIter(Expr e, int resultReg, FuncExtractFromTimestamp.Unit unit, PlanIter theInput) {
        super(e, resultReg);
        this.unit = unit;
        this.theInput = theInput;
    }

    FuncExtractFromTimestampIter(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        short ordinal = FuncExtractFromTimestampIter.readOrdinal(in, FuncExtractFromTimestamp.Unit.values().length);
        this.unit = FuncExtractFromTimestamp.Unit.values()[ordinal];
        this.theInput = FuncExtractFromTimestampIter.deserializeIter(in, serialVersion);
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        out.writeShort(this.unit.ordinal());
        FuncExtractFromTimestampIter.serializeIter(this.theInput, out, serialVersion);
    }

    @Override
    public PlanIter.PlanIterKind getKind() {
        return PlanIter.PlanIterKind.FUNC_EXTRACT_FROM_TIMESTAMP;
    }

    @Override
    public void open(RuntimeControlBlock rcb) {
        rcb.setState(this.theStatePos, new PlanIterState());
        this.theInput.open(rcb);
    }

    @Override
    public boolean next(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        if (state.isDone()) {
            return false;
        }
        boolean more = this.theInput.next(rcb);
        if (!more) {
            state.done();
            return false;
        }
        FieldValueImpl item = rcb.getRegVal(this.theInput.getResultReg());
        if (item.isNull()) {
            rcb.setRegVal(this.theResultReg, NullValueImpl.getInstance());
            state.done();
            return true;
        }
        assert (item.isTimestamp());
        int result = this.extractFromTimestamp(item.asTimestamp());
        IntegerValueImpl res = FieldDefImpl.integerDef.createInteger(result);
        rcb.setRegVal(this.theResultReg, res);
        state.done();
        return true;
    }

    private int extractFromTimestamp(TimestampValue ts) {
        int result = 0;
        switch (this.unit) {
            case YEAR: {
                result = ts.getYear();
                break;
            }
            case MONTH: {
                result = ts.getMonth();
                break;
            }
            case DAY: {
                result = ts.getDay();
                break;
            }
            case HOUR: {
                result = ts.getHour();
                break;
            }
            case MINUTE: {
                result = ts.getMinute();
                break;
            }
            case SECOND: {
                result = ts.getSecond();
                break;
            }
            case MILLISECOND: {
                result = this.formatFracSecond(ts, 3);
                break;
            }
            case MICROSECOND: {
                result = this.formatFracSecond(ts, 6);
                break;
            }
            case NANOSECOND: {
                result = this.formatFracSecond(ts, 9);
                break;
            }
            case WEEK: {
                result = TimestampUtils.getWeekOfYear(ts.get());
                break;
            }
            case ISOWEEK: {
                result = TimestampUtils.getISOWeekOfYear(ts.get());
                break;
            }
            default: {
                throw new QueryStateException("Unexpected unit: " + (Object)((Object)this.unit));
            }
        }
        return result;
    }

    private int formatFracSecond(TimestampValue ts, int toPrecision) {
        int tsPrecision = ts.getDefinition().asTimestamp().getPrecision();
        if (tsPrecision == 0 || toPrecision == 0) {
            return 0;
        }
        if (tsPrecision == toPrecision) {
            return ts.getFracSecond();
        }
        int nanos = ts.getNano();
        if (nanos == 0 || toPrecision == 9) {
            return nanos;
        }
        nanos = (int)((double)nanos / Math.pow(10.0, 9 - toPrecision));
        return nanos;
    }

    @Override
    public void reset(RuntimeControlBlock rcb) {
        this.theInput.reset(rcb);
        PlanIterState state = rcb.getState(this.theStatePos);
        state.reset(this);
    }

    @Override
    public void close(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        if (state == null) {
            return;
        }
        this.theInput.close(rcb);
        state.close();
    }

    @Override
    protected void displayContent(StringBuilder sb, QueryFormatter formatter) {
        this.theInput.display(sb, formatter);
    }
}

