/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.topo;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.impl.util.FastExternalizable;

public enum DatacenterType implements FastExternalizable
{
    PRIMARY(0){

        @Override
        public boolean isPrimary() {
            return true;
        }
    }
    ,
    SECONDARY(1){

        @Override
        public boolean isSecondary() {
            return true;
        }
    };

    private static final DatacenterType[] VALUES;

    private DatacenterType(int ordinal) {
        if (ordinal != this.ordinal()) {
            throw new IllegalArgumentException("Wrong ordinal");
        }
    }

    public boolean isPrimary() {
        return false;
    }

    public boolean isSecondary() {
        return false;
    }

    public static DatacenterType readFastExternal(DataInput in, short serialVersion) throws IOException {
        byte ordinal = in.readByte();
        try {
            return VALUES[ordinal];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IOException("Wrong ordinal for DatacenterType: " + ordinal, e);
        }
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        out.writeByte(this.ordinal());
    }

    static {
        VALUES = DatacenterType.values();
    }
}

