/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpql;

import java.util.Collection;
import java.util.Iterator;
import junit.framework.Test;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.jpql.JPQLTestCase;

public class AggregateTest
extends JPQLTestCase {
    private ReportQuery reportQuery;
    private Collection originalResults;

    private static AggregateTest getNewTestCaseNamed(String testName, String ejbql, Class referenceClass) {
        AggregateTest test = new AggregateTest();
        test.setName(testName);
        test.setEjbqlString(ejbql);
        test.useReportQuery();
        test.setReferenceClass(referenceClass);
        return test;
    }

    private static ReportQuery getNewReportQueryForTest(AggregateTest test) {
        ReportQuery rq = new ReportQuery();
        rq.setReferenceClass(test.getReferenceClass());
        rq.returnSingleAttribute();
        rq.dontRetrievePrimaryKeys();
        test.setReportQuery(rq);
        return rq;
    }

    public static JPQLTestCase getSimpleAvgTest() {
        String ejbql = "SELECT AVG(DISTINCT emp.salary) FROM Employee emp";
        AggregateTest test = AggregateTest.getNewTestCaseNamed("AVG Test", ejbql, Employee.class);
        ReportQuery rq = AggregateTest.getNewReportQueryForTest(test);
        rq.addAverage("salary", Double.class);
        return test;
    }

    public static JPQLTestCase getSimpleCountTest() {
        String ejbql = "SELECT COUNT(emp) FROM Employee emp";
        AggregateTest test = AggregateTest.getNewTestCaseNamed("COUNT Test", ejbql, Employee.class);
        ReportQuery rq = AggregateTest.getNewReportQueryForTest(test);
        rq.addCount("id", Long.class);
        return test;
    }

    public static JPQLTestCase getSimpleMaxTest() {
        String ejbql = "SELECT MAX(DISTINCT emp.salary) FROM Employee emp";
        AggregateTest test = AggregateTest.getNewTestCaseNamed("MAX Test", ejbql, Employee.class);
        ReportQuery rq = AggregateTest.getNewReportQueryForTest(test);
        ExpressionBuilder builder = rq.getExpressionBuilder();
        Expression exp = builder.get("salary").distinct();
        rq.addMaximum("salary", exp, Integer.class);
        return test;
    }

    public static JPQLTestCase getSimpleMinTest() {
        String ejbql = "SELECT MIN(DISTINCT emp.salary) FROM Employee emp";
        AggregateTest test = AggregateTest.getNewTestCaseNamed("MIN Test", ejbql, Employee.class);
        ReportQuery rq = AggregateTest.getNewReportQueryForTest(test);
        ExpressionBuilder builder = rq.getExpressionBuilder();
        Expression exp = builder.get("salary").distinct();
        rq.addMinimum("salary", exp, Integer.class);
        return test;
    }

    public static JPQLTestCase getSimpleSumTest() {
        String ejbql = "SELECT SUM(DISTINCT emp.salary) FROM Employee emp";
        AggregateTest test = AggregateTest.getNewTestCaseNamed("SUM Test", ejbql, Employee.class);
        ReportQuery rq = AggregateTest.getNewReportQueryForTest(test);
        rq.addSum("salary", Long.class);
        return test;
    }

    private static AggregateTest makeTestComplex(AggregateTest test) {
        test.setName("Complex " + test.getName());
        test.setEjbqlString(test.getEjbqlString() + " WHERE emp.lastName = \"Smith\"");
        ExpressionBuilder employee = test.getReportQuery().getExpressionBuilder();
        Expression whereClause = employee.get("lastName").equal((Object)"Smith");
        test.getReportQuery().setSelectionCriteria(whereClause);
        return test;
    }

    public static JPQLTestCase getComplexAvgTest() {
        return AggregateTest.makeTestComplex((AggregateTest)AggregateTest.getSimpleAvgTest());
    }

    public static JPQLTestCase getComplexCountTest() {
        return AggregateTest.makeTestComplex((AggregateTest)AggregateTest.getSimpleCountTest());
    }

    public static JPQLTestCase getComplexDistinctCountTest() {
        String ejbql = "SELECT COUNT (DISTINCT emp.lastName) FROM Employee emp";
        AggregateTest test = AggregateTest.getNewTestCaseNamed("Complex DISTINCT COUNT Test", ejbql, Employee.class);
        ReportQuery rq = AggregateTest.getNewReportQueryForTest(test);
        rq.addCount("lastName", new ExpressionBuilder().get("lastName").distinct(), Long.class);
        return test;
    }

    public static JPQLTestCase getComplexMaxTest() {
        return AggregateTest.makeTestComplex((AggregateTest)AggregateTest.getSimpleMaxTest());
    }

    public static JPQLTestCase getComplexMinTest() {
        return AggregateTest.makeTestComplex((AggregateTest)AggregateTest.getSimpleMinTest());
    }

    public static JPQLTestCase getComplexSumTest() {
        return AggregateTest.makeTestComplex((AggregateTest)AggregateTest.getSimpleSumTest());
    }

    public static TestSuite getSimpleAggregateTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("Simple Aggregate Test Suite");
        suite.addTest((Test)AggregateTest.getSimpleAvgTest());
        suite.addTest((Test)AggregateTest.getSimpleCountTest());
        suite.addTest((Test)AggregateTest.getSimpleMaxTest());
        suite.addTest((Test)AggregateTest.getSimpleMinTest());
        suite.addTest((Test)AggregateTest.getSimpleSumTest());
        return suite;
    }

    public static TestSuite getComplexAggregateTestSuit() {
        TestSuite suite = new TestSuite();
        suite.setName("Complex Aggregate Test Suite");
        suite.addTest((Test)AggregateTest.getComplexAvgTest());
        suite.addTest((Test)AggregateTest.getComplexCountTest());
        suite.addTest((Test)AggregateTest.getComplexDistinctCountTest());
        suite.addTest((Test)AggregateTest.getComplexMaxTest());
        suite.addTest((Test)AggregateTest.getComplexMinTest());
        suite.addTest((Test)AggregateTest.getComplexSumTest());
        return suite;
    }

    @Override
    public void setup() {
        this.setOriginalResults((Collection)this.getSession().executeQuery((DatabaseQuery)this.getReportQuery()));
    }

    @Override
    public void reset() {
        super.reset();
    }

    @Override
    public void verify() throws Exception {
        Iterator originalObjects = this.getOriginalResults().iterator();
        Iterator returnedObjects = ((Collection)this.getReturnedObjects()).iterator();
        while (originalObjects.hasNext()) {
            Object returned;
            Object original = originalObjects.next();
            if (original.equals(returned = returnedObjects.next())) continue;
            throw new TestErrorException(this.getName() + " Verify Failed");
        }
    }

    public ReportQuery getReportQuery() {
        return this.reportQuery;
    }

    public void setReportQuery(ReportQuery reportQuery) {
        this.reportQuery = reportQuery;
    }

    public Collection getOriginalResults() {
        return this.originalResults;
    }

    public void setOriginalResults(Collection originalResults) {
        this.originalResults = originalResults;
    }
}

