/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.queries.MultiNameQueriesTestCase;

public class QueryExceptionStringTest
extends MultiNameQueriesTestCase {
    private DatabaseSession session;
    private String exception1;
    private String exception2;
    private String exception3;
    private String exception4;
    private String bogusQueryName = "bogusName";
    private String realQueryName = "namedQuerySameName";

    public QueryExceptionStringTest() {
        this.setDescription("Testing query error strings");
    }

    public void reset() {
        this.session.removeQuery(this.realQueryName);
        this.session.getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void setup() {
        this.session = (DatabaseSession)this.getSession();
        this.session.addQuery(this.realQueryName, (DatabaseQuery)this.getNamedQueryFirstName());
    }

    public void test() {
        try {
            this.session.executeQuery(this.bogusQueryName, (Object)new String("Jill"));
        }
        catch (Exception e) {
            this.exception1 = e.getMessage();
        }
        try {
            this.session.executeQuery(this.bogusQueryName, Employee.class, (Object)new String("Jill"));
        }
        catch (Exception e) {
            this.exception2 = e.getMessage();
        }
        try {
            this.session.executeQuery(this.bogusQueryName, Employee.class);
        }
        catch (Exception e) {
            this.exception3 = e.getMessage();
        }
        try {
            this.session.executeQuery(this.bogusQueryName);
        }
        catch (Exception e) {
            this.exception4 = e.getMessage();
        }
    }

    public void verify() {
        if (this.exception1.indexOf(this.bogusQueryName) == -1) {
            throw new TestErrorException("Test failed on exception1 ... see testcase");
        }
        if (this.exception2.indexOf(this.bogusQueryName) == -1) {
            throw new TestErrorException("Test failed on exception2 ... see testcase");
        }
        if (this.exception3.indexOf(this.bogusQueryName) == -1) {
            throw new TestErrorException("Test failed on exception3 ... see testcase");
        }
        if (this.exception4.indexOf(this.bogusQueryName) == -1) {
            throw new TestErrorException("Test failed on exception4 ... see testcase");
        }
    }
}

