/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.xml.advanced.compositepk;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.AdvancedTableCreator;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.compositepk.CompositePKTableCreator;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.compositepk.Cubicle;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.compositepk.Department;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.compositepk.DepartmentPK;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.compositepk.JuniorScientist;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.compositepk.Scientist;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.compositepk.ScientistPK;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.derivedid.Administrator;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.derivedid.DepartmentAdminRole;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.derivedid.DepartmentAdminRolePK;
import org.eclipse.persistence.testing.tests.jpa.TestingProperties;

public class AdvancedCompositePKJunitTest
extends JUnitTestCase {
    String m_persistenceUnit = "default";
    private static DepartmentPK m_departmentPK;
    private static ScientistPK m_scientist1PK;
    private static ScientistPK m_scientist2PK;
    private static ScientistPK m_scientist3PK;
    private static ScientistPK m_jScientistPK;

    public AdvancedCompositePKJunitTest() {
    }

    public AdvancedCompositePKJunitTest(String name) {
        super(name);
    }

    public AdvancedCompositePKJunitTest(String name, String persistenceUnit) {
        super(name);
        this.m_persistenceUnit = persistenceUnit;
    }

    public static Test suite() {
        String ormTesting = TestingProperties.getProperty("orm.testing", "jpa");
        String persistenceUnit = ormTesting.equals("jpa") ? "default" : "extended-advanced";
        TestSuite suite = new TestSuite("AdvancedCompositePKJunitTest - " + persistenceUnit);
        suite.addTest((Test)new AdvancedCompositePKJunitTest("testSetup", persistenceUnit));
        suite.addTest((Test)new AdvancedCompositePKJunitTest("testOrderBySetting", persistenceUnit));
        suite.addTest((Test)new AdvancedCompositePKJunitTest("testCreateDepartment", persistenceUnit));
        suite.addTest((Test)new AdvancedCompositePKJunitTest("testCreateScientists", persistenceUnit));
        suite.addTest((Test)new AdvancedCompositePKJunitTest("testReadDepartment", persistenceUnit));
        suite.addTest((Test)new AdvancedCompositePKJunitTest("testReadJuniorScientist", persistenceUnit));
        suite.addTest((Test)new AdvancedCompositePKJunitTest("testAnyAndAll", persistenceUnit));
        suite.addTest((Test)new AdvancedCompositePKJunitTest("testDepartmentAdmin", persistenceUnit));
        return suite;
    }

    public void testSetup() {
        new AdvancedTableCreator().replaceTables((DatabaseSession)JUnitTestCase.getServerSession((String)this.m_persistenceUnit));
        new CompositePKTableCreator().replaceTables((DatabaseSession)JUnitTestCase.getServerSession((String)this.m_persistenceUnit));
        AdvancedCompositePKJunitTest.clearCache((String)this.m_persistenceUnit);
    }

    public void testOrderBySetting() {
        ServerSession session = JUnitTestCase.getServerSession((String)this.m_persistenceUnit);
        ClassDescriptor departmentDescriptor = session.getDescriptor(Department.class);
        AdvancedCompositePKJunitTest.assertNotNull((String)"Department descriptor was not found.", (Object)departmentDescriptor);
        DatabaseMapping scientistMapping = departmentDescriptor.getMappingForAttributeName("scientists");
        AdvancedCompositePKJunitTest.assertNotNull((String)"Scientist mapping from Department descriptor was not found.", (Object)scientistMapping);
        AdvancedCompositePKJunitTest.assertTrue((String)"The scientist mapping from the Department descriptor did not have an order by setting.", (boolean)((OneToManyMapping)scientistMapping).hasOrderBy());
    }

    public void testCreateDepartment() {
        EntityManager em = AdvancedCompositePKJunitTest.createEntityManager((String)this.m_persistenceUnit);
        this.beginTransaction(em);
        try {
            em.createQuery("DELETE FROM XMLDepartment d WHERE d.name = 'DEPT A' AND d.role = 'ROLE A' AND d.location = 'LOCATION A'").executeUpdate();
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        AdvancedCompositePKJunitTest.clearCache((String)this.m_persistenceUnit);
        this.closeEntityManager(em);
        em = AdvancedCompositePKJunitTest.createEntityManager((String)this.m_persistenceUnit);
        this.beginTransaction(em);
        try {
            Department department = new Department();
            department.setName("DEPT A");
            department.setRole("ROLE A");
            department.setLocation("LOCATION A");
            em.persist((Object)department);
            this.commitTransaction(em);
            m_departmentPK = department.getPK();
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void testCreateScientists() {
        EntityManager em = AdvancedCompositePKJunitTest.createEntityManager((String)this.m_persistenceUnit);
        this.beginTransaction(em);
        try {
            Department department = (Department)em.merge((Object)((Department)em.find(Department.class, (Object)m_departmentPK)));
            Cubicle cubicle1 = new Cubicle("G");
            em.persist((Object)cubicle1);
            Scientist scientist1 = new Scientist();
            scientist1.setFirstName("Guy");
            scientist1.setLastName("Pelletier");
            scientist1.setCubicle(cubicle1);
            department.addScientist(scientist1);
            em.persist((Object)scientist1);
            Cubicle cubicle2 = new Cubicle("T");
            em.persist((Object)cubicle2);
            Scientist scientist2 = new Scientist();
            scientist2.setFirstName("Tom");
            scientist2.setLastName("Ware");
            scientist2.setCubicle(cubicle2);
            department.addScientist(scientist2);
            em.persist((Object)scientist2);
            Cubicle cubicle3 = new Cubicle("G");
            em.persist((Object)cubicle3);
            Scientist scientist3 = new Scientist();
            scientist3.setFirstName("Gordon");
            scientist3.setLastName("Yorke");
            scientist3.setCubicle(cubicle3);
            department.addScientist(scientist3);
            em.persist((Object)scientist3);
            Cubicle cubicle4 = new Cubicle("J");
            em.persist((Object)cubicle4);
            JuniorScientist jScientist = new JuniorScientist();
            jScientist.setFirstName("Junior");
            jScientist.setLastName("Sao");
            jScientist.setCubicle(cubicle4);
            department.addScientist((Scientist)jScientist);
            em.persist((Object)jScientist);
            this.commitTransaction(em);
            m_scientist1PK = scientist1.getPK();
            m_scientist2PK = scientist2.getPK();
            m_scientist3PK = scientist3.getPK();
            m_jScientistPK = jScientist.getPK();
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void testDepartmentAdmin() {
        String location = "Ottawa";
        String depName = "New Product Research";
        String depRole = "R&D new technologies";
        EntityManager em = AdvancedCompositePKJunitTest.createEntityManager((String)this.m_persistenceUnit);
        this.beginTransaction(em);
        try {
            Employee emp = new Employee("George", "Smith");
            em.persist((Object)emp);
            Administrator adminEmp = new Administrator();
            adminEmp.setContractCompany("George's consulting");
            adminEmp.setEmployee(emp);
            em.persist((Object)adminEmp);
            Department newProductResearch = new Department();
            newProductResearch.setLocation(location);
            newProductResearch.setName(depName);
            newProductResearch.setRole(depRole);
            em.persist((Object)newProductResearch);
            DepartmentAdminRole depAdmin = new DepartmentAdminRole();
            depAdmin.setAdmin(adminEmp);
            depAdmin.setDepartment(newProductResearch);
            em.persist((Object)depAdmin);
            this.commitTransaction(em);
            EntityManagerImpl emImpl = (EntityManagerImpl)em;
            DepartmentAdminRolePK depAdminPk = new DepartmentAdminRolePK(depName, depRole, location, adminEmp.getEmployee().getId());
            DepartmentAdminRole cacheObject = (DepartmentAdminRole)em.find(DepartmentAdminRole.class, (Object)depAdminPk);
            AdvancedCompositePKJunitTest.assertTrue((String)"Find did not return the DepartmentAdminRole", (cacheObject != null ? 1 : 0) != 0);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testReadDepartment() {
        Department department = (Department)AdvancedCompositePKJunitTest.createEntityManager((String)this.m_persistenceUnit).find(Department.class, (Object)m_departmentPK);
        AdvancedCompositePKJunitTest.assertTrue((String)"Error on reading back the ordered department list.", (department != null ? 1 : 0) != 0);
        AdvancedCompositePKJunitTest.assertTrue((String)"The number of scientists were incorrect.", (department.getScientists().size() > 0 ? 1 : 0) != 0);
    }

    public void testReadJuniorScientist() {
        JuniorScientist jScientist = (JuniorScientist)AdvancedCompositePKJunitTest.createEntityManager((String)this.m_persistenceUnit).find(JuniorScientist.class, (Object)m_jScientistPK);
        AdvancedCompositePKJunitTest.assertTrue((String)"Error on reading back the junior scientist.", (jScientist != null ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAnyAndAll() {
        EntityManager em = AdvancedCompositePKJunitTest.createEntityManager((String)this.m_persistenceUnit);
        this.beginTransaction(em);
        try {
            Query query1 = em.createQuery("SELECT s FROM XMLScientist s WHERE s = ANY (SELECT s2 FROM XMLScientist s2)");
            List results1 = query1.getResultList();
            Query query2 = em.createQuery("SELECT s FROM XMLScientist s WHERE s = ALL (SELECT s2 FROM XMLScientist s2)");
            List results2 = query2.getResultList();
            Query query3 = em.createQuery("SELECT s FROM XMLScientist s WHERE s.department = ALL (SELECT DISTINCT d FROM XMLDepartment d WHERE d.name = 'DEPT A' AND d.role = 'ROLE A' AND d.location = 'LOCATION A')");
            List results3 = query3.getResultList();
            Query query4 = em.createQuery("SELECT s FROM XMLScientist s WHERE s.department = ANY (SELECT DISTINCT d FROM XMLDepartment d JOIN d.scientists ds JOIN ds.cubicle c WHERE c.code = 'G')");
            List results4 = query4.getResultList();
            Query controlQuery1 = em.createQuery("SELECT s FROM XMLScientist s");
            ArrayList controlResults1 = controlQuery1.getResultList();
            ArrayList controlResults2 = controlResults1.size() == 1 ? controlResults1 : new ArrayList();
            Query controlQuery3 = em.createQuery("SELECT s FROM XMLScientist s JOIN s.department d WHERE d.name = 'DEPT A' AND d.role = 'ROLE A' AND d.location = 'LOCATION A'");
            List controlResults3 = controlQuery3.getResultList();
            Query controlQuery4 = em.createQuery("SELECT s FROM XMLScientist s WHERE EXISTS (SELECT DISTINCT d FROM XMLDepartment d JOIN d.scientists ds JOIN ds.cubicle c WHERE c.code = 'G' AND d = s.department)");
            List controlResults4 = controlQuery4.getResultList();
            this.compareResults(results1, controlResults1, "query1");
            this.compareResults(results2, controlResults2, "query2");
            this.compareResults(results3, controlResults3, "query3");
            this.compareResults(results4, controlResults4, "query4");
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    protected void compareResults(List results, List controlResults, String testName) {
        if (results.size() != controlResults.size()) {
            AdvancedCompositePKJunitTest.fail((String)(testName + ": results.size() = " + results.size() + "; controlResults.size() = " + controlResults.size()));
        }
        for (Object s : results) {
            if (controlResults.contains(s)) continue;
            AdvancedCompositePKJunitTest.fail((String)(testName + ": " + s + "contained in results but not in controlResults"));
        }
    }
}

