/*
 * Copyright (c) 2016, 2020 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */

// Contributors:
//     Ondrej Cerny
package org.eclipse.persistence.testing.jaxb.annotations.xmlschema.model.extended;

import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSeeAlso;

@XmlSeeAlso(ExtendedObject.class)
@XmlRootElement
public class ExtensionWrapper {
    public String wrapperStringField;
    public ExtendedObject wrapperObjectField;

    @Override
    public int hashCode() {
        // generated by Eclipse IDE
        final int prime = 31;
        int result = 1;
        result = prime * result + ((wrapperObjectField == null) ? 0 : wrapperObjectField.hashCode());
        result = prime * result + ((wrapperStringField == null) ? 0 : wrapperStringField.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        // generated by Eclipse IDE
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExtensionWrapper)) {
            return false;
        }
        ExtensionWrapper other = (ExtensionWrapper) obj;
        if (wrapperObjectField == null) {
            if (other.wrapperObjectField != null) {
                return false;
            }
        } else if (!wrapperObjectField.equals(other.wrapperObjectField)) {
            return false;
        }
        if (wrapperStringField == null) {
            if (other.wrapperStringField != null) {
                return false;
            }
        } else if (!wrapperStringField.equals(other.wrapperStringField)) {
            return false;
        }
        return true;
    }
}
