/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.CursoredStream;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.UpdateObjectQuery;
import org.eclipse.persistence.sessions.server.ClientSession;
import org.eclipse.persistence.sessions.server.Server;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeProject;

public class CursoredStreamReadWriteClientSessionTest
extends TestCase {
    protected Server serverSession;
    protected ClientSession clientSession;
    protected int addressId = 0;
    protected Exception caughtException = null;

    public CursoredStreamReadWriteClientSessionTest() {
        this.setDescription("Verifies if a transaction is committed while using read & write connections in same client session with cursored stream used in read.");
    }

    public void reset() {
        this.clientSession.release();
        this.serverSession.logout();
    }

    public void setup() {
        EmployeeProject proj = new EmployeeProject();
        proj.setDatasourceLogin(this.getSession().getDatasourceLogin().clone());
        this.serverSession = proj.createServerSession(0, 0, 1);
        this.serverSession.setSessionLog(this.getSession().getSessionLog());
        this.serverSession.login();
        this.clientSession = this.serverSession.acquireClientSession();
        Employee emp = (Employee)this.getSession().readObject(Employee.class);
        this.addressId = emp.getAddress().getId().intValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test() {
        this.clientSession.beginTransaction();
        try {
            ReadObjectQuery objquery = new ReadObjectQuery();
            objquery.setReferenceClass(Address.class);
            ExpressionBuilder objquerybuilder = new ExpressionBuilder();
            Expression objexpr = objquerybuilder.get("id").equal(this.addressId);
            objquery.setSelectionCriteria(objexpr);
            Address address = (Address)this.clientSession.executeQuery((DatabaseQuery)objquery);
            UpdateObjectQuery updateQuery = new UpdateObjectQuery();
            updateQuery.setObject((Object)address);
            this.clientSession.executeQuery((DatabaseQuery)updateQuery);
            ReadAllQuery query = new ReadAllQuery();
            query.setReferenceClass(Employee.class);
            query.useCursoredStream(1, 1);
            CursoredStream stream = (CursoredStream)this.clientSession.executeQuery((DatabaseQuery)query);
            Object result = null;
            while (stream.hasNext()) {
                result = stream.next();
            }
            this.clientSession.commitTransaction();
        }
        catch (Exception ex) {
            this.caughtException = ex;
        }
        finally {
            try {
                this.clientSession.rollbackTransaction();
            }
            catch (Exception exception) {}
        }
    }

    public void verify() {
        if (this.caughtException == null) {
            return;
        }
        if (this.caughtException instanceof DatabaseException) {
            throw new TestErrorException("incorrect if the exception is thrown due to a closed connection");
        }
    }
}

