/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.validation;

import java.util.Hashtable;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.IntegrityChecker;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.MapContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.testing.models.mapping.Employee;
import org.eclipse.persistence.testing.tests.validation.ExceptionTest;

public class IncorrectCollectionPolicyTest
extends ExceptionTest {
    OneToManyMapping mapping;
    ContainerPolicy orgContainerPolicy;
    IntegrityChecker orgIntegrityChecker;

    public IncorrectCollectionPolicyTest() {
        this.setDescription("This tests Incorrect Collection Policy (TL-ERROR 163)");
    }

    protected void setup() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.expectedException = DescriptorException.incorrectCollectionPolicy(null, null, null);
        ClassDescriptor descriptor = this.getSession().getDescriptor(Employee.class);
        this.mapping = (OneToManyMapping)descriptor.getMappingForAttributeName("managedEmployees");
        this.orgContainerPolicy = this.mapping.getContainerPolicy();
        this.mapping.setContainerPolicy((ContainerPolicy)new MapContainerPolicy(Hashtable.class));
        this.orgIntegrityChecker = this.getSession().getIntegrityChecker();
        this.getSession().setIntegrityChecker(new IntegrityChecker());
        this.getSession().getIntegrityChecker().dontCatchExceptions();
    }

    @Override
    public void reset() {
        this.mapping.setContainerPolicy(this.orgContainerPolicy);
        this.getSession().setIntegrityChecker(this.orgIntegrityChecker);
    }

    public void test() {
        try {
            this.mapping.initialize((AbstractSession)this.getSession());
        }
        catch (EclipseLinkException exception) {
            this.caughtException = exception;
        }
    }
}

