/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.advanced;

import jakarta.persistence.EntityManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.CommunicationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.coordination.ConnectToHostCommand;
import org.eclipse.persistence.internal.sessions.coordination.RemoteConnection;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.changesets.ChangeRecord;
import org.eclipse.persistence.sessions.changesets.DirectToFieldChangeRecord;
import org.eclipse.persistence.sessions.changesets.ObjectReferenceChangeRecord;
import org.eclipse.persistence.sessions.coordination.Command;
import org.eclipse.persistence.sessions.coordination.CommandManager;
import org.eclipse.persistence.sessions.coordination.CommandProcessor;
import org.eclipse.persistence.sessions.coordination.MergeChangeSetCommand;
import org.eclipse.persistence.sessions.coordination.RemoteCommandManager;
import org.eclipse.persistence.sessions.coordination.ServiceId;
import org.eclipse.persistence.sessions.coordination.TransportManager;
import org.eclipse.persistence.sessions.serializers.JavaSerializer;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.advanced.Address;
import org.eclipse.persistence.testing.models.jpa.advanced.AdvancedTableCreator;
import org.eclipse.persistence.testing.models.jpa.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.cacheable.CacheableFalseEntity;
import org.eclipse.persistence.testing.models.jpa.cacheable.CacheableForceProtectedEntity;
import org.eclipse.persistence.testing.models.jpa.cacheable.CacheableTableCreator;

public class JPARCMLocalChangeSetTestSuite
extends JUnitTestCase {
    public JPARCMLocalChangeSetTestSuite() {
    }

    public JPARCMLocalChangeSetTestSuite(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("JPARCMLocalChangeSetTestSuite");
        JPARCMLocalChangeSetTestSuite.addTestToSuite("testSetup", suite);
        JPARCMLocalChangeSetTestSuite.addTestToSuite("testAssociateNewEntityWithExistingEntityAfterFlush", suite);
        if (!JUnitTestCase.isJPA10()) {
            JPARCMLocalChangeSetTestSuite.addTestToSuite("testPropagateProtectedForeignKeyValuesForNewObject", suite);
            JPARCMLocalChangeSetTestSuite.addTestToSuite("testPropagateProtectedForeignKeyValuesForExistingObjectWithSendChanges", suite);
            JPARCMLocalChangeSetTestSuite.addTestToSuite("testPropagateProtectedForeignKeyValuesForExistingObjectWithSendNewObjects", suite);
        }
        return suite;
    }

    public static void addTestToSuite(String testName, TestSuite suite) {
        suite.addTest((Test)new JPARCMLocalChangeSetTestSuite(testName));
    }

    public void testSetup() {
        ServerSession session = JPARCMLocalChangeSetTestSuite.getServerSession();
        new AdvancedTableCreator().replaceTables((DatabaseSession)session);
        this.clearServerSessionCache();
        new CacheableTableCreator().replaceTables((DatabaseSession)JUnitTestCase.getServerSession((String)"cacheablePU"));
        JPARCMLocalChangeSetTestSuite.clearCache((String)"cacheablePU");
    }

    public void initializeRCMOnSession(ServerSession session) {
        RemoteCommandManager rcm = new RemoteCommandManager((CommandProcessor)session);
        rcm.setShouldPropagateAsynchronously(true);
        session.setCommandManager((CommandManager)rcm);
        session.setShouldPropagateChanges(true);
        this.resetLocalConnection(session);
    }

    public void resetRCMOnSession(ServerSession session) {
        session.setCommandManager(null);
    }

    public void resetLocalConnection(ServerSession session) {
        LocalConnection localConn = this.getLocalConnection(session);
        if (localConn == null) {
            localConn = new LocalConnection((AbstractSession)session);
            session.getCommandManager().getTransportManager().addConnectionToExternalService((RemoteConnection)localConn);
        }
        localConn.resetReceivedChangeSets();
        localConn.ignoreChanges(false);
    }

    public LocalConnection getLocalConnection(ServerSession session) {
        TransportManager manager = session.getCommandManager().getTransportManager();
        return (LocalConnection)((Object)manager.getConnectionsToExternalServices().get(LocalConnection.class.getSimpleName()));
    }

    public void allowForChangePropagation() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAssociateNewEntityWithExistingEntityAfterFlush() {
        this.initializeRCMOnSession(JPARCMLocalChangeSetTestSuite.getServerSession());
        int oldEmployeeCacheSyncType = JPARCMLocalChangeSetTestSuite.getServerSession().getDescriptor(Employee.class).getCacheSynchronizationType();
        int oldAddressCacheSyncType = JPARCMLocalChangeSetTestSuite.getServerSession().getDescriptor(Address.class).getCacheSynchronizationType();
        JPARCMLocalChangeSetTestSuite.getServerSession().getDescriptor(Employee.class).setCacheSynchronizationType(1);
        JPARCMLocalChangeSetTestSuite.getServerSession().getDescriptor(Address.class).setCacheSynchronizationType(1);
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Employee employee = new Employee();
        employee.setFirstName("Bob");
        employee.setLastName("Smith");
        employee.setMale();
        em.persist((Object)employee);
        this.commitTransaction(em);
        this.closeEntityManager(em);
        this.clearCache();
        this.resetLocalConnection(JPARCMLocalChangeSetTestSuite.getServerSession());
        try {
            em = this.createEntityManager();
            this.beginTransaction(em);
            Address address = new Address();
            address.setStreet("123 Main St.");
            address.setCity("Ottawa");
            address.setProvince("Ontario");
            address.setCountry("Canada");
            address.setPostalCode("K1S2B2");
            em.persist((Object)address);
            em.flush();
            address.setCountry("USA");
            address.setProvince("Kansas");
            address.setPostalCode("66067");
            Employee employeeFound = (Employee)em.find(Employee.class, (Object)employee.getId());
            employeeFound.setAddress(address);
            this.commitTransaction(em);
            this.closeEntityManager(em);
            em = null;
            this.allowForChangePropagation();
            LocalConnection conn = this.getLocalConnection(JPARCMLocalChangeSetTestSuite.getServerSession());
            JPARCMLocalChangeSetTestSuite.assertEquals((String)"Should have received one ObjectChangeSet", (int)1, (int)conn.getReceivedChangeSets().size());
            UnitOfWorkChangeSet uowcs = conn.getReceivedChangeSets().get(0);
            Map csMap = uowcs.getAllChangeSets();
            for (ObjectChangeSet ocs : csMap.keySet()) {
                if (!ocs.getClassName().equals(Employee.class.getName())) {
                    JPARCMLocalChangeSetTestSuite.fail((String)"Changes are only expected in this test for an Employee");
                    continue;
                }
                List employeeChanges = ocs.getChanges();
                boolean foundAddressChange = false;
                for (ChangeRecord employeeChange : employeeChanges) {
                    if (!employeeChange.getAttribute().equals("address")) continue;
                    foundAddressChange = true;
                    ObjectReferenceChangeRecord addressRecord = (ObjectReferenceChangeRecord)employeeChange;
                    JPARCMLocalChangeSetTestSuite.assertNotNull((String)"Employee->Address changes should not be null", (Object)addressRecord);
                    ObjectChangeSet addressCs = (ObjectChangeSet)addressRecord.getNewValue();
                    JPARCMLocalChangeSetTestSuite.assertNotNull((String)"Address ChangeSet newValue should not be null", (Object)addressCs);
                    HashMap<String, ChangeRecord> addressChanges = new HashMap<String, ChangeRecord>();
                    for (ChangeRecord record : addressCs.getChanges()) {
                        addressChanges.put(record.getAttribute(), record);
                    }
                    DirectToFieldChangeRecord countryRecord = (DirectToFieldChangeRecord)addressChanges.get("country");
                    DirectToFieldChangeRecord provinceRecord = (DirectToFieldChangeRecord)addressChanges.get("province");
                    DirectToFieldChangeRecord postalCodeRecord = (DirectToFieldChangeRecord)addressChanges.get("postalCode");
                    DirectToFieldChangeRecord idRecord = (DirectToFieldChangeRecord)addressChanges.get("ID");
                    DirectToFieldChangeRecord streetRecord = (DirectToFieldChangeRecord)addressChanges.get("street");
                    DirectToFieldChangeRecord versionRecord = (DirectToFieldChangeRecord)addressChanges.get("version");
                    DirectToFieldChangeRecord cityRecord = (DirectToFieldChangeRecord)addressChanges.get("city");
                    JPARCMLocalChangeSetTestSuite.assertNotNull((String)"ID should not be null", (Object)idRecord);
                    JPARCMLocalChangeSetTestSuite.assertNotNull((String)"Street should not be null", (Object)streetRecord);
                    JPARCMLocalChangeSetTestSuite.assertNotNull((String)"City should not be null", (Object)cityRecord);
                    JPARCMLocalChangeSetTestSuite.assertNotNull((String)"Country should not be null", (Object)countryRecord);
                    JPARCMLocalChangeSetTestSuite.assertNotNull((String)"Province should not be null", (Object)provinceRecord);
                    JPARCMLocalChangeSetTestSuite.assertNotNull((String)"PostalCode should not be null", (Object)postalCodeRecord);
                    JPARCMLocalChangeSetTestSuite.assertNotNull((String)"Version should not be null", (Object)versionRecord);
                    JPARCMLocalChangeSetTestSuite.assertEquals((String)"Country should be equal.", (Object)address.getCountry(), (Object)countryRecord.getNewValue());
                    JPARCMLocalChangeSetTestSuite.assertEquals((String)"Province should be equal.", (Object)address.getProvince(), (Object)provinceRecord.getNewValue());
                    JPARCMLocalChangeSetTestSuite.assertEquals((String)"PostalCode should be equal.", (Object)address.getPostalCode(), (Object)postalCodeRecord.getNewValue());
                    JPARCMLocalChangeSetTestSuite.assertEquals((String)"ID should be equal.", (Object)address.getID(), (Object)idRecord.getNewValue());
                    JPARCMLocalChangeSetTestSuite.assertEquals((String)"Street should be equal.", (Object)address.getStreet(), (Object)streetRecord.getNewValue());
                    JPARCMLocalChangeSetTestSuite.assertEquals((String)"Version should be equal.", (Object)address.getVersion(), (Object)versionRecord.getNewValue());
                    JPARCMLocalChangeSetTestSuite.assertEquals((String)"City should be equal.", (Object)address.getCity(), (Object)cityRecord.getNewValue());
                }
                if (foundAddressChange) continue;
                JPARCMLocalChangeSetTestSuite.fail((String)"No address changes were found when processing ChangeSets");
            }
        }
        finally {
            this.getLocalConnection(JPARCMLocalChangeSetTestSuite.getServerSession()).ignoreChanges(true);
            em = this.createEntityManager();
            Employee empToDelete = (Employee)em.find(Employee.class, (Object)employee.getId());
            if (empToDelete != null) {
                this.beginTransaction(em);
                if (empToDelete.getAddress() != null) {
                    em.remove((Object)empToDelete.getAddress());
                }
                em.remove((Object)empToDelete);
                this.commitTransaction(em);
            }
            this.closeEntityManager(em);
            JPARCMLocalChangeSetTestSuite.getServerSession().getDescriptor(Employee.class).setCacheSynchronizationType(oldEmployeeCacheSyncType);
            JPARCMLocalChangeSetTestSuite.getServerSession().getDescriptor(Address.class).setCacheSynchronizationType(oldAddressCacheSyncType);
            this.resetRCMOnSession(JPARCMLocalChangeSetTestSuite.getServerSession());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPropagateProtectedForeignKeyValuesForNewObject() {
        EntityManager em;
        String puName = "cacheablePU";
        ServerSession session = JPARCMLocalChangeSetTestSuite.getServerSession((String)puName);
        this.initializeRCMOnSession(session);
        ClassDescriptor cacheableDescriptor = session.getClassDescriptor(CacheableForceProtectedEntity.class);
        ClassDescriptor nonCacheableDescriptor = session.getClassDescriptor(CacheableFalseEntity.class);
        cacheableDescriptor.setCacheSynchronizationType(3);
        CacheableForceProtectedEntity cacheableEntity = new CacheableForceProtectedEntity();
        cacheableEntity.setName("Bob");
        CacheableFalseEntity nonCacheableEntity = new CacheableFalseEntity();
        cacheableEntity.setCacheableFalse(nonCacheableEntity);
        this.resetLocalConnection(session);
        try {
            em = JPARCMLocalChangeSetTestSuite.createEntityManager((String)puName);
            this.beginTransaction(em);
            em.persist((Object)cacheableEntity);
            em.persist((Object)nonCacheableEntity);
            this.commitTransaction(em);
            this.closeEntityManager(em);
            em = null;
            this.allowForChangePropagation();
            LocalConnection conn = this.getLocalConnection(session);
            JPARCMLocalChangeSetTestSuite.assertEquals((String)"Should have received one UnitOfWorkChangeSet", (int)1, (int)conn.getReceivedChangeSets().size());
            UnitOfWorkChangeSet uowcs = conn.getReceivedChangeSets().get(0);
            Map csMap = uowcs.getAllChangeSets();
            for (ObjectChangeSet ocs : csMap.keySet()) {
                AbstractRecord protectedForeignKeys = ocs.getProtectedForeignKeys();
                Vector fkFields = cacheableDescriptor.getMappingForAttributeName("cacheableFalse").getFields();
                JPARCMLocalChangeSetTestSuite.assertNotNull((String)"ObjectChangeSet should have a non-null protected foreign key", (Object)protectedForeignKeys);
                JPARCMLocalChangeSetTestSuite.assertEquals((String)"ObjectChangeSet's protectedForeignKeys should be non-empty", (int)fkFields.size(), (int)protectedForeignKeys.size());
                DatabaseField pkField = (DatabaseField)fkFields.get(0);
                Object pkValue = protectedForeignKeys.get(pkField);
                JPARCMLocalChangeSetTestSuite.assertEquals((String)"ObjectChangeSet's protectedForeignKeys should contain a valid FK value", (Object)pkValue, (Object)nonCacheableEntity.getId());
            }
        }
        finally {
            this.getLocalConnection(session).ignoreChanges(true);
            em = JPARCMLocalChangeSetTestSuite.createEntityManager((String)puName);
            CacheableForceProtectedEntity toDelete = (CacheableForceProtectedEntity)em.find(CacheableForceProtectedEntity.class, (Object)cacheableEntity.getId());
            if (toDelete != null) {
                this.beginTransaction(em);
                if (toDelete.getCacheableFalse() != null) {
                    em.remove((Object)toDelete.getCacheableFalse());
                }
                em.remove((Object)toDelete);
                this.commitTransaction(em);
            }
            this.closeEntityManager(em);
            cacheableDescriptor.setCacheSynchronizationType(4);
            this.resetLocalConnection(session);
            this.resetRCMOnSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testPropagateProtectedForeignKeyValuesForExistingObject(int cacheSynchronizationType) {
        String puName = "cacheablePU";
        ServerSession session = JPARCMLocalChangeSetTestSuite.getServerSession((String)puName);
        ClassDescriptor cacheableDescriptor = session.getClassDescriptor(CacheableForceProtectedEntity.class);
        ClassDescriptor nonCacheableDescriptor = session.getClassDescriptor(CacheableFalseEntity.class);
        cacheableDescriptor.setCacheSynchronizationType(cacheSynchronizationType);
        CacheableForceProtectedEntity cacheableEntity = new CacheableForceProtectedEntity();
        cacheableEntity.setName("Bob");
        CacheableFalseEntity nonCacheableEntity = new CacheableFalseEntity();
        cacheableEntity.setCacheableFalse(nonCacheableEntity);
        EntityManager em = JPARCMLocalChangeSetTestSuite.createEntityManager((String)puName);
        this.beginTransaction(em);
        em.persist((Object)cacheableEntity);
        em.persist((Object)nonCacheableEntity);
        this.commitTransaction(em);
        this.closeEntityManager(em);
        em = null;
        this.initializeRCMOnSession(session);
        try {
            em = JPARCMLocalChangeSetTestSuite.createEntityManager((String)puName);
            this.beginTransaction(em);
            CacheableForceProtectedEntity cacheableEntityRead = (CacheableForceProtectedEntity)em.find(CacheableForceProtectedEntity.class, (Object)cacheableEntity.getId());
            JPARCMLocalChangeSetTestSuite.assertNotNull((Object)cacheableEntityRead);
            JPARCMLocalChangeSetTestSuite.assertNotNull((Object)cacheableEntityRead.getCacheableFalse());
            CacheableFalseEntity newCacheableFalseEntity = new CacheableFalseEntity();
            cacheableEntityRead.setCacheableFalse(newCacheableFalseEntity);
            em.persist((Object)newCacheableFalseEntity);
            this.commitTransaction(em);
            this.closeEntityManager(em);
            em = null;
            this.allowForChangePropagation();
            LocalConnection conn = this.getLocalConnection(session);
            List<UnitOfWorkChangeSet> changeSets = conn.getReceivedChangeSets();
            for (UnitOfWorkChangeSet changeSet : changeSets) {
                JPARCMLocalChangeSetTestSuite.assertNull((Object)changeSet.getSession());
            }
            JPARCMLocalChangeSetTestSuite.assertEquals((String)"Should have received one UnitOfWorkChangeSet", (int)1, (int)conn.getReceivedChangeSets().size());
            UnitOfWorkChangeSet uowcs = conn.getReceivedChangeSets().get(0);
            Map csMap = uowcs.getAllChangeSets();
            for (ObjectChangeSet ocs : csMap.keySet()) {
                AbstractRecord protectedForeignKeys = ocs.getProtectedForeignKeys();
                Vector fkFields = cacheableDescriptor.getMappingForAttributeName("cacheableFalse").getFields();
                JPARCMLocalChangeSetTestSuite.assertNotNull((String)"ObjectChangeSet should have a non-null protected foreign key", (Object)protectedForeignKeys);
                JPARCMLocalChangeSetTestSuite.assertEquals((String)"ObjectChangeSet's protectedForeignKeys should be non-empty", (int)fkFields.size(), (int)protectedForeignKeys.size());
                DatabaseField pkField = (DatabaseField)fkFields.get(0);
                Object pkValue = protectedForeignKeys.get(pkField);
                int idExpected = cacheableEntityRead.getCacheableFalse().getId();
                JPARCMLocalChangeSetTestSuite.assertEquals((String)"ObjectChangeSet's protectedForeignKeys should contain a valid FK value", (Object)pkValue, (Object)idExpected);
            }
        }
        finally {
            CacheableFalseEntity toDelete2;
            this.getLocalConnection(session).ignoreChanges(true);
            em = JPARCMLocalChangeSetTestSuite.createEntityManager((String)puName);
            this.beginTransaction(em);
            CacheableForceProtectedEntity toDelete = (CacheableForceProtectedEntity)em.find(CacheableForceProtectedEntity.class, (Object)cacheableEntity.getId());
            if (toDelete != null) {
                if (toDelete.getCacheableFalse() != null) {
                    em.remove((Object)toDelete.getCacheableFalse());
                }
                em.remove((Object)toDelete);
            }
            if ((toDelete2 = (CacheableFalseEntity)em.find(CacheableFalseEntity.class, (Object)nonCacheableEntity.getId())) != null) {
                em.remove((Object)toDelete2);
            }
            this.commitTransaction(em);
            this.closeEntityManager(em);
            cacheableDescriptor.setCacheSynchronizationType(4);
            this.resetLocalConnection(session);
            this.resetRCMOnSession(session);
        }
    }

    public void testPropagateProtectedForeignKeyValuesForExistingObjectWithSendChanges() {
        this.testPropagateProtectedForeignKeyValuesForExistingObject(1);
    }

    public void testPropagateProtectedForeignKeyValuesForExistingObjectWithSendNewObjects() {
        this.testPropagateProtectedForeignKeyValuesForExistingObject(3);
    }

    protected class LocalConnection
    extends RemoteConnection {
        protected AbstractSession session;
        protected boolean ignoreChanges;
        protected List<UnitOfWorkChangeSet> receivedChangeSets;

        public LocalConnection(AbstractSession session) {
            this.setSession(session);
            this.resetReceivedChangeSets();
            this.ignoreChanges(false);
        }

        public Object executeCommand(Command command) throws CommunicationException {
            if (!this.shouldIgnoreChanges()) {
                if (command instanceof ConnectToHostCommand) {
                    ServiceId commandServiceId = command.getServiceId();
                    this.setServiceId(new ServiceId(commandServiceId.getChannel(), ((Object)((Object)this)).getClass().getSimpleName(), commandServiceId.getURL()));
                } else if (command instanceof MergeChangeSetCommand) {
                    UnitOfWorkChangeSet uowCs = ((MergeChangeSetCommand)command).getChangeSet(this.getSession());
                    this.getReceivedChangeSets().add(uowCs);
                }
            }
            return null;
        }

        public Object executeCommand(byte[] commandBytes) throws CommunicationException {
            Command command = (Command)JavaSerializer.instance.deserialize((Object)commandBytes, null);
            return this.executeCommand(command);
        }

        public List<UnitOfWorkChangeSet> getReceivedChangeSets() {
            return this.receivedChangeSets;
        }

        public void setReceivedChangeSets(List<UnitOfWorkChangeSet> changesReceived) {
            this.receivedChangeSets = changesReceived;
        }

        public void resetReceivedChangeSets() {
            this.setReceivedChangeSets(new ArrayList<UnitOfWorkChangeSet>());
        }

        public void ignoreChanges(boolean ignoreChanges) {
            this.ignoreChanges = ignoreChanges;
        }

        public boolean shouldIgnoreChanges() {
            return this.ignoreChanges;
        }

        public AbstractSession getSession() {
            return this.session;
        }

        public void setSession(AbstractSession session) {
            this.session = session;
        }
    }
}

