/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.criteria;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Parameter;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.ParameterExpression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.criteria.Subquery;
import jakarta.persistence.metamodel.EntityType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.queries.ReportQueryResult;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.advanced.Address;
import org.eclipse.persistence.testing.models.jpa.advanced.AdvancedTableCreator;
import org.eclipse.persistence.testing.models.jpa.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.advanced.EmployeePopulator;
import org.eclipse.persistence.testing.models.jpa.advanced.PhoneNumber;
import org.eclipse.persistence.testing.models.jpa.advanced.Project;
import org.eclipse.persistence.testing.tests.jpa.advanced.DataHolder;
import org.eclipse.persistence.testing.tests.jpa.jpql.JUnitDomainObjectComparer;
import org.junit.Assert;

public class JUnitCriteriaUnitTestSuite
extends JUnitTestCase {
    static JUnitDomainObjectComparer comparer;

    public JUnitCriteriaUnitTestSuite() {
    }

    public JUnitCriteriaUnitTestSuite(String name) {
        super(name);
    }

    public void tearDown() {
        this.clearCache();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("JUnitCriteriaUnitTestSuite");
        suite.addTest((Test)new JUnitCriteriaUnitTestSuite("testSetup"));
        suite.addTest((Test)new JUnitCriteriaUnitTestSuite("testExistWithJoin"));
        suite.addTest((Test)new JUnitCriteriaUnitTestSuite("testSelectPhoneNumberAreaCode"));
        suite.addTest((Test)new JUnitCriteriaUnitTestSuite("testSelectPhoneNumberAreaCodeWithEmployee"));
        suite.addTest((Test)new JUnitCriteriaUnitTestSuite("testSelectPhoneNumberNumberWithEmployeeWithExplicitJoin"));
        suite.addTest((Test)new JUnitCriteriaUnitTestSuite("testSelectPhoneNumberNumberWithEmployeeWithFirstNameFirst"));
        suite.addTest((Test)new JUnitCriteriaUnitTestSuite("testSelectEmployeeWithSameParameterUsedMultipleTimes"));
        suite.addTest((Test)new JUnitCriteriaUnitTestSuite("testOuterJoinOnOneToOne"));
        suite.addTest((Test)new JUnitCriteriaUnitTestSuite("testOuterJoinPolymorphic"));
        suite.addTest((Test)new JUnitCriteriaUnitTestSuite("testFirstResult"));
        suite.addTest((Test)new JUnitCriteriaUnitTestSuite("testInvertedSelectionCriteriaNullPK"));
        suite.addTest((Test)new JUnitCriteriaUnitTestSuite("testInvertedSelectionCriteriaInvalidQueryKey"));
        suite.addTest((Test)new JUnitCriteriaUnitTestSuite("testMaxAndFirstResultsOnDataQuery"));
        suite.addTest((Test)new JUnitCriteriaUnitTestSuite("testMaxAndFirstResultsOnDataQueryWithGroupBy"));
        suite.addTest((Test)new JUnitCriteriaUnitTestSuite("testMaxAndFirstResultsOnObjectQueryOnInheritanceRoot"));
        suite.addTest((Test)new JUnitCriteriaUnitTestSuite("testDistinctSelectForEmployeeWithNullAddress"));
        suite.addTest((Test)new JUnitCriteriaUnitTestSuite("testConstructorWithFunctionParameters"));
        suite.addTest((Test)new JUnitCriteriaUnitTestSuite("testNonExistentConstructorCriteriaQuery"));
        suite.addTest((Test)new JUnitCriteriaUnitTestSuite("testIsNullAndIsNotNull"));
        suite.addTest((Test)new JUnitCriteriaUnitTestSuite("testIsNullOrIsNull"));
        return suite;
    }

    public void testSetup() {
        this.clearCache();
        ServerSession session = JUnitTestCase.getServerSession();
        EmployeePopulator employeePopulator = new EmployeePopulator();
        new AdvancedTableCreator().replaceTables((DatabaseSession)session);
        comparer = new JUnitDomainObjectComparer();
        comparer.setSession((AbstractSession)session.getActiveSession());
        employeePopulator.buildExamples();
        employeePopulator.persistExample((Session)session);
    }

    public Vector getAttributeFromAll(String attributeName, Vector objects, Class referenceClass) {
        ClassDescriptor descriptor = JUnitCriteriaUnitTestSuite.getServerSession().getClassDescriptor(referenceClass);
        DirectToFieldMapping mapping = (DirectToFieldMapping)descriptor.getMappingForAttributeName(attributeName);
        Vector<Object> attributes = new Vector<Object>();
        for (int i = 0; i < objects.size(); ++i) {
            Object currentObject = objects.elementAt(i);
            if (currentObject.getClass() == ReportQueryResult.class) {
                attributes.addElement(((ReportQueryResult)currentObject).get(attributeName));
                continue;
            }
            attributes.addElement(mapping.getAttributeValueFromObject(currentObject));
        }
        return attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFirstResult() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            this.clearCache();
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(Employee.class);
            Root from = cq.from(Employee.class);
            cq.where((jakarta.persistence.criteria.Expression)qb.equal((jakarta.persistence.criteria.Expression)from.get("firstName"), (jakarta.persistence.criteria.Expression)qb.parameter(String.class, "firstname")));
            TypedQuery query = em.createQuery(cq);
            List initialList = query.setParameter("firstname", (Object)"Nancy").setFirstResult(0).getResultList();
            List secondList = query.setParameter("firstname", (Object)"Nancy").setFirstResult(1).getResultList();
            Iterator i = initialList.iterator();
            while (i.hasNext()) {
                JUnitCriteriaUnitTestSuite.assertTrue((String)"Employee with incorrect name returned on first query.", (boolean)((Employee)i.next()).getFirstName().equals("Nancy"));
            }
            i = secondList.iterator();
            while (i.hasNext()) {
                JUnitCriteriaUnitTestSuite.assertTrue((String)"Employee with incorrect name returned on second query.", (boolean)((Employee)i.next()).getFirstName().equals("Nancy"));
            }
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    public void testOuterJoinOnOneToOne() {
        EntityManager em = this.createEntityManager();
        this.clearCache();
        this.beginTransaction(em);
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        cq.from(Employee.class).join("address");
        cq.distinct(true);
        int initialSize = em.createQuery(cq).getResultList().size();
        Employee emp = new Employee();
        emp.setFirstName("Steve");
        emp.setLastName("Harp");
        em.persist((Object)emp);
        em.flush();
        qb = em.getCriteriaBuilder();
        cq = qb.createQuery(Employee.class);
        cq.from(Employee.class).join("address", JoinType.LEFT);
        cq.distinct(true);
        List result = em.createQuery(cq).getResultList();
        JUnitCriteriaUnitTestSuite.assertTrue((String)"Outer join was not properly added to the query", (initialSize + 1 == result.size() ? 1 : 0) != 0);
        this.rollbackTransaction(em);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOuterJoinPolymorphic() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            this.clearCache();
            List resultList = null;
            try {
                resultList = em.createQuery(em.getCriteriaBuilder().createQuery(Project.class)).getResultList();
            }
            catch (Exception exception) {
                JUnitCriteriaUnitTestSuite.fail((String)("Exception caught while executing polymorphic query.  This may mean that outer join is not working correctly on your database platfrom: " + exception.toString()));
            }
            JUnitCriteriaUnitTestSuite.assertTrue((String)"Incorrect number of projects returned.", (resultList.size() == 15 ? 1 : 0) != 0);
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSelectPhoneNumberAreaCode() {
        ExpressionBuilder employeeBuilder = new ExpressionBuilder();
        Expression phones = employeeBuilder.anyOf("phoneNumbers");
        Expression whereClause = phones.get("areaCode").equal((Object)"613");
        ReportQuery rq = new ReportQuery();
        rq.setSelectionCriteria(whereClause);
        rq.addAttribute("areaCode", new ExpressionBuilder().anyOf("phoneNumbers").get("areaCode"));
        rq.setReferenceClass(Employee.class);
        rq.dontUseDistinct();
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Vector expectedResult = this.getAttributeFromAll("areaCode", (Vector)JUnitCriteriaUnitTestSuite.getServerSession().executeQuery((DatabaseQuery)rq), Employee.class);
            this.clearCache();
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(String.class);
            Root root = cq.from(Employee.class);
            Join phone = root.join("phoneNumbers");
            cq.select((Selection)phone.get("areaCode"));
            cq.where((jakarta.persistence.criteria.Expression)qb.equal((jakarta.persistence.criteria.Expression)phone.get("areaCode"), (Object)"613"));
            List result = em.createQuery(cq).getResultList();
            Assert.assertTrue((String)"SimpleSelectPhoneNumberAreaCode test failed !", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExistWithJoin() {
        EntityManager em = this.createEntityManager();
        List expected = em.createQuery("SELECT c FROM Employee c WHERE NOT EXISTS (SELECT o1 FROM c.phoneNumbers o1)").getResultList();
        this.beginTransaction(em);
        try {
            CriteriaBuilder qbuilder = em.getCriteriaBuilder();
            CriteriaQuery cquery = qbuilder.createQuery(Employee.class);
            Root customer = cquery.from(Employee.class);
            cquery.select((Selection)customer);
            Subquery sq = cquery.subquery(PhoneNumber.class);
            Root sqc = sq.correlate(customer);
            Join sqo = sqc.join("phoneNumbers");
            sq.select((jakarta.persistence.criteria.Expression)sqo);
            cquery.where((jakarta.persistence.criteria.Expression)qbuilder.not((jakarta.persistence.criteria.Expression)qbuilder.exists(sq)));
            List result = em.createQuery(cquery).getResultList();
            Assert.assertTrue((String)"testExistWithJoin test failed !", (boolean)comparer.compareObjects(result, (Collection)expected));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSelectPhoneNumberAreaCodeWithEmployee() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            ExpressionBuilder employees = new ExpressionBuilder();
            Expression exp = employees.get("firstName").equal((Object)"Bob");
            exp = exp.and(employees.get("lastName").equal((Object)"Smith"));
            Employee emp = (Employee)JUnitCriteriaUnitTestSuite.getServerSession().readAllObjects(Employee.class, exp).firstElement();
            PhoneNumber phone = (PhoneNumber)((Vector)emp.getPhoneNumbers()).firstElement();
            String areaCode = phone.getAreaCode();
            String firstName = emp.getFirstName();
            ExpressionBuilder employeeBuilder = new ExpressionBuilder();
            Expression phones = employeeBuilder.anyOf("phoneNumbers");
            Expression whereClause = phones.get("areaCode").equal((Object)areaCode).and(phones.get("owner").get("firstName").equal((Object)firstName));
            ReportQuery rq = new ReportQuery();
            rq.setSelectionCriteria(whereClause);
            rq.addAttribute("areaCode", phones.get("areaCode"));
            rq.setReferenceClass(Employee.class);
            rq.dontMaintainCache();
            Vector expectedResult = this.getAttributeFromAll("areaCode", (Vector)JUnitCriteriaUnitTestSuite.getServerSession().executeQuery((DatabaseQuery)rq), Employee.class);
            this.clearCache();
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(String.class);
            Root root = cq.from(Employee.class);
            Join joinedPhone = root.join("phoneNumbers");
            cq.select((Selection)joinedPhone.get("areaCode"));
            cq.where(new Predicate[]{qb.and(new Predicate[]{qb.equal((jakarta.persistence.criteria.Expression)joinedPhone.get("areaCode"), (Object)"613")}), qb.equal((jakarta.persistence.criteria.Expression)joinedPhone.get("owner").get("firstName"), (Object)firstName)});
            List result = em.createQuery(cq).getResultList();
            Assert.assertTrue((String)"SimpleSelectPhoneNumberAreaCodeWithEmployee test failed !", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSelectPhoneNumberNumberWithEmployeeWithExplicitJoin() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            ExpressionBuilder employees = new ExpressionBuilder();
            Expression exp = employees.get("firstName").equal((Object)"Bob");
            exp = exp.and(employees.get("lastName").equal((Object)"Smith"));
            Employee emp = (Employee)JUnitCriteriaUnitTestSuite.getServerSession().readAllObjects(Employee.class, exp).firstElement();
            PhoneNumber phone = (PhoneNumber)((Vector)emp.getPhoneNumbers()).firstElement();
            String areaCode = phone.getAreaCode();
            String firstName = emp.getFirstName();
            ExpressionBuilder employeeBuilder = new ExpressionBuilder(Employee.class);
            Expression phones = employeeBuilder.anyOf("phoneNumbers");
            Expression whereClause = phones.get("areaCode").equal((Object)areaCode).and(phones.get("owner").get("id").equal(employeeBuilder.get("id")).and(employeeBuilder.get("firstName").equal((Object)firstName)));
            ReportQuery rq = new ReportQuery();
            rq.addAttribute("number", new ExpressionBuilder().anyOf("phoneNumbers").get("number"));
            rq.setSelectionCriteria(whereClause);
            rq.setReferenceClass(Employee.class);
            Vector expectedResult = this.getAttributeFromAll("number", (Vector)JUnitCriteriaUnitTestSuite.getServerSession().executeQuery((DatabaseQuery)rq), Employee.class);
            this.clearCache();
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(String.class);
            Root root = cq.from(Employee.class);
            Join joinedPhone = root.join("phoneNumbers");
            cq.select((Selection)joinedPhone.get("number"));
            Predicate firstAnd = qb.and((jakarta.persistence.criteria.Expression)qb.equal((jakarta.persistence.criteria.Expression)joinedPhone.get("areaCode"), (Object)areaCode), (jakarta.persistence.criteria.Expression)qb.equal((jakarta.persistence.criteria.Expression)joinedPhone.get("owner").get("id"), (jakarta.persistence.criteria.Expression)root.get("id")));
            cq.where((jakarta.persistence.criteria.Expression)qb.and((jakarta.persistence.criteria.Expression)firstAnd, (jakarta.persistence.criteria.Expression)qb.equal((jakarta.persistence.criteria.Expression)root.get("firstName"), (Object)firstName)));
            List result = em.createQuery(cq).getResultList();
            Assert.assertTrue((String)"SimpleSelectPhoneNumberAreaCodeWithEmployee test failed !", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSelectPhoneNumberNumberWithEmployeeWithFirstNameFirst() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            ExpressionBuilder employees = new ExpressionBuilder();
            Expression exp = employees.get("firstName").equal((Object)"Bob");
            exp = exp.and(employees.get("lastName").equal((Object)"Smith"));
            Employee emp = (Employee)JUnitCriteriaUnitTestSuite.getServerSession().readAllObjects(Employee.class, exp).firstElement();
            PhoneNumber phone = (PhoneNumber)((Vector)emp.getPhoneNumbers()).firstElement();
            String areaCode = phone.getAreaCode();
            String firstName = emp.getFirstName();
            ExpressionBuilder employeeBuilder = new ExpressionBuilder();
            Expression phones = employeeBuilder.anyOf("phoneNumbers");
            Expression whereClause = phones.get("owner").get("firstName").equal((Object)firstName).and(phones.get("areaCode").equal((Object)areaCode));
            ReportQuery rq = new ReportQuery();
            rq.setSelectionCriteria(whereClause);
            rq.addAttribute("number", phones.get("number"));
            rq.setReferenceClass(Employee.class);
            Vector expectedResult = this.getAttributeFromAll("number", (Vector)JUnitCriteriaUnitTestSuite.getServerSession().executeQuery((DatabaseQuery)rq), Employee.class);
            this.clearCache();
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(String.class);
            Root root = cq.from(Employee.class);
            Join joinedPhone = root.join("phoneNumbers");
            cq.select((Selection)joinedPhone.get("number"));
            Predicate firstNameEquality = qb.equal((jakarta.persistence.criteria.Expression)joinedPhone.get("owner").get("firstName"), (Object)firstName);
            Predicate areaCodeEquality = qb.equal((jakarta.persistence.criteria.Expression)joinedPhone.get("areaCode"), (Object)areaCode);
            cq.where((jakarta.persistence.criteria.Expression)qb.and((jakarta.persistence.criteria.Expression)firstNameEquality, (jakarta.persistence.criteria.Expression)areaCodeEquality));
            List result = em.createQuery(cq).getResultList();
            Assert.assertTrue((String)"SimpleSelectPhoneNumberAreaCodeWithEmployee test failed !", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSelectEmployeeWithSameParameterUsedMultipleTimes() {
        Exception exception = null;
        try {
            EntityManager em = this.createEntityManager();
            this.beginTransaction(em);
            try {
                CriteriaBuilder qb = em.getCriteriaBuilder();
                CriteriaQuery cq = qb.createQuery(Employee.class);
                Root root = cq.from(Employee.class);
                ParameterExpression param1 = qb.parameter(Integer.class);
                cq.where((jakarta.persistence.criteria.Expression)qb.or((jakarta.persistence.criteria.Expression)qb.greaterThan((jakarta.persistence.criteria.Expression)root.get("id"), (jakarta.persistence.criteria.Expression)param1), (jakarta.persistence.criteria.Expression)param1.isNull()));
                em.createQuery(cq).setParameter((Parameter)param1, (Object)1).getResultList();
            }
            finally {
                this.rollbackTransaction(em);
                this.closeEntityManager(em);
            }
        }
        catch (Exception e) {
            exception = e;
        }
        Assert.assertNull((String)"Exception was caught.", (Object)exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvertedSelectionCriteriaNullPK() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createTupleQuery();
            Root rootEmp = cq.from(Employee.class);
            Root rootPhone = cq.from(PhoneNumber.class);
            cq.multiselect(new Selection[]{rootEmp, rootPhone});
            cq.where((jakarta.persistence.criteria.Expression)qb.and((jakarta.persistence.criteria.Expression)qb.equal((jakarta.persistence.criteria.Expression)rootPhone.get("id"), (jakarta.persistence.criteria.Expression)rootEmp.get("id")), (jakarta.persistence.criteria.Expression)qb.equal((jakarta.persistence.criteria.Expression)rootEmp.get("firstName"), (Object)"Bob")));
            em.createQuery(cq).getResultList();
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMaxAndFirstResultsOnDataQuery() {
        Exception exception = null;
        List resultList = null;
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            this.clearCache();
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createTupleQuery();
            Root rootEmp = cq.from(Employee.class);
            Join joinedManager = rootEmp.join("manager", JoinType.LEFT);
            cq.multiselect(new Selection[]{rootEmp.get("id"), joinedManager.get("id")});
            TypedQuery query = em.createQuery(cq);
            try {
                query.setFirstResult(1);
                query.setMaxResults(1);
                resultList = query.getResultList();
            }
            catch (Exception e) {
                this.logThrowable(exception);
                exception = e;
            }
            Assert.assertNull((String)("Exception was caught: " + exception), (Object)exception);
            Assert.assertTrue((String)("Incorrect number of results returned.  Expected 1, returned " + resultList.size()), (resultList.size() == 1 ? 1 : 0) != 0);
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMaxAndFirstResultsOnDataQueryWithGroupBy() {
        Exception exception = null;
        List resultList = null;
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            this.clearCache();
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(Integer.class);
            Root rootEmp = cq.from(Employee.class);
            Join joinedManager = rootEmp.join("manager", JoinType.LEFT);
            cq.select((Selection)rootEmp.get("id"));
            TypedQuery query = em.createQuery(cq);
            try {
                query.setFirstResult(1);
                query.setMaxResults(1);
                resultList = query.getResultList();
            }
            catch (Exception e) {
                this.logThrowable(exception);
                exception = e;
            }
            Assert.assertNull((String)("Exception was caught: " + exception), (Object)exception);
            Assert.assertTrue((String)("Incorrect number of results returned.  Expected 1, returned " + resultList.size()), (resultList.size() == 1 ? 1 : 0) != 0);
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMaxAndFirstResultsOnObjectQueryOnInheritanceRoot() {
        Exception exception = null;
        List resultList = null;
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            this.clearCache();
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(Project.class);
            TypedQuery query = em.createQuery(cq);
            try {
                query.setFirstResult(6);
                query.setMaxResults(1);
                resultList = query.getResultList();
            }
            catch (Exception e) {
                exception = e;
                this.logThrowable(exception);
            }
            Assert.assertNull((String)"Exception was caught.", (Object)exception);
            Assert.assertTrue((String)("Incorrect number of results returned.  Expected 1, returned " + resultList.size()), (resultList.size() == 1 ? 1 : 0) != 0);
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvertedSelectionCriteriaInvalidQueryKey() {
        Exception exception = null;
        try {
            EntityManager em = this.createEntityManager();
            this.beginTransaction(em);
            try {
                CriteriaBuilder qb = em.getCriteriaBuilder();
                CriteriaQuery cq = qb.createTupleQuery();
                Root rootEmp = cq.from(Employee.class);
                Root rootAddress = cq.from(Address.class);
                cq.multiselect(new Selection[]{rootEmp, rootAddress});
                cq.where((jakarta.persistence.criteria.Expression)qb.and((jakarta.persistence.criteria.Expression)qb.equal((jakarta.persistence.criteria.Expression)rootAddress.get("city"), (Object)"Ottawa"), (jakarta.persistence.criteria.Expression)qb.equal((jakarta.persistence.criteria.Expression)rootEmp.get("address").get("country"), (jakarta.persistence.criteria.Expression)rootAddress.get("country"))));
                List list = em.createQuery(cq).getResultList();
            }
            finally {
                this.rollbackTransaction(em);
                this.closeEntityManager(em);
            }
        }
        catch (Exception e) {
            this.logThrowable(e);
            exception = e;
        }
        Assert.assertNull((String)"Exception was caught.", (Object)exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDistinctSelectForEmployeeWithNullAddress() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            Employee emp = new Employee();
            emp.setFirstName("Dummy");
            emp.setLastName("Person");
            em.persist((Object)emp);
            em.flush();
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery();
            Root rootEmp = cq.from(Employee.class);
            cq.select((Selection)rootEmp.get("address"));
            cq.distinct(true);
            List list = em.createQuery(cq).getResultList();
        }
        finally {
            this.rollbackTransaction(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConstructorWithFunctionParameters() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            Employee emp = new Employee();
            emp.setFirstName("Very");
            emp.setLastName("Dumb");
            emp.setSalary(-100);
            em.persist((Object)emp);
            em.flush();
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(DataHolder.class);
            Root from = cq.from(Employee.class);
            EntityType Emp_ = em.getMetamodel().entity(Employee.class);
            cq.multiselect(new Selection[]{qb.min((jakarta.persistence.criteria.Expression)from.get(Emp_.getSingularAttribute("salary", Integer.TYPE)))});
            List resultList = em.createQuery(cq).getResultList();
            Object resultObject = resultList.get(0);
            JUnitCriteriaUnitTestSuite.assertTrue((String)("constructor expression test expected DataHolder object, got " + resultObject), (boolean)(resultObject instanceof DataHolder));
            JUnitCriteriaUnitTestSuite.assertEquals((String)("Expected DataHolder to contain int value of -100, Got :" + resultObject), (int)-100, (int)((DataHolder)resultObject).getPrimitiveInt());
        }
        finally {
            this.rollbackTransaction(em);
        }
    }

    public void testNonExistentConstructorCriteriaQuery() {
        IllegalArgumentException expectedException = null;
        EntityManager em = this.createEntityManager();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(DataHolder.class);
        Root from = cq.from(Employee.class);
        EntityType Emp_ = em.getMetamodel().entity(Employee.class);
        try {
            cq.multiselect(new Selection[]{from.get(Emp_.getSingularAttribute("lastName", String.class))});
            TypedQuery typedQuery = em.createQuery(cq);
        }
        catch (IllegalArgumentException exception) {
            expectedException = exception;
        }
        JUnitCriteriaUnitTestSuite.assertNotNull((String)"Expected IllegalArgumentException not thrown when using a non-existing constructor", (Object)expectedException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIsNullAndIsNotNull() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Employee emp = (Employee)em.createQuery("select e from Employee e where e.firstName = 'John' and e.lastName = 'Way'").getSingleResult();
            emp.setFirstName(null);
            emp = (Employee)em.createQuery("select e from Employee e where e.firstName = 'Charles' and e.lastName = 'Chanley'").getSingleResult();
            emp.setFirstName(null);
            emp.setLastName(null);
            em.flush();
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(Employee.class);
            Root from = cq.from(Employee.class);
            EntityType Emp_ = em.getMetamodel().entity(Employee.class);
            ArrayList<Predicate> criteriaList = new ArrayList<Predicate>();
            criteriaList.add(qb.isNotNull((jakarta.persistence.criteria.Expression)from.get(Emp_.getSingularAttribute("lastName", String.class))));
            criteriaList.add(qb.isNull((jakarta.persistence.criteria.Expression)from.get(Emp_.getSingularAttribute("firstName", String.class))));
            Predicate criteria = qb.and(criteriaList.toArray(new Predicate[0]));
            cq.where((jakarta.persistence.criteria.Expression)criteria);
            TypedQuery query = em.createQuery(cq);
            List results = query.getResultList();
            JUnitCriteriaUnitTestSuite.assertTrue((results.size() == 1 ? 1 : 0) != 0);
            emp = (Employee)results.get(0);
            JUnitCriteriaUnitTestSuite.assertTrue((emp.getFirstName() == null ? 1 : 0) != 0);
            JUnitCriteriaUnitTestSuite.assertTrue((emp.getLastName() != null ? 1 : 0) != 0);
        }
        finally {
            this.rollbackTransaction(em);
        }
    }

    public void testIsNullOrIsNull() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Employee emp = (Employee)em.createQuery("select e from Employee e where e.firstName = 'John' and e.lastName = 'Way'").getSingleResult();
        emp.setFirstName(null);
        emp = (Employee)em.createQuery("select e from Employee e where e.firstName = 'Charles' and e.lastName = 'Chanley'").getSingleResult();
        emp.setLastName(null);
        em.flush();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        Root from = cq.from(Employee.class);
        EntityType Emp_ = em.getMetamodel().entity(Employee.class);
        ArrayList<Predicate> criteriaList = new ArrayList<Predicate>();
        criteriaList.add(qb.isNull((jakarta.persistence.criteria.Expression)from.get(Emp_.getSingularAttribute("lastName", String.class))));
        criteriaList.add(qb.isNull((jakarta.persistence.criteria.Expression)from.get(Emp_.getSingularAttribute("firstName", String.class))));
        Predicate criteria = qb.or(criteriaList.toArray(new Predicate[0]));
        cq.where((jakarta.persistence.criteria.Expression)criteria);
        TypedQuery query = em.createQuery(cq);
        List results = query.getResultList();
        JUnitCriteriaUnitTestSuite.assertTrue((results.size() == 2 ? 1 : 0) != 0);
        this.rollbackTransaction(em);
    }
}

