/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.performance;

import jakarta.persistence.spi.PersistenceProvider;
import java.util.HashMap;
import org.eclipse.persistence.testing.framework.TestProblemException;
import org.eclipse.persistence.testing.tests.jpa.performance.JPAPerformanceRegressionModel;

public class HibernateJPAPerformanceRegressionModel
extends JPAPerformanceRegressionModel {
    public HibernateJPAPerformanceRegressionModel() {
        this.setDescription("Performance tests that compares Hibernate JPA performance.");
    }

    @Override
    public void setupProvider() {
        String providerClass = "org.hibernate.ejb.HibernatePersistence";
        PersistenceProvider provider = null;
        try {
            provider = (PersistenceProvider)Class.forName(providerClass).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception error) {
            throw new TestProblemException("Failed to create persistence provider.", (Throwable)error);
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("hibernate.connection.driver_class", this.getSession().getLogin().getDriverClassName());
        properties.put("hibernate.connection.url", this.getSession().getLogin().getConnectionString());
        properties.put("hibernate.connection.username", this.getSession().getLogin().getUserName());
        properties.put("hibernate.connection.password", this.getSession().getLogin().getPassword());
        properties.put("hibernate.connection.pool_size", "10");
        properties.put("hibernate.jdbc.batch_size", "100");
        properties.put("hibernate.dialect", "org.hibernate.dialect.Oracle9Dialect");
        properties.put("hibernate.cache.provider_class", "org.hibernate.cache.EhCacheProvider");
        if (this.getSession().getSessionLog().getLevel() <= 3) {
            properties.put("hibernate.show_sql", "true");
        }
        this.getExecutor().setEntityManagerFactory(provider.createEntityManagerFactory("performance", properties));
    }
}

