/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.indirection;

import java.lang.reflect.Proxy;
import java.util.Map;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.IntegrityChecker;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.indirection.BackupValueHolder;
import org.eclipse.persistence.internal.indirection.BasicIndirectionPolicy;
import org.eclipse.persistence.internal.indirection.BatchValueHolder;
import org.eclipse.persistence.internal.indirection.DatabaseValueHolder;
import org.eclipse.persistence.internal.indirection.ProxyIndirectionHandler;
import org.eclipse.persistence.internal.indirection.QueryBasedValueHolder;
import org.eclipse.persistence.internal.indirection.TransformerBasedValueHolder;
import org.eclipse.persistence.internal.indirection.UnitOfWorkValueHolder;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.internal.sessions.remote.RemoteSessionController;
import org.eclipse.persistence.internal.sessions.remote.RemoteUnitOfWork;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.sessions.remote.DistributedSession;

public class ProxyIndirectionPolicy
extends BasicIndirectionPolicy {
    private Class[] targetInterfaces;

    public ProxyIndirectionPolicy(Class[] targetInterfaces) {
        this.targetInterfaces = targetInterfaces;
    }

    public ProxyIndirectionPolicy() {
        this.targetInterfaces = new Class[0];
    }

    @Override
    public void initialize() {
    }

    @Override
    public void reset(Object target) {
    }

    public boolean hasTargetInterfaces() {
        return this.targetInterfaces != null && this.targetInterfaces.length != 0;
    }

    @Override
    public Object valueFromRow(Object object) {
        ValueHolder<Object> valueHolder = new ValueHolder<Object>(object);
        return ProxyIndirectionHandler.newProxyInstance(object.getClass(), this.targetInterfaces, valueHolder);
    }

    @Override
    public Object valueFromQuery(ReadQuery query, AbstractRecord row, AbstractSession session) {
        ClassDescriptor descriptor = null;
        try {
            descriptor = session.getDescriptor(query.getReferenceClass());
            if (descriptor.isDescriptorForInterface()) {
                descriptor = descriptor.getInterfacePolicy().getChildDescriptors().get(0);
            }
        }
        catch (Exception e) {
            return null;
        }
        QueryBasedValueHolder valueHolder = new QueryBasedValueHolder(query, row, session);
        return ProxyIndirectionHandler.newProxyInstance(descriptor.getJavaClass(), this.targetInterfaces, valueHolder);
    }

    @Override
    public Object valueFromMethod(Object object, AbstractRecord row, AbstractSession session) {
        TransformerBasedValueHolder valueHolder = new TransformerBasedValueHolder(this.getTransformationMapping().getAttributeTransformer(), object, row, session);
        return ProxyIndirectionHandler.newProxyInstance(object.getClass(), this.targetInterfaces, valueHolder);
    }

    @Override
    public Object valueFromBatchQuery(ReadQuery batchQuery, AbstractRecord row, ObjectLevelReadQuery originalQuery, CacheKey parentCacheKey) {
        Object object;
        try {
            ClassDescriptor cd = originalQuery.getDescriptor().isDescriptorForInterface() ? originalQuery.getDescriptor().getInterfacePolicy().getChildDescriptors().get(0) : originalQuery.getDescriptor();
            object = PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.newInstanceFromClass(cd.getJavaClass()));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        BatchValueHolder valueHolder = new BatchValueHolder(batchQuery, row, this.getForeignReferenceMapping(), originalQuery, parentCacheKey);
        return ProxyIndirectionHandler.newProxyInstance(object.getClass(), this.targetInterfaces, valueHolder);
    }

    @Override
    public boolean objectIsInstantiated(Object object) {
        if (object instanceof Proxy) {
            ProxyIndirectionHandler handler = (ProxyIndirectionHandler)Proxy.getInvocationHandler(object);
            ValueHolderInterface<?> valueHolder = handler.getValueHolder();
            return valueHolder.isInstantiated();
        }
        return true;
    }

    @Override
    public boolean objectIsEasilyInstantiated(Object object) {
        ProxyIndirectionHandler handler;
        ValueHolderInterface<?> valueHolder;
        if (object instanceof Proxy && (valueHolder = (handler = (ProxyIndirectionHandler)Proxy.getInvocationHandler(object)).getValueHolder()) instanceof DatabaseValueHolder) {
            return ((DatabaseValueHolder)valueHolder).isEasilyInstantiated();
        }
        return true;
    }

    @Override
    public Object nullValueFromRow() {
        return null;
    }

    @Override
    public void mergeRemoteValueHolder(Object clientSideDomainObject, Object serverSideDomainObject, MergeManager mergeManager) {
        this.getMapping().setAttributeValueInObject(clientSideDomainObject, serverSideDomainObject);
    }

    @Override
    public Object getRealAttributeValueFromObject(Object obj, Object object) {
        if (object instanceof Proxy) {
            ProxyIndirectionHandler handler = (ProxyIndirectionHandler)Proxy.getInvocationHandler(object);
            ValueHolderInterface<?> valueHolder = handler.getValueHolder();
            return valueHolder.getValue();
        }
        return object;
    }

    public static Object getValueFromProxy(Object value) {
        if (Proxy.isProxyClass(value.getClass())) {
            return ((ProxyIndirectionHandler)Proxy.getInvocationHandler(value)).getValueHolder().getValue();
        }
        return value;
    }

    @Override
    public void setRealAttributeValueInObject(Object target, Object attributeValue) {
        this.getMapping().setAttributeValueInObject(target, attributeValue);
    }

    @Override
    public Object getOriginalIndirectionObject(Object unitOfWorkIndirectionObject, AbstractSession session) {
        if (unitOfWorkIndirectionObject instanceof UnitOfWorkValueHolder) {
            ValueHolderInterface valueHolder = ((UnitOfWorkValueHolder)unitOfWorkIndirectionObject).getWrappedValueHolder();
            if (valueHolder == null && session.isRemoteUnitOfWork()) {
                RemoteSessionController controller = ((RemoteUnitOfWork)session).getParentSessionController();
                valueHolder = controller.getRemoteValueHolders().get(((UnitOfWorkValueHolder)unitOfWorkIndirectionObject).getWrappedValueHolderRemoteID());
            }
            return valueHolder;
        }
        return unitOfWorkIndirectionObject;
    }

    @Override
    public void fixObjectReferences(Object object, Map objectDescriptors, Map processedObjects, ObjectLevelReadQuery query, DistributedSession session) {
    }

    @Override
    public AbstractRecord extractReferenceRow(Object referenceObject) {
        if (referenceObject == null || !Proxy.isProxyClass(referenceObject.getClass())) {
            return null;
        }
        ProxyIndirectionHandler handler = (ProxyIndirectionHandler)Proxy.getInvocationHandler(referenceObject);
        ValueHolderInterface<?> valueHolder = handler.getValueHolder();
        if (valueHolder.isInstantiated()) {
            return null;
        }
        return ((DatabaseValueHolder)valueHolder).getRow();
    }

    @Override
    public Object cloneAttribute(Object attributeValue, Object original, CacheKey cacheKey, Object clone, Integer refreshCascade, AbstractSession cloningSession, boolean buildDirectlyFromRow) {
        WeavedAttributeValueHolderInterface<Object> newValueHolder;
        if (!(attributeValue instanceof Proxy)) {
            boolean isExisting = !cloningSession.isUnitOfWork() || ((UnitOfWorkImpl)cloningSession).isObjectRegistered(clone) && !((UnitOfWorkImpl)cloningSession).isOriginalNewObject(original);
            return this.getMapping().buildCloneForPartObject(attributeValue, original, null, clone, cloningSession, refreshCascade, isExisting, !buildDirectlyFromRow);
        }
        ProxyIndirectionHandler handler = (ProxyIndirectionHandler)Proxy.getInvocationHandler(attributeValue);
        ValueHolderInterface<?> oldValueHolder = handler.getValueHolder();
        if (!buildDirectlyFromRow && cloningSession.isUnitOfWork() && ((UnitOfWorkImpl)cloningSession).isOriginalNewObject(original)) {
            if (oldValueHolder instanceof DatabaseValueHolder && !oldValueHolder.isInstantiated() && ((DatabaseValueHolder)oldValueHolder).getSession() == null && !((DatabaseValueHolder)oldValueHolder).isSerializedRemoteUnitOfWorkValueHolder()) {
                throw DescriptorException.attemptToRegisterDeadIndirection(original, this.getMapping());
            }
            newValueHolder = new ValueHolder();
            newValueHolder.setValue(this.getMapping().buildCloneForPartObject(oldValueHolder.getValue(), original, null, clone, cloningSession, refreshCascade, false, false));
        } else {
            AbstractRecord row = null;
            if (oldValueHolder instanceof DatabaseValueHolder) {
                row = ((DatabaseValueHolder)oldValueHolder).getRow();
            }
            newValueHolder = this.getMapping().createCloneValueHolder(oldValueHolder, original, clone, row, cloningSession, buildDirectlyFromRow);
        }
        return ProxyIndirectionHandler.newProxyInstance(attributeValue.getClass(), this.targetInterfaces, newValueHolder);
    }

    @Override
    public Object backupCloneAttribute(Object attributeValue, Object clone, Object backup, UnitOfWorkImpl unitOfWork) {
        if (!(attributeValue instanceof Proxy)) {
            return this.getMapping().buildBackupCloneForPartObject(attributeValue, clone, backup, unitOfWork);
        }
        ProxyIndirectionHandler handler = (ProxyIndirectionHandler)Proxy.getInvocationHandler(attributeValue);
        ValueHolderInterface<?> unitOfWorkValueHolder = handler.getValueHolder();
        ValueHolderInterface backupValueHolder = null;
        if (!(unitOfWorkValueHolder instanceof UnitOfWorkValueHolder) || unitOfWorkValueHolder.isInstantiated()) {
            backupValueHolder = (ValueHolderInterface)super.backupCloneAttribute(unitOfWorkValueHolder, clone, backup, unitOfWork);
        } else {
            backupValueHolder = new BackupValueHolder(unitOfWorkValueHolder);
            ((UnitOfWorkValueHolder)unitOfWorkValueHolder).setBackupValueHolder(backupValueHolder);
        }
        return ProxyIndirectionHandler.newProxyInstance(attributeValue.getClass(), this.targetInterfaces, backupValueHolder);
    }

    @Override
    public void iterateOnAttributeValue(DescriptorIterator iterator, Object attributeValue) {
        if (attributeValue instanceof Proxy) {
            ProxyIndirectionHandler handler = (ProxyIndirectionHandler)Proxy.getInvocationHandler(attributeValue);
            ValueHolderInterface<?> valueHolder = handler.getValueHolder();
            iterator.iterateValueHolderForMapping(valueHolder, this.getMapping());
        } else if (attributeValue != null) {
            this.getMapping().iterateOnRealAttributeValue(iterator, attributeValue);
        }
    }

    @Override
    public Object validateAttributeOfInstantiatedObject(Object attributeValue) {
        if (attributeValue != null && attributeValue.getClass().getInterfaces().length == 0 && attributeValue instanceof Proxy) {
            System.err.println("** ProxyIndirection attribute validation failed.");
        }
        return attributeValue;
    }

    @Override
    public void validateDeclaredAttributeType(Class attributeType, IntegrityChecker checker) throws DescriptorException {
        if (!this.isValidType(attributeType)) {
            checker.handleError(DescriptorException.invalidAttributeTypeForProxyIndirection(attributeType, this.targetInterfaces, this.getMapping()));
        }
    }

    @Override
    public void validateGetMethodReturnType(Class returnType, IntegrityChecker checker) throws DescriptorException {
        if (!this.isValidType(returnType)) {
            checker.handleError(DescriptorException.invalidGetMethodReturnTypeForProxyIndirection(returnType, this.targetInterfaces, this.getMapping()));
        }
    }

    @Override
    public void validateSetMethodParameterType(Class parameterType, IntegrityChecker checker) throws DescriptorException {
        if (!this.isValidType(parameterType)) {
            checker.handleError(DescriptorException.invalidSetMethodParameterTypeForProxyIndirection(parameterType, this.targetInterfaces, this.getMapping()));
        }
    }

    @Override
    public boolean isAttributeValueFullyBuilt(Object attributeValue) {
        return true;
    }

    public boolean isValidType(Class attributeType) {
        if (!attributeType.isInterface()) {
            return false;
        }
        for (int i = 0; i < this.targetInterfaces.length; ++i) {
            if (attributeType != this.targetInterfaces[i]) continue;
            return true;
        }
        return false;
    }
}

