/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.hadoop;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import oracle.kv.Consistency;
import oracle.kv.Depth;
import oracle.kv.Direction;
import oracle.kv.KVStoreException;
import oracle.kv.Key;
import oracle.kv.KeyRange;
import oracle.kv.ParamConstant;
import oracle.kv.hadoop.KVInputSplit;
import oracle.kv.impl.security.login.RepNodeLoginManager;
import oracle.kv.impl.security.util.KVStoreLogin;
import oracle.kv.impl.topo.StorageNode;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.topo.split.SplitBuilder;
import oracle.kv.impl.topo.split.TopoSplit;
import oracle.kv.impl.util.ExternalDataSourceUtils;
import oracle.kv.impl.util.TopologyLocator;
import oracle.kv.impl.util.registry.RegistryUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;

public abstract class KVInputFormatBase<K, V>
extends InputFormat<K, V> {
    private static String kvStoreName = null;
    private static String[] kvHelperHosts = null;
    private static Direction direction = Direction.UNORDERED;
    private static int batchSize = 0;
    private static Key parentKey = null;
    private static KeyRange subRange = null;
    private static Depth depth = Depth.PARENT_AND_DESCENDANTS;
    private static Consistency consistency = null;
    private static long timeout = 0L;
    private static TimeUnit timeoutUnit = null;
    private static String formatterClassName = null;
    private static String kvStoreSecurityFile = null;

    protected KVInputFormatBase() {
    }

    public List<InputSplit> getSplits(JobContext context) throws IOException, InterruptedException {
        if (context != null) {
            Configuration conf = context.getConfiguration();
            this.initializeParameters(conf);
        }
        if (kvStoreName == null) {
            throw new IllegalArgumentException("No KV Store Name provided. Use either the " + ParamConstant.KVSTORE_NAME.getName() + " parameter or call " + KVInputFormatBase.class.getName() + ".setKVStoreName().");
        }
        if (kvHelperHosts == null) {
            throw new IllegalArgumentException("No KV Helper Hosts were provided. Use either the " + ParamConstant.KVSTORE_NODES.getName() + " parameter or call " + KVInputFormatBase.class.getName() + ".setKVHelperHosts().");
        }
        KVStoreLogin storeLogin = new KVStoreLogin(null, kvStoreSecurityFile);
        storeLogin.loadSecurityProperties();
        storeLogin.prepareRegistryCSF();
        RepNodeLoginManager loginMgr = null;
        if (storeLogin.foundTransportSettings()) {
            loginMgr = KVStoreLogin.getRepNodeLoginMgr(kvHelperHosts, storeLogin.getLoginCredentials(), kvStoreName);
        }
        Topology topology = null;
        try {
            topology = TopologyLocator.get(kvHelperHosts, 0, loginMgr, kvStoreName);
        }
        catch (KVStoreException KVSE) {
            KVSE.printStackTrace();
            return null;
        }
        SplitBuilder sb = new SplitBuilder(topology);
        List<TopoSplit> splits = sb.createShardSplits(consistency);
        ArrayList<InputSplit> ret = new ArrayList<InputSplit>(splits.size());
        RegistryUtils regUtils = new RegistryUtils(topology, loginMgr);
        for (TopoSplit ts : splits) {
            if (ts.isEmpty()) continue;
            ArrayList<String> repNodeNames = new ArrayList<String>();
            ArrayList<String> repNodeNamesAndPorts = new ArrayList<String>();
            for (StorageNode sn : ts.getSns(consistency, topology, regUtils)) {
                repNodeNames.add(sn.getHostname());
                repNodeNamesAndPorts.add(sn.getHostname() + ":" + sn.getRegistryPort());
            }
            ret.add(new KVInputSplit().setKVHelperHosts(repNodeNamesAndPorts.toArray(new String[0])).setKVStoreName(kvStoreName).setKVStoreSecurityFile(storeLogin.getSecurityFilePath()).setLocations(repNodeNames.toArray(new String[0])).setDirection(direction).setBatchSize(batchSize).setParentKey(parentKey).setSubRange(subRange).setDepth(depth).setConsistency(consistency).setTimeout(timeout).setTimeoutUnit(timeoutUnit).setFormatterClassName(formatterClassName).setPartitionSets(ts.getPartitionSets()));
        }
        return ret;
    }

    public static void setKVStoreName(String kvStoreName) {
        KVInputFormatBase.kvStoreName = kvStoreName;
    }

    public static void setKVHelperHosts(String[] kvHelperHosts) {
        KVInputFormatBase.kvHelperHosts = kvHelperHosts;
    }

    @Deprecated
    public static void setDirection(Direction direction) {
        if (!direction.equals(Direction.UNORDERED)) {
            throw new IllegalArgumentException("Direction " + direction + " is not supported");
        }
        KVInputFormatBase.direction = direction;
    }

    public static void setBatchSize(int batchSize) {
        KVInputFormatBase.batchSize = batchSize;
    }

    public static void setParentKey(Key parentKey) {
        KVInputFormatBase.parentKey = parentKey;
    }

    public static void setSubRange(KeyRange subRange) {
        KVInputFormatBase.subRange = subRange;
    }

    public static void setDepth(Depth depth) {
        KVInputFormatBase.depth = depth;
    }

    public static void setConsistency(Consistency consistency) {
        if (consistency != Consistency.ABSOLUTE && consistency != Consistency.NONE_REQUIRED_NO_MASTER && consistency != Consistency.NONE_REQUIRED && consistency != null) {
            throw new IllegalArgumentException("Consistency may only be ABSOLUTE, NONE_REQUIRED_NO_MASTER, or NONE_REQUIRED");
        }
        KVInputFormatBase.consistency = consistency;
    }

    public static void setTimeout(long timeout) {
        KVInputFormatBase.timeout = timeout;
    }

    public static void setTimeoutUnit(TimeUnit timeoutUnit) {
        KVInputFormatBase.timeoutUnit = timeoutUnit;
    }

    public static void setFormatterClassName(String formatterClassName) {
        KVInputFormatBase.formatterClassName = formatterClassName;
    }

    public static void setKVSecurity(String kvStoreSecurity) {
        kvStoreSecurityFile = kvStoreSecurity;
    }

    private void initializeParameters(Configuration conf) {
        if (conf != null) {
            String kvStoreSecurityStr;
            String formatterClassNameStr;
            String timeoutParamName;
            String timeoutStr;
            String consistencyStr;
            String depthStr;
            String subRangeStr;
            String parentKeyStr;
            String batchSizeStr;
            String helperHosts;
            if (kvStoreName == null) {
                kvStoreName = conf.get(ParamConstant.KVSTORE_NAME.getName());
            }
            if (kvHelperHosts == null && (helperHosts = conf.get(ParamConstant.KVSTORE_NODES.getName())) != null) {
                kvHelperHosts = helperHosts.trim().split(",");
            }
            if ((batchSizeStr = conf.get(ParamConstant.BATCH_SIZE.getName())) != null) {
                try {
                    batchSize = Integer.parseInt(batchSizeStr);
                }
                catch (NumberFormatException NFE) {
                    throw new IllegalArgumentException("Invalid value for " + ParamConstant.BATCH_SIZE.getName() + ": " + batchSizeStr);
                }
            }
            if ((parentKeyStr = conf.get(ParamConstant.PARENT_KEY.getName())) != null) {
                parentKey = Key.fromString(parentKeyStr);
            }
            if ((subRangeStr = conf.get(ParamConstant.SUB_RANGE.getName())) != null) {
                subRange = KeyRange.fromString(subRangeStr);
            }
            if ((depthStr = conf.get(ParamConstant.DEPTH.getName())) != null) {
                depth = Depth.valueOf(depthStr);
            }
            if ((consistencyStr = conf.get(ParamConstant.CONSISTENCY.getName())) != null) {
                consistency = ExternalDataSourceUtils.parseConsistency(consistencyStr);
            }
            if ((timeoutStr = conf.get(timeoutParamName = ParamConstant.TIMEOUT.getName())) != null) {
                timeout = ExternalDataSourceUtils.parseTimeout(timeoutStr);
                timeoutUnit = TimeUnit.MILLISECONDS;
            }
            if ((formatterClassNameStr = conf.get(ParamConstant.FORMATTER_CLASS.getName())) != null) {
                formatterClassName = formatterClassNameStr;
            }
            if ((kvStoreSecurityStr = conf.get(ParamConstant.KVSTORE_SECURITY.getName())) != null && kvStoreSecurityFile == null) {
                kvStoreSecurityFile = kvStoreSecurityStr;
            }
        }
    }
}

