/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.client.admin;

import java.io.Serializable;
import oracle.kv.StatementResult;
import oracle.kv.impl.client.admin.ExecutionInfo;

public class ExecutionInfoImpl
implements ExecutionInfo,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_VERSION = 1;
    private final int planId;
    private final boolean isTerminated;
    private final String info;
    private final String infoAsJson;
    private final boolean isSuccess;
    private final String errorMessage;
    private final boolean isCancelled;
    private final boolean needsCancel;
    private final String results;

    public ExecutionInfoImpl(int planId, boolean isTerminated, String info, String infoAsJson, boolean isSuccess, boolean isCancelled, String errorMessage, boolean needsCancel, String results) {
        this.planId = planId;
        this.isTerminated = isTerminated;
        this.info = info;
        this.infoAsJson = infoAsJson;
        this.isSuccess = isSuccess;
        this.isCancelled = isCancelled;
        this.errorMessage = errorMessage;
        this.needsCancel = needsCancel;
        this.results = results;
    }

    ExecutionInfoImpl(StatementResult pastResult) {
        this.planId = pastResult.getPlanId();
        this.isTerminated = pastResult.isDone();
        this.info = pastResult.getInfo();
        this.infoAsJson = pastResult.getInfoAsJson();
        this.isSuccess = pastResult.isSuccessful();
        this.errorMessage = pastResult.getErrorMessage();
        this.isCancelled = pastResult.isCancelled();
        this.needsCancel = false;
        this.results = pastResult.getResult();
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public int getPlanId() {
        return this.planId;
    }

    @Override
    public boolean isTerminated() {
        return this.isTerminated;
    }

    @Override
    public String getJSONInfo() {
        return this.infoAsJson;
    }

    @Override
    public String getInfo() {
        return this.info;
    }

    @Override
    public boolean isSuccess() {
        return this.isSuccess;
    }

    public String toString() {
        return "ExecutionInfoImpl [planId=" + this.planId + ", isTerminated=" + this.isTerminated + ", info=" + this.info + ", infoAsJson=" + this.infoAsJson + "]";
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public boolean needsTermination() {
        return this.needsCancel;
    }

    @Override
    public String getResult() {
        return this.results;
    }
}

