/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.runtime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.impl.api.table.ArrayValueImpl;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.runtime.PlanIterState;
import oracle.kv.impl.query.runtime.RuntimeControlBlock;

public class ArraySliceIter
extends PlanIter {
    private final PlanIter theInputIter;
    private final PlanIter theLowIter;
    private final PlanIter theHighIter;
    private final Long theLowValue;
    private final Long theHighValue;
    private final int theCtxItemReg;

    public ArraySliceIter(Expr e, int resultReg, PlanIter inputIter, PlanIter lowIter, PlanIter highIter, Long lowValue, Long highValue, int ctxItemReg) {
        super(e, resultReg);
        this.theInputIter = inputIter;
        this.theLowIter = lowIter;
        this.theHighIter = highIter;
        this.theLowValue = lowValue != null ? lowValue : 0L;
        this.theHighValue = highValue != null ? highValue : Integer.MAX_VALUE;
        this.theCtxItemReg = ctxItemReg;
        assert (this.theLowValue >= 0L);
    }

    ArraySliceIter(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.theCtxItemReg = ArraySliceIter.readPositiveInt(in, true);
        this.theLowValue = in.readLong();
        this.theHighValue = in.readLong();
        this.theInputIter = ArraySliceIter.deserializeIter(in, serialVersion);
        this.theLowIter = ArraySliceIter.deserializeIter(in, serialVersion);
        this.theHighIter = ArraySliceIter.deserializeIter(in, serialVersion);
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        out.writeInt(this.theCtxItemReg);
        out.writeLong(this.theLowValue);
        out.writeLong(this.theHighValue);
        ArraySliceIter.serializeIter(this.theInputIter, out, serialVersion);
        ArraySliceIter.serializeIter(this.theLowIter, out, serialVersion);
        ArraySliceIter.serializeIter(this.theHighIter, out, serialVersion);
    }

    @Override
    public PlanIter.PlanIterKind getKind() {
        return PlanIter.PlanIterKind.ARRAY_SLICE;
    }

    @Override
    public void open(RuntimeControlBlock rcb) {
        rcb.setState(this.theStatePos, new ArraySliceState(this));
        this.theInputIter.open(rcb);
        if (this.theLowIter != null) {
            this.theLowIter.open(rcb);
        }
        if (this.theHighIter != null) {
            this.theHighIter.open(rcb);
        }
    }

    @Override
    public boolean next(RuntimeControlBlock rcb) {
        ArraySliceState state = (ArraySliceState)rcb.getState(this.theStatePos);
        if (state.isDone()) {
            return false;
        }
        if (this.theCtxItemReg < 0 && state.isOpen()) {
            state.setState(PlanIterState.StateEnum.RUNNING);
            this.computeBoundaryExprs(rcb, state, false);
            if (state.theHaveNullOrEmptyBound || state.theLow > state.theHigh) {
                state.done();
                return false;
            }
        }
        while (true) {
            if (state.theCtxItem == null || state.theCtxItem.isNull()) {
                boolean more = this.theInputIter.next(rcb);
                if (!more) {
                    state.done();
                    return false;
                }
                int inputReg = this.theInputIter.getResultReg();
                FieldValueImpl val = rcb.getRegVal(inputReg);
                if (val.isNull()) {
                    state.theCtxItem = val;
                    rcb.setRegVal(this.theResultReg, val);
                    return true;
                }
                if (val.isArray()) {
                    state.theCtxItem = val;
                    state.theCtxItemSize = ((ArrayValueImpl)val).size();
                } else {
                    state.theSingletonArray.clear();
                    state.theSingletonArray.addInternal(val);
                    state.theCtxItem = state.theSingletonArray;
                    state.theCtxItemSize = 1;
                }
                if (this.theCtxItemReg >= 0) {
                    this.computeBoundaryExprs(rcb, state, true);
                }
                state.theElemPos = (int)state.theLow;
            }
            if (!state.theHaveNullOrEmptyBound && (long)state.theElemPos <= state.theHigh && state.theElemPos < state.theCtxItemSize) break;
            state.theCtxItem = null;
        }
        FieldValueImpl res = state.theCtxItem.getElement(state.theElemPos);
        rcb.setRegVal(this.theResultReg, res);
        ++state.theElemPos;
        return true;
    }

    private void computeBoundaryExprs(RuntimeControlBlock rcb, ArraySliceState state, boolean reset) {
        FieldValueImpl val;
        boolean more;
        state.theHaveNullOrEmptyBound = false;
        if (this.theCtxItemReg > 0) {
            rcb.setRegVal(this.theCtxItemReg, state.theCtxItem);
        }
        if (this.theLowIter != null) {
            if (reset) {
                this.theLowIter.reset(rcb);
            }
            if (!(more = this.theLowIter.next(rcb))) {
                state.theHaveNullOrEmptyBound = true;
            } else {
                val = rcb.getRegVal(this.theLowIter.getResultReg());
                if (val.isNull()) {
                    state.theHaveNullOrEmptyBound = true;
                } else {
                    state.theLow = val.getLong();
                    if (state.theLow < 0L) {
                        state.theLow = 0L;
                    }
                }
            }
        }
        if (this.theHighIter != null) {
            if (this.theHighIter == this.theLowIter) {
                state.theHigh = state.theLow;
                return;
            }
            if (reset) {
                this.theHighIter.reset(rcb);
            }
            if (!(more = this.theHighIter.next(rcb))) {
                state.theHaveNullOrEmptyBound = true;
            } else {
                val = rcb.getRegVal(this.theHighIter.getResultReg());
                if (val.isNull()) {
                    state.theHaveNullOrEmptyBound = true;
                } else {
                    state.theHigh = val.getLong();
                }
            }
        }
    }

    @Override
    public void reset(RuntimeControlBlock rcb) {
        this.theInputIter.reset(rcb);
        if (this.theLowIter != null) {
            this.theLowIter.reset(rcb);
        }
        if (this.theHighIter != null) {
            this.theHighIter.reset(rcb);
        }
        PlanIterState state = rcb.getState(this.theStatePos);
        state.reset(this);
    }

    @Override
    public void close(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        if (state == null) {
            return;
        }
        this.theInputIter.close(rcb);
        if (this.theLowIter != null) {
            this.theLowIter.close(rcb);
        }
        if (this.theHighIter != null) {
            this.theHighIter.close(rcb);
        }
        state.close();
    }

    @Override
    void getParentItemContext(RuntimeControlBlock rcb, PlanIter.ParentItemContext ctx) {
        ArraySliceState state = (ArraySliceState)rcb.getState(this.theStatePos);
        if (state.theCtxItem == state.theSingletonArray) {
            this.theInputIter.getParentItemContext(rcb, ctx);
        } else {
            ctx.theParentItem = state.theCtxItem;
            ctx.theTargetPos = state.theElemPos - 1;
            ctx.theTargetKey = null;
        }
    }

    @Override
    protected void displayContent(StringBuilder sb, QueryFormatter formatter) {
        this.theInputIter.display(sb, formatter);
        sb.append(",\n");
        if (this.theLowIter != null) {
            this.theLowIter.display(sb, formatter);
        } else {
            formatter.indent(sb);
            sb.append("low bound: ").append(this.theLowValue);
        }
        sb.append(",\n");
        if (this.theHighIter != null) {
            this.theHighIter.display(sb, formatter);
        } else {
            formatter.indent(sb);
            sb.append("high bound: ").append(this.theHighValue);
        }
        if (this.theCtxItemReg >= 0) {
            sb.append(",\n");
            formatter.indent(sb);
            sb.append("theCtxItemReg : ").append(this.theCtxItemReg);
        }
    }

    private static class ArraySliceState
    extends PlanIterState {
        long theLow;
        long theHigh;
        boolean theHaveNullOrEmptyBound;
        FieldValueImpl theCtxItem;
        int theCtxItemSize;
        ArrayValueImpl theSingletonArray;
        int theElemPos;

        ArraySliceState(ArraySliceIter iter) {
            this.init(iter);
            this.theSingletonArray = FieldDefImpl.arrayAnyDef.createArray();
        }

        @Override
        public void reset(PlanIter iter) {
            super.reset(iter);
            this.init((ArraySliceIter)iter);
            this.theHaveNullOrEmptyBound = false;
        }

        @Override
        public void close() {
            super.close();
            this.theCtxItem = null;
            this.theSingletonArray = null;
        }

        private void init(ArraySliceIter iter) {
            this.theLow = iter.theLowValue;
            this.theHigh = iter.theHighValue;
            this.theCtxItem = null;
            this.theElemPos = 0;
        }
    }
}

