/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.expressions;

import java.sql.Date;
import java.util.Calendar;
import java.util.Vector;
import junit.framework.Test;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.expressions.ExpressionMath;
import org.eclipse.persistence.queries.InMemoryQueryIndirectionPolicy;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.framework.TestEntity;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.expressions.ExpressionUnitTestSuite;
import org.eclipse.persistence.testing.tests.expressions.ReadAllExpressionTest;

public class ExpressionInMemoryTestSuite
extends ExpressionUnitTestSuite {
    public ExpressionInMemoryTestSuite() {
        this.setDescription("This suite tests expressions executed in memory.");
    }

    private void _addAdvancedInMemoryExpressionMathTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("salary").greaterThanEqual(1000);
        expression = expression.and(ExpressionMath.floor((Expression)builder.get("salary")).lessThan(45000));
        expression = expression.and(ExpressionMath.ceil((Expression)builder.get("salary")).lessThan(10000));
        expression = expression.and(ExpressionMath.round((Expression)builder.get("salary"), (int)2).equal(40000));
        expression = expression.and(ExpressionMath.min((Expression)builder.get("salary"), (Object)30000).greaterThan(30000));
        expression = expression.and(ExpressionMath.max((Expression)builder.get("salary"), (Object)30000).lessThan(50000));
        expression = expression.and(ExpressionMath.acos((Expression)ExpressionMath.power((Expression)builder.get("salary"), (int)0)).lessThanEqual(100));
        expression = expression.and(ExpressionMath.asin((Expression)ExpressionMath.power((Expression)builder.get("salary"), (int)0)).lessThanEqual(100));
        expression = expression.and(ExpressionMath.atan((Expression)ExpressionMath.power((Expression)builder.get("salary"), (int)0)).lessThanEqual(100));
        expression = expression.and(ExpressionMath.power((Expression)builder.get("salary"), (int)1).equal(40000));
        expression = expression.and(ExpressionMath.round((Expression)builder.get("salary"), (int)2).equal(40000));
        expression = expression.and(ExpressionMath.exp((Expression)ExpressionMath.min((Expression)builder.get("salary"), (int)5)).lessThan(1000000));
        expression = expression.and(ExpressionMath.power((Expression)builder.get("salary"), (Object)0.5).greaterThan(0));
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 0);
        test.setExpression(expression);
        test.setName("AdvancedInMemoryExpressionMathTest");
        test.setDescription("Test advanced expression math package In-Memory");
        this.addTest((Test)test);
    }

    protected void _addBetween$DateTest() {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1900, 1, 1);
        Date start = new Date(calendar.getTime().getTime());
        calendar.set(1902, 1, 1);
        Date end = new Date(calendar.getTime().getTime());
        Expression expression = new ExpressionBuilder().get("period").get("startDate").between((Object)start, (Object)end);
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 6);
        test.setExpression(expression);
        test.setName("Between$DateTest");
        test.setDescription("Test BETWEEN (Date) expression InMemory.");
        this.addTest((Test)test);
    }

    protected void _addBetween$StringTest() {
        Expression expression = new ExpressionBuilder().get("firstName").between((Object)"Babi", (Object)"Buzz");
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 2);
        test.setExpression(expression);
        test.setName("Between$StringTest");
        test.setDescription("Test BETWEEN (String) expression inMemory");
        this.addTest((Test)test);
    }

    protected void _addEqual$nullTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("manager").equal(builder.value(null));
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 4);
        test.setExpression(expression);
        test.setName("Equal$nullTest");
        test.setDescription("Test Equal(null) expression inMemory");
        this.addTest((Test)test);
    }

    protected void _addEqual$DateTest() {
        Employee employee = (Employee)this.getManager().getObject(new Employee().getClass(), "0003");
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("period").get("startDate").equal((Object)employee.getPeriod().getStartDate());
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 6);
        test.setExpression(expression);
        test.setName("Equal$DateTest");
        test.setDescription("Test Equal(Date) expression inMemory");
        this.addTest((Test)test);
    }

    protected void _addEqual$StringTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("firstName").equal((Object)"Bob");
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 1);
        test.setExpression(expression);
        test.setName("Equal$StringTest");
        test.setDescription("Test Equal(String) expression inMemory");
        this.addTest((Test)test);
    }

    protected void _addGreaterThan$nullTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("salary").greaterThan(builder.value(null));
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 0);
        test.setExpression(expression);
        test.setName("GreaterThan$nullTest");
        test.setDescription("Test GreaterThan(null) expression inMemory");
        this.addTest((Test)test);
    }

    protected void _addGreaterThan$DateTest() {
        Employee employee = (Employee)this.getManager().getObject(new Employee().getClass(), "0003");
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("period").get("startDate").greaterThan((Object)employee.getPeriod().getStartDate());
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 5);
        test.setExpression(expression);
        test.setName("GreaterThan$DateTest");
        test.setDescription("Test GreaterThan(Date) expression inMemory");
        this.addTest((Test)test);
    }

    protected void _addGreaterThan$StringTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("firstName").greaterThan((Object)"Bob");
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 10);
        test.setExpression(expression);
        test.setName("GreaterThan$StringTest");
        test.setDescription("Test GreaterThan(String) expression inMemory");
        this.addTest((Test)test);
    }

    protected void _addGreaterThanEqual$nullTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("salary").greaterThanEqual(builder.value(null));
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 0);
        test.setExpression(expression);
        test.setName("GreaterThanEqual$nullTest");
        test.setDescription("Test GreaterThanEqual(null) expression inMemory");
        this.addTest((Test)test);
    }

    protected void _addGreaterThanEqual$DateTest() {
        Employee employee = (Employee)this.getManager().getObject(new Employee().getClass(), "0003");
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("period").get("startDate").greaterThanEqual((Object)employee.getPeriod().getStartDate());
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 11);
        test.setExpression(expression);
        test.setName("GreaterThanEqual$DateTest");
        test.setDescription("Test GreaterThanEqual(Date) expression inMemory");
        this.addTest((Test)test);
    }

    protected void _addGreaterThanEqual$StringTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("firstName").greaterThanEqual((Object)"Bob");
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 11);
        test.setExpression(expression);
        test.setName("GreaterThanEqual$StringTest");
        test.setDescription("Test GreaterThanEqual(String) expression inMemory");
        this.addTest((Test)test);
    }

    protected void _addLessThan$nullTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("salary").lessThan(builder.value(null));
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 0);
        test.setExpression(expression);
        test.setName("LessThan$nullTest");
        test.setDescription("Test LessThan(null) expression inMemory");
        this.addTest((Test)test);
    }

    protected void _addIsNullAccrossAnyOfTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.anyOf("projects").get("teamLeader").equal(null);
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 4);
        test.setExpression(expression);
        test.setName("IsNullAccrossAnyOfTest");
        test.setDescription("Test anyOf().get().isNull expression inMemory");
        this.addTest((Test)test);
    }

    protected void _addIsNullAccrossAnyOfWorkaroundTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.anyOf("projects").get("teamLeader").equal(builder.value(null));
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 6);
        test.setExpression(expression);
        test.setName("IsNullAccrossAnyOfWorkaroundTest");
        test.setDescription("Test anyOf().get().isNull expression inMemory");
        this.addTest((Test)test);
    }

    protected void _addIsNullAccrossAnyOfWorkaround2Test() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.anyOf("projects").get("teamLeader").equal(builder.getParameter("TL"));
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 6);
        test.setExpression(expression);
        ReadAllQuery query = test.getQuery(true);
        query.addArgument("TL");
        test.getArguments().add(null);
        test.setName("IsNullAccrossAnyOfWorkaround2Test");
        test.setDescription("Test anyOf().get().isNull expression inMemory");
        this.addTest((Test)test);
    }

    protected void _addLessThan$DateTest() {
        Employee employee = (Employee)this.getManager().getObject(new Employee().getClass(), "0003");
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("period").get("startDate").lessThan((Object)employee.getPeriod().getStartDate());
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 1);
        test.setExpression(expression);
        test.setName("LessThan$DateTest");
        test.setDescription("Test LessThan(Date) expression inMemory");
        this.addTest((Test)test);
    }

    protected void _addLessThan$StringTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("firstName").lessThan((Object)"Bob");
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 1);
        test.setExpression(expression);
        test.setName("LessThan$StringTest");
        test.setDescription("Test LessThan(String) expression inMemory");
        this.addTest((Test)test);
    }

    protected void _addLessThanEqual$nullTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("salary").lessThanEqual(builder.value(null));
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 0);
        test.setExpression(expression);
        test.setName("LessThanEqual$nullTest");
        test.setDescription("Test LessThanEqual(null) expression inMemory");
        this.addTest((Test)test);
    }

    protected void _addLessThanEqual$DateTest() {
        Employee employee = (Employee)this.getManager().getObject(new Employee().getClass(), "0003");
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("period").get("startDate").lessThanEqual((Object)employee.getPeriod().getStartDate());
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 7);
        test.setExpression(expression);
        test.setName("LessThanEqual$DateTest");
        test.setDescription("Test LessThanEqual(Date) expression inMemory");
        this.addTest((Test)test);
    }

    protected void _addLessThanEqual$StringTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("firstName").lessThanEqual((Object)"Bob");
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 2);
        test.setExpression(expression);
        test.setName("LessThanEqual$StringTest");
        test.setDescription("Test LessThanEqual(String) expression inMemory");
        this.addTest((Test)test);
    }

    protected void _addNotEqual$nullTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("manager").notEqual(builder.value(null));
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 8);
        test.setExpression(expression);
        test.setName("NotEqual$nullTest");
        test.setDescription("Test NotEqual(null) expression inMemory");
        this.addTest((Test)test);
    }

    protected void _addNotEqual$DateTest() {
        Employee employee = (Employee)this.getManager().getObject(new Employee().getClass(), "0003");
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("period").get("startDate").notEqual((Object)employee.getPeriod().getStartDate());
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 6);
        test.setExpression(expression);
        test.setName("NotEqual$DateTest");
        test.setDescription("Test NotEqual(Date) expression inMemory");
        this.addTest((Test)test);
    }

    protected void _addNotEqual$StringTest() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("firstName").notEqual((Object)"Bob");
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 11);
        test.setExpression(expression);
        test.setName("NotEqual$StringTest");
        test.setDescription("Test NotEqual(String) expression inMemory");
        this.addTest((Test)test);
    }

    protected void _addToNumberTest() {
        Expression expression = new ExpressionBuilder().anyOf("phoneNumbers").get("areaCode").toNumber().equal(613);
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 10);
        test.setExpression(expression);
        test.setName("ToNumberTest");
        test.setDescription("Test ToNumber expression InMemory");
        this.addTest((Test)test);
    }

    protected void _addLikeDoubleWildcardTest() {
        Expression expression = new ExpressionBuilder().get("firstName").like("B__");
        ReadAllExpressionTest test = new ReadAllExpressionTest(Employee.class, 1);
        test.setExpression(expression);
        test.setName("LikeDoubleWildCardTest");
        test.setDescription("Test like expression with two consecutive wildcards");
        this.addTest((Test)test);
    }

    @Override
    public void addTests() {
        this.addBaseExpressionTests();
        super.addTests();
        this._addAdvancedInMemoryExpressionMathTest();
        this._addBetween$DateTest();
        this._addBetween$StringTest();
        this._addEqual$nullTest();
        this._addEqual$DateTest();
        this._addEqual$longTest();
        this._addEqual$StringTest();
        this._addGreaterThan$nullTest();
        this._addGreaterThan$DateTest();
        this._addGreaterThan$longTest();
        this._addGreaterThan$StringTest();
        this._addGreaterThanEqual$nullTest();
        this._addGreaterThanEqual$DateTest();
        this._addGreaterThanEqual$longTest();
        this._addGreaterThanEqual$StringTest();
        this._addIsNullAccrossAnyOfTest();
        this._addIsNullAccrossAnyOfWorkaroundTest();
        this._addIsNullAccrossAnyOfWorkaround2Test();
        this._addLengthTest();
        this._addLessThan$nullTest();
        this._addLessThan$DateTest();
        this._addLessThan$longTest();
        this._addLessThan$StringTest();
        this._addLessThanEqual$nullTest();
        this._addLessThanEqual$DateTest();
        this._addLessThanEqual$longTest();
        this._addLessThanEqual$StringTest();
        this._addNotBetween$longTest();
        this._addNotEqual$nullTest();
        this._addNotEqual$DateTest();
        this._addNotEqual$longTest();
        this._addNotEqual$StringTest();
        this._addToNumberTest();
        this._addLikeDoubleWildcardTest();
        Vector<TestEntity> inMemoryTests = new Vector<TestEntity>(this.getTests().size());
        for (TestEntity baseTest : this.getTests()) {
            ReadAllExpressionTest test;
            if (!(baseTest instanceof ReadAllExpressionTest) || (test = (ReadAllExpressionTest)baseTest).isPlatformSpecific() || !this.shouldTestPassInMemory(test)) continue;
            ReadAllQuery query = test.getQuery(true);
            query.checkCacheOnly();
            InMemoryQueryIndirectionPolicy policy = new InMemoryQueryIndirectionPolicy();
            policy.triggerIndirection();
            query.setInMemoryQueryIndirectionPolicy(policy);
            inMemoryTests.addElement(baseTest);
        }
        inMemoryTests.trimToSize();
        this.setTests(inMemoryTests);
    }

    public boolean shouldTestPassInMemory(ReadAllExpressionTest test) {
        String name = test.getName();
        return name.indexOf("MultiPlatformTest") <= -1 && name.indexOf("Batch") <= -1 && name.indexOf("$float") <= -1 && name.indexOf("$char") <= -1 && !name.equals("JoinsShrinkResultSetSizeTest") && !name.equals("NotSelfManagedEmployeeTest") && !name.equals("NotEqualSelfManagedEmployeeTest") && !name.equals("NotBetween$ObjectTest") && !name.equals("IsNullAccrossAnyOfTest") && !name.equals("VehicleViewJoinOnlyTest");
    }
}

