/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.identitymaps;

import java.util.ArrayList;
import org.eclipse.persistence.internal.identitymaps.IdentityMap;
import org.eclipse.persistence.internal.identitymaps.SoftCacheWeakIdentityMap;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class CleanupCacheKeyCorrectnessTest
extends TestCase {
    protected Class<? extends IdentityMap> originalIdentityMapClass;
    protected Class<? extends IdentityMap> newIdentityMapClass;
    protected int originalIdentityMapSize;
    protected int newIdentityMapSize;
    protected int numberOfObjectsToCreate;
    protected int objectsNotFoundInIdentityMap;

    public CleanupCacheKeyCorrectnessTest() {
        this.setDescription("This test verifies that CacheKeys with null object references aren't removed when calling IdentityMap.put()");
    }

    public void setup() {
        this.originalIdentityMapClass = this.getSession().getDescriptor(Employee.class).getIdentityMapClass();
        this.originalIdentityMapSize = this.getSession().getDescriptor(Employee.class).getIdentityMapSize();
        this.newIdentityMapClass = SoftCacheWeakIdentityMap.class;
        this.newIdentityMapSize = 5;
        this.objectsNotFoundInIdentityMap = 0;
        this.numberOfObjectsToCreate = this.newIdentityMapSize * 5;
        this.getSession().getDescriptor(Employee.class).setIdentityMapClass(this.newIdentityMapClass);
        this.getSession().getDescriptor(Employee.class).setIdentityMapSize(this.newIdentityMapSize);
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.beginTransaction();
    }

    public void test() {
        ArrayList<Employee> employees = new ArrayList<Employee>(this.numberOfObjectsToCreate);
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        for (int i = 0; i < this.numberOfObjectsToCreate; ++i) {
            int identifier = i + 1;
            Employee employee = new Employee();
            employees.add(employee);
            employee.setFirstName("Bob");
            employee.setLastName("Jones#" + identifier);
            uow.registerObject((Object)employee);
        }
        uow.commit();
        for (Employee employee : employees) {
            if (this.getSession().getIdentityMapAccessor().containsObjectInIdentityMap((Object)employee)) continue;
            ++this.objectsNotFoundInIdentityMap;
        }
    }

    public void verify() {
        if (this.objectsNotFoundInIdentityMap > 0) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("The IdentityMap - size(");
            buffer.append(this.newIdentityMapSize);
            buffer.append(") removed ");
            buffer.append(this.objectsNotFoundInIdentityMap);
            buffer.append(" new objects out of ");
            buffer.append(this.numberOfObjectsToCreate);
            buffer.append(" objects added. No objects should have been removed.");
            throw new TestErrorException(buffer.toString());
        }
    }

    public void reset() {
        this.rollbackTransaction();
        this.getSession().getDescriptor(Employee.class).setIdentityMapClass(this.originalIdentityMapClass);
        this.getSession().getDescriptor(Employee.class).setIdentityMapSize(this.originalIdentityMapSize);
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }
}

