/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.inheritance;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;
import junit.framework.Test;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteAllQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.UpdateAllQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.JoinedAttributeTestHelper;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.models.inheritance.STI_Employee;
import org.eclipse.persistence.testing.models.inheritance.STI_EmployeePopulator;
import org.eclipse.persistence.testing.models.inheritance.STI_Project;

public class STI_JoinedAttributeTest
extends TestCase {
    protected static boolean eachTestShouldEnsurePopulation = false;
    protected static Class<?>[] classes = new Class[]{STI_Employee.class, STI_Project.class};
    protected static Vector[] objectVectors = new Vector[]{null, null};
    protected static STI_EmployeePopulator populator = new STI_EmployeePopulator();

    public STI_JoinedAttributeTest(String name) {
        this.setName(name);
    }

    public static TestSuite getTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("STI_JoinedAttributeTest");
        suite.setDescription("This suite tests join attribute on a Single Table Inheritance version of Employee/Project.");
        Method[] methods = STI_JoinedAttributeTest.class.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!STI_JoinedAttributeTest.isPublicTestMethod(methods[i])) continue;
            suite.addTest((Test)new STI_JoinedAttributeTest(methods[i].getName()));
        }
        return suite;
    }

    private static boolean isPublicTestMethod(Method m) {
        return STI_JoinedAttributeTest.isTestMethod(m) && Modifier.isPublic(m.getModifiers());
    }

    private static boolean isTestMethod(Method m) {
        String name = m.getName();
        Class<?>[] parameters = m.getParameterTypes();
        Class<?> returnType = m.getReturnType();
        return parameters.length == 0 && name.startsWith("test") && returnType.equals(Void.TYPE);
    }

    protected void setup() throws Throwable {
        this.clearCache();
        if (eachTestShouldEnsurePopulation) {
            if (!this.compare()) {
                this.clear();
                this.populate();
            }
            this.clearCache();
        }
    }

    protected void test() throws Exception {
        Method method = ((Object)((Object)this)).getClass().getDeclaredMethod(this.getName(), new Class[0]);
        method.invoke((Object)this, new Object[0]);
    }

    public void reset() {
        this.clearCache();
    }

    protected void clear() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        UpdateAllQuery updateEmployees = new UpdateAllQuery(STI_Employee.class);
        updateEmployees.addUpdate("manager", null);
        uow.executeQuery((DatabaseQuery)updateEmployees);
        UpdateAllQuery updateProjects = new UpdateAllQuery(STI_Project.class);
        updateProjects.addUpdate("teamLeader", null);
        uow.executeQuery((DatabaseQuery)updateProjects);
        uow.executeQuery((DatabaseQuery)new DeleteAllQuery(STI_Employee.class));
        uow.executeQuery((DatabaseQuery)new DeleteAllQuery(STI_Project.class));
        uow.commit();
        this.clearCache();
    }

    protected void populate() {
        populator.buildExamples();
        populator.persistExample(this.getSession());
        this.clearCache();
        for (int i = 0; i < classes.length; ++i) {
            STI_JoinedAttributeTest.objectVectors[i] = this.getSession().readAllObjects(classes[i]);
        }
    }

    public void testProjectJoinTeamMembers() {
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(STI_Project.class);
        ReadAllQuery controlQuery = (ReadAllQuery)query.clone();
        query.addJoinedAttribute(query.getExpressionBuilder().anyOf("teamMembers"));
        String errorMsg = this.executeQueriesAndCompareResults((ObjectLevelReadQuery)controlQuery, (ObjectLevelReadQuery)query);
        if (errorMsg.length() > 0) {
            this.failTest(errorMsg);
        }
    }

    public void testProjectJoinTeamLeaderWhereTeamLeaderNotNull() {
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(STI_Project.class);
        Expression teamLeader = query.getExpressionBuilder().get("teamLeader");
        query.setSelectionCriteria(teamLeader.notNull());
        ReadAllQuery controlQuery = (ReadAllQuery)query.clone();
        query.addJoinedAttribute(teamLeader);
        String errorMsg = this.executeQueriesAndCompareResults((ObjectLevelReadQuery)controlQuery, (ObjectLevelReadQuery)query);
        if (errorMsg.length() > 0) {
            this.failTest(errorMsg);
        }
    }

    public void testProjectOuterJoinTeamMembers() {
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(STI_Project.class);
        ReadAllQuery controlQuery = (ReadAllQuery)query.clone();
        Expression teamMembers = query.getExpressionBuilder().anyOfAllowingNone("teamMembers");
        query.addJoinedAttribute(teamMembers);
        String errorMsg = this.executeQueriesAndCompareResults((ObjectLevelReadQuery)controlQuery, (ObjectLevelReadQuery)query);
        if (errorMsg.length() > 0) {
            this.failTest(errorMsg);
        }
    }

    public void testProblemReporterProjectJoinTeamMembers() {
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(STI_Project.class);
        query.setSelectionCriteria(query.getExpressionBuilder().get("name").equal((Object)"Problem Reporter"));
        ReadAllQuery controlQuery = (ReadAllQuery)query.clone();
        Expression teamMembers = query.getExpressionBuilder().anyOf("teamMembers");
        query.addJoinedAttribute(teamMembers);
        String errorMsg = this.executeQueriesAndCompareResults((ObjectLevelReadQuery)controlQuery, (ObjectLevelReadQuery)query);
        if (errorMsg.length() > 0) {
            this.failTest(errorMsg);
        }
    }

    public void testEmployeeJoinProjects() {
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(STI_Employee.class);
        ReadAllQuery controlQuery = (ReadAllQuery)query.clone();
        query.addJoinedAttribute(query.getExpressionBuilder().anyOf("projects"));
        String errorMsg = this.executeQueriesAndCompareResults((ObjectLevelReadQuery)controlQuery, (ObjectLevelReadQuery)query);
        if (errorMsg.length() > 0) {
            this.failTest(errorMsg);
        }
    }

    public void testEmployeeJoinProjectsJoinTeamLeaderWhereManagerIsNull() {
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(STI_Employee.class);
        query.setSelectionCriteria(query.getExpressionBuilder().get("manager").isNull());
        ReadAllQuery controlQuery = (ReadAllQuery)query.clone();
        Expression projects = query.getExpressionBuilder().anyOf("projects");
        query.addJoinedAttribute(projects);
        Expression teamLeader = projects.get("teamLeader");
        query.addJoinedAttribute(teamLeader);
        String errorMsg = this.executeQueriesAndCompareResults((ObjectLevelReadQuery)controlQuery, (ObjectLevelReadQuery)query);
        if (errorMsg.length() > 0) {
            this.failTest(errorMsg);
        }
    }

    public void testProjectOuterJoinTeamLeaderTeamMembersWhereProjectName() {
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(STI_Project.class);
        query.setSelectionCriteria(query.getExpressionBuilder().get("name").equal((Object)"Problem Reporting System").or(query.getExpressionBuilder().get("name").equal((Object)"Bleep Blob")));
        ReadAllQuery controlQuery = (ReadAllQuery)query.clone();
        Expression teamLeader = query.getExpressionBuilder().getAllowingNull("teamLeader");
        query.addJoinedAttribute(teamLeader);
        Expression teamMembers = query.getExpressionBuilder().anyOfAllowingNone("teamMembers");
        query.addJoinedAttribute(teamMembers);
        String errorMsg = this.executeQueriesAndCompareResults((ObjectLevelReadQuery)controlQuery, (ObjectLevelReadQuery)query);
        if (errorMsg.length() > 0) {
            this.failTest(errorMsg);
        }
    }

    public void testEmployeeOuterJoinProjectsTeamLeader() {
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(STI_Employee.class);
        ReadAllQuery controlQuery = (ReadAllQuery)query.clone();
        Expression projects = query.getExpressionBuilder().anyOfAllowingNone("projects");
        query.addJoinedAttribute(projects);
        Expression teamLeader = projects.getAllowingNull("teamLeader");
        query.addJoinedAttribute(teamLeader);
        Expression teamMembers = projects.anyOfAllowingNone("teamMembers");
        query.addJoinedAttribute(teamMembers);
        String errorMsg = this.executeQueriesAndCompareResults((ObjectLevelReadQuery)controlQuery, (ObjectLevelReadQuery)query);
        if (errorMsg.length() > 0) {
            this.failTest(errorMsg);
        }
    }

    protected String executeQueriesAndCompareResults(ObjectLevelReadQuery controlQuery, ObjectLevelReadQuery queryWithJoins) {
        return JoinedAttributeTestHelper.executeQueriesAndCompareResults((ObjectLevelReadQuery)controlQuery, (ObjectLevelReadQuery)queryWithJoins, (AbstractSession)((AbstractSession)this.getSession()));
    }

    protected void failTest(String errorMsg) {
        throw new TestErrorException(errorMsg);
    }

    protected boolean compare() {
        for (int i = 0; i < classes.length; ++i) {
            if (this.compare(i)) continue;
            return false;
        }
        return true;
    }

    protected boolean compare(int i) {
        if (objectVectors[i] == null) {
            return false;
        }
        Vector currentVector = this.getSession().readAllObjects(classes[i]);
        if (currentVector.size() != objectVectors[i].size()) {
            return false;
        }
        ClassDescriptor descriptor = this.getSession().getDescriptor(classes[i]);
        for (int j = 0; j < currentVector.size(); ++j) {
            Object obj1 = objectVectors[i].elementAt(j);
            Object obj2 = currentVector.elementAt(j);
            if (descriptor.getObjectBuilder().compareObjects(obj1, obj2, (AbstractSession)this.getSession())) continue;
            return false;
        }
        return true;
    }

    protected void clearCache() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }
}

