/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.optimization.queryandsqlcounting.querycache;

import java.util.Vector;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.optimization.queryandsqlcounting.querycache.NamedQueryQueryCacheTest;

public class PartialAttributeQueryCacheTest
extends NamedQueryQueryCacheTest {
    public PartialAttributeQueryCacheTest() {
        this.setDescription("Ensure queries using partial attributes can use query caching.");
    }

    @Override
    public ReadQuery getQueryForTest() {
        ReadAllQuery testQuery = (ReadAllQuery)super.getQueryForTest();
        testQuery.addPartialAttribute("firstName");
        testQuery.addPartialAttribute("lastName");
        testQuery.dontMaintainCache();
        testQuery.cacheQueryResults();
        return testQuery;
    }

    @Override
    public void verify() {
        super.verify();
        for (Employee emp : (Vector)this.results) {
            if (emp.getFirstName() == null || emp.getLastName() == null) {
                throw new TestErrorException("Returned query result was missing data for partial object query with query caching turned on.");
            }
            if (emp.getSalary() <= 0) continue;
            throw new TestErrorException("Additional results were returned in a partial object  query with caching turned on.");
        }
    }
}

