/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.oracle;

import java.util.Vector;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.mapping.Employee;

public abstract class HierarchicalQueryTest
extends TestCase {
    static String ERROR_1 = "The number of results returned was not the number of results expected.";
    static String ERROR_2 = "The results did not match, missing:";
    public Vector results;

    public abstract Vector expectedResults();

    public abstract ReadAllQuery getQuery();

    public void setup() {
        if (!this.getSession().getPlatform().isOracle()) {
            throw new TestWarningException("This test is intended for Oracle databases only");
        }
    }

    public void reset() {
    }

    public void test() {
        try {
            this.results = (Vector)this.getSession().executeQuery((DatabaseQuery)this.getQuery());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            if (ex.getMessage().indexOf("missing BY keyword") != -1 || ex.getMessage().indexOf("cannot have join with CONNECT BY") != -1) {
                throw new TestWarningException("This test is indended for Oracle 9i and up");
            }
            ex.printStackTrace();
            throw new TestErrorException(ex.getMessage());
        }
    }

    public void verify() {
        Vector expectedResults = this.expectedResults();
        if (expectedResults.size() != this.results.size()) {
            throw new TestErrorException(ERROR_1);
        }
        for (Object next : this.results) {
            if (expectedResults.contains(next)) continue;
            throw new TestErrorException(ERROR_2 + next);
        }
    }

    public void addEmployee(Vector toVector, Employee emp) {
        toVector.addElement(emp);
        Vector managed = emp.getManagedEmployees();
        if (managed != null && !managed.isEmpty()) {
            for (int i = 0; i < managed.size(); ++i) {
                Employee next = (Employee)managed.elementAt(i);
                this.addEmployee(toVector, next);
            }
        }
    }
}

