/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.validation;

import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.tests.validation.ExceptionTest;

public class ConnectionSizeChangedAfterLogin
extends ExceptionTest {
    public ConnectionSizeChangedAfterLogin() {
        this.setDescription("This test attempts to set the size of the read connection pool after logging in to the server session.");
    }

    protected void setup() {
        this.expectedException = ValidationException.cannotSetReadPoolSizeAfterLogin();
    }

    public void test() {
        ServerSession server = null;
        try {
            server = new ServerSession((Login)this.getSession().getLogin());
            server.setLogLevel(this.getSession().getLogLevel());
            server.setLog(this.getSession().getLog());
            server.addConnectionPool("default", (Login)this.getSession().getLogin(), 3, 5);
            server.login();
            server.useReadConnectionPool(3, 3);
        }
        catch (EclipseLinkException exception) {
            this.caughtException = exception;
        }
        finally {
            server.logout();
        }
    }
}

