/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.forceupdate;

import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TransactionalTestCase;
import org.eclipse.persistence.testing.models.forceupdate.EmployeeTLIC;

public class FUVLTimestampLockInCacheTest
extends TransactionalTestCase {
    boolean exceptionCaught = false;
    int testnumber;

    public FUVLTimestampLockInCacheTest(int anInt) {
        this.testnumber = anInt;
        this.setName(this.getName() + "(Test" + anInt + ")");
        switch (this.testnumber) {
            case 1: {
                this.setDescription("Correctly use method forceUpdateToVersionField()");
                break;
            }
            case 2: {
                this.setDescription("forceUpdateToVersionField() doesn't effect read-only UOW");
                break;
            }
            case 3: {
                this.setDescription("Test method removeForceUpdateToVersionField()");
                break;
            }
            case 4: {
                this.setDescription("Demonstrate the result when no using forceUpdateToVersionField()");
                break;
            }
        }
    }

    public void test() {
        switch (this.testnumber) {
            case 1: {
                this.test1();
                break;
            }
            case 2: {
                this.test2();
                break;
            }
            case 3: {
                this.test3();
                break;
            }
            case 4: {
                this.test4();
                break;
            }
        }
    }

    public void test1() {
        ExpressionBuilder bldr = new ExpressionBuilder();
        Expression exp1 = bldr.get("firstName").equal((Object)"Bob");
        Expression exp2 = bldr.get("lastName").equal((Object)"Smith");
        Expression exp = exp1.and(exp2);
        EmployeeTLIC emp = (EmployeeTLIC)this.getSession().readObject(EmployeeTLIC.class, exp);
        UnitOfWork uow1 = this.getSession().acquireUnitOfWork();
        UnitOfWork uow2 = this.getSession().acquireUnitOfWork();
        EmployeeTLIC clone1 = (EmployeeTLIC)uow1.registerObject((Object)emp);
        EmployeeTLIC clone2 = (EmployeeTLIC)uow2.registerObject((Object)emp);
        uow1.forceUpdateToVersionField((Object)clone1, true);
        clone1.getAddress().setStreet("4 Hutton Centre,Suite 900");
        clone1.getAddress().setCity("Santa Ana");
        clone1.getAddress().setProvince("CA");
        clone1.getAddress().setCountry("USA");
        clone1.getAddress().setPostalCode("92797");
        uow1.commit();
        clone2.setSalary(clone2.getSalary() + 200);
        try {
            uow2.commit();
        }
        catch (OptimisticLockException exception) {
            this.exceptionCaught = true;
        }
    }

    public void test2() {
        ExpressionBuilder bldr = new ExpressionBuilder();
        Expression exp1 = bldr.get("firstName").equal((Object)"Bob");
        Expression exp2 = bldr.get("lastName").equal((Object)"Smith");
        Expression exp = exp1.and(exp2);
        EmployeeTLIC emp = (EmployeeTLIC)this.getSession().readObject(EmployeeTLIC.class, exp);
        UnitOfWork uow1 = this.getSession().acquireUnitOfWork();
        UnitOfWork uow2 = this.getSession().acquireUnitOfWork();
        EmployeeTLIC clone1 = (EmployeeTLIC)uow1.registerObject((Object)emp);
        EmployeeTLIC clone2 = (EmployeeTLIC)uow2.registerObject((Object)emp);
        uow1.forceUpdateToVersionField((Object)clone1, true);
        clone1.getAddress().setStreet("4 Hutton Centre,Suite 900");
        clone1.getAddress().setCity("Santa Ana");
        clone1.getAddress().setProvince("CA");
        clone1.getAddress().setCountry("USA");
        clone1.getAddress().setPostalCode("92797");
        uow1.commit();
        try {
            uow2.commit();
        }
        catch (OptimisticLockException exception) {
            this.exceptionCaught = true;
        }
    }

    public void test3() {
        ExpressionBuilder bldr = new ExpressionBuilder();
        Expression exp1 = bldr.get("firstName").equal((Object)"Bob");
        Expression exp2 = bldr.get("lastName").equal((Object)"Smith");
        Expression exp = exp1.and(exp2);
        EmployeeTLIC emp = (EmployeeTLIC)this.getSession().readObject(EmployeeTLIC.class, exp);
        UnitOfWork uow1 = this.getSession().acquireUnitOfWork();
        EmployeeTLIC clone1 = (EmployeeTLIC)uow1.registerObject((Object)emp);
        uow1.forceUpdateToVersionField((Object)clone1, true);
        clone1.getAddress().setStreet("100 Young Street");
        clone1.getAddress().setCity("Toronto");
        clone1.getAddress().setProvince("ON");
        clone1.getAddress().setCountry("CANADA");
        clone1.getAddress().setPostalCode("K489Y7");
        uow1.commitAndResume();
        uow1.removeForceUpdateToVersionField((Object)clone1);
        UnitOfWork uow2 = this.getSession().acquireUnitOfWork();
        EmployeeTLIC clone2 = (EmployeeTLIC)uow2.registerObject((Object)emp);
        clone1.getAddress().setStreet("4 Hutton Centre,Suite 900");
        clone1.getAddress().setCity("Santa Ana");
        clone1.getAddress().setProvince("CA");
        clone1.getAddress().setCountry("USA");
        clone1.getAddress().setPostalCode("92797");
        uow1.commit();
        clone2.setSalary(clone2.getSalary() + 200);
        try {
            uow2.commit();
        }
        catch (OptimisticLockException exception) {
            this.exceptionCaught = true;
        }
    }

    public void test4() {
        ExpressionBuilder bldr = new ExpressionBuilder();
        Expression exp1 = bldr.get("firstName").equal((Object)"Bob");
        Expression exp2 = bldr.get("lastName").equal((Object)"Smith");
        Expression exp = exp1.and(exp2);
        EmployeeTLIC emp = (EmployeeTLIC)this.getSession().readObject(EmployeeTLIC.class, exp);
        UnitOfWork uow1 = this.getSession().acquireUnitOfWork();
        UnitOfWork uow2 = this.getSession().acquireUnitOfWork();
        EmployeeTLIC clone1 = (EmployeeTLIC)uow1.registerObject((Object)emp);
        EmployeeTLIC clone2 = (EmployeeTLIC)uow2.registerObject((Object)emp);
        clone1.getAddress().setStreet("4 Hutton Centre,Suite 900");
        clone1.getAddress().setCity("Santa Ana");
        clone1.getAddress().setProvince("CA");
        clone1.getAddress().setCountry("USA");
        clone1.getAddress().setPostalCode("92797");
        uow1.commit();
        clone2.setSalary(clone2.getSalary() + 200);
        try {
            uow2.commit();
        }
        catch (OptimisticLockException exception) {
            this.exceptionCaught = true;
        }
    }

    protected void verify() {
        switch (this.testnumber) {
            case 1: {
                if (this.exceptionCaught) break;
                throw new TestErrorException("No Optimistic Lock exception was thrown");
            }
            case 2: 
            case 3: 
            case 4: {
                if (!this.exceptionCaught) break;
                throw new TestErrorException("Optimistic Lock exception should not have been thrown");
            }
        }
    }
}

