/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import java.util.Random;
import java.util.Vector;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.models.employee.domain.PhoneNumber;
import org.eclipse.persistence.testing.tests.clientserver.Server;

public class UnitOfWorkDeleteOrderTest
extends TestCase {
    protected DatabaseLogin login;
    protected UpdateDeadlockClientDeleteOrder[] clients = new UpdateDeadlockClientDeleteOrder[NUM_CLIENTS];
    protected Server server;
    public static int NUM_CLIENTS = 20;

    public UnitOfWorkDeleteOrderTest() {
        this.setDescription("Test to ensure objects are deleted in order of PK when should order is set to avoid deadlock.");
    }

    public void setup() {
        this.login = (DatabaseLogin)this.getSession().getLogin().clone();
        this.server = new Server(this.login);
        this.server.serverSession.setSessionLog(this.getSession().getSessionLog());
        this.server.login();
        this.server.copyDescriptors(this.getSession());
        for (int index = 0; index < NUM_CLIENTS; ++index) {
            this.clients[index] = new UpdateDeadlockClientDeleteOrder(this.server, this.getSession(), "Client" + index, index);
        }
    }

    public void reset() {
        for (int i = 0; i < NUM_CLIENTS; ++i) {
            this.clients[i].release();
        }
        this.server.logout();
    }

    public void test() {
        int i;
        for (i = 0; i < NUM_CLIENTS; ++i) {
            this.clients[i].start();
        }
        try {
            for (i = 0; i < NUM_CLIENTS; ++i) {
                this.clients[i].join();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void verify() {
        for (int i = 0; i < NUM_CLIENTS; ++i) {
            if (this.clients[i].exception == null) continue;
            this.throwError("Deleting objects caused deadlock.");
        }
    }

    protected class UpdateDeadlockClientDeleteOrder
    extends Thread {
        protected int index;
        protected Server server;
        protected Session clientSession;
        protected Session session;
        public Throwable exception;

        public UpdateDeadlockClientDeleteOrder(Server server, Session session, String name, int index) {
            super(name);
            this.index = index;
            this.server = server;
            this.session = session;
            this.clientSession = this.server.serverSession.acquireClientSession();
        }

        public void release() {
            this.clientSession.release();
        }

        @Override
        public void run() {
            try {
                for (int index = 0; index < 5; ++index) {
                    UnitOfWork uow = this.clientSession.acquireUnitOfWork();
                    uow.setCommitOrder(UnitOfWork.CommitOrderType.ID);
                    Vector phoneNumbers = uow.readAllObjects(PhoneNumber.class);
                    Random random = new Random();
                    for (PhoneNumber phoneNumber : phoneNumbers) {
                        if (!random.nextBoolean()) continue;
                        uow.deleteObject((Object)phoneNumber);
                    }
                    uow.writeChanges();
                    Thread.sleep(1000L);
                    uow.commit();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                this.exception = t;
            }
        }
    }
}

