/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.workbenchintegration;

import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.factories.ProjectClassGenerator;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeProject;
import org.eclipse.persistence.testing.tests.workbenchintegration.Compiler;

public class ProjectClassGeneratorUnicodeTest
extends AutoVerifyTestCase {
    public static String PROJECT_FILE = "ProjectClassGeneratorUnicodeProject";
    DatabaseMapping unicodeMap;
    Project unicodeProject;

    public ProjectClassGeneratorUnicodeTest() {
        this.setDescription("Test if ProjectClassGenerator generates unicode escaped characters for non-ASCII characters properly");
    }

    protected void setup() throws Exception {
        EmployeeProject initialProject = new EmployeeProject();
        initialProject.getDescriptor(Employee.class).getMappingForAttributeName("firstName").setAttributeName("\u5e08\u592b");
        ProjectClassGenerator generator = new ProjectClassGenerator((Project)initialProject, PROJECT_FILE, PROJECT_FILE + ".java");
        generator.generate();
        try {
            boolean result = Compiler.compile(PROJECT_FILE + ".java");
            if (!result) {
                throw new TestErrorException("Project class generation compile failed. This could either be a legitimate compile failure, or could result if you do not have the tools.jar from your JDK on the classpath.");
            }
            Class<?> projectClass = Class.forName(PROJECT_FILE);
            this.unicodeProject = (Project)projectClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            throw new RuntimeException("Project class generation failed.It may be possible to solve this issue by adding the tools.jar from your JDK to the classpath.", exception);
        }
    }

    public void test() {
        this.unicodeMap = this.unicodeProject.getDescriptor(Employee.class).getMappingForAttributeName("\u5e08\u592b");
    }

    protected void verify() {
        if (this.unicodeMap == null) {
            throw new TestErrorException("Mapping for unicode does not exist after written out and read in from project class");
        }
    }
}

