/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.framework;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Logger;
import org.eclipse.persistence.testing.framework.ConnectionWrapper;
import org.eclipse.persistence.testing.framework.TestProblemException;

public class DriverWrapper
implements Driver {
    static String driverName;
    static Driver driver;
    static boolean driverBroken;
    static String driverBrokenExceptionString;
    public static String defaultDriverBrokenExceptionString;
    static boolean oldConnectionsBroken;
    static String oldConnectionsBrokenExceptionString;
    public static String defaultOldConnectionsBrokenExceptionString;
    static boolean newConnectionsBroken;
    static String newConnectionsBrokenExceptionString;
    public static String defaultNewConnectionsBrokenExceptionString;
    static HashSet<ConnectionWrapper> connections;

    public static String codeUrl(String url) {
        return url.replace(':', '*');
    }

    public static String decodeUrl(String url) {
        return url.replace('*', ':');
    }

    public static void initialize(String newDriverName) {
        DriverWrapper.clear();
        driverName = newDriverName;
    }

    public static void breakDriver() {
        DriverWrapper.breakDriver(defaultDriverBrokenExceptionString);
    }

    public static void breakDriver(String exceptionString) {
        driverBroken = true;
        driverBrokenExceptionString = exceptionString;
    }

    public static void repairDriver() {
        driverBroken = false;
        driverBrokenExceptionString = null;
    }

    public static void breakOldConnections() {
        DriverWrapper.breakOldConnections(defaultOldConnectionsBrokenExceptionString);
    }

    public static void breakOldConnections(String exceptionString) {
        oldConnectionsBroken = true;
        oldConnectionsBrokenExceptionString = exceptionString;
        Iterator<ConnectionWrapper> it = connections.iterator();
        while (it.hasNext()) {
            it.next().breakConnection(oldConnectionsBrokenExceptionString);
        }
    }

    public static void repairOldConnections() {
        oldConnectionsBroken = false;
        oldConnectionsBrokenExceptionString = null;
        Iterator<ConnectionWrapper> it = connections.iterator();
        while (it.hasNext()) {
            it.next().repairConnection();
        }
    }

    public static void breakNewConnections() {
        DriverWrapper.breakNewConnections(defaultNewConnectionsBrokenExceptionString);
    }

    public static void breakNewConnections(String exceptionString) {
        newConnectionsBroken = true;
        newConnectionsBrokenExceptionString = exceptionString;
    }

    public static void repairNewConnections() {
        newConnectionsBroken = false;
        newConnectionsBrokenExceptionString = null;
    }

    public static void breakAll() {
        DriverWrapper.breakDriver();
        DriverWrapper.breakNewConnections();
        DriverWrapper.breakOldConnections();
    }

    public static void repairAll() {
        DriverWrapper.repairDriver();
        DriverWrapper.repairNewConnections();
        DriverWrapper.repairOldConnections();
    }

    public static void clear() {
        DriverWrapper.repairAll();
        Iterator<ConnectionWrapper> it = connections.iterator();
        while (it.hasNext()) {
            try {
                it.next().close();
            }
            catch (SQLException sQLException) {}
        }
        connections.clear();
        driver = null;
        driverName = null;
    }

    static Driver getDriver() {
        if (driver == null) {
            try {
                driver = (Driver)Class.forName(driverName, true, Thread.currentThread().getContextClassLoader()).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                throw new TestProblemException("DriverWrapper: failed to instantiate " + driverName, ex);
            }
        }
        return driver;
    }

    public static boolean driverBroken() {
        return driverBroken;
    }

    public static String getDriverBrokenExceptionString() {
        return driverBrokenExceptionString;
    }

    public static boolean oldConnectionsBroken() {
        return oldConnectionsBroken;
    }

    public static String getOldConnectionsBrokenExceptionString() {
        return oldConnectionsBrokenExceptionString;
    }

    public static boolean newConnectionsBroken() {
        return newConnectionsBroken;
    }

    public static String getNewConnectionsBrokenExceptionString() {
        return newConnectionsBrokenExceptionString;
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (driverBroken) {
            throw new SQLException(DriverWrapper.getDriverBrokenExceptionString());
        }
        String decodedUrl = DriverWrapper.decodeUrl(url);
        if (driverName != null) {
            Connection internalConn = DriverWrapper.getDriver().connect(decodedUrl, info);
            if (internalConn == null) {
                return null;
            }
            ConnectionWrapper conn = new ConnectionWrapper(internalConn);
            connections.add(conn);
            return conn;
        }
        return null;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        if (driverName != null) {
            if (driverBroken) {
                throw new SQLException(DriverWrapper.getDriverBrokenExceptionString());
            }
            String decodedUrl = DriverWrapper.decodeUrl(url);
            return DriverWrapper.getDriver().acceptsURL(decodedUrl);
        }
        return false;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        if (driverBroken) {
            throw new SQLException(DriverWrapper.getDriverBrokenExceptionString());
        }
        return DriverWrapper.getDriver().getPropertyInfo(url, info);
    }

    @Override
    public int getMajorVersion() {
        return DriverWrapper.getDriver().getMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        return DriverWrapper.getDriver().getMinorVersion();
    }

    @Override
    public boolean jdbcCompliant() {
        return DriverWrapper.getDriver().jdbcCompliant();
    }

    @Override
    public Logger getParentLogger() {
        return null;
    }

    static {
        defaultDriverBrokenExceptionString = "DriverWrapper: driver is broken";
        defaultOldConnectionsBrokenExceptionString = "DriverWrapper: old connections are broken";
        defaultNewConnectionsBrokenExceptionString = "DriverWrapper: new connections are broken";
        connections = new HashSet();
        try {
            DriverManager.registerDriver(new DriverWrapper());
        }
        catch (SQLException ex) {
            throw new TestProblemException("registerDriver failed for DriverWrapper", ex);
        }
    }
}

