/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.mapping;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.sessions.DataRecord;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.models.mapping.Computer;
import org.eclipse.persistence.testing.models.mapping.Cubicle;
import org.eclipse.persistence.testing.models.mapping.Female;
import org.eclipse.persistence.testing.models.mapping.Gender;
import org.eclipse.persistence.testing.models.mapping.Hardware;
import org.eclipse.persistence.testing.models.mapping.JobDescription;
import org.eclipse.persistence.testing.models.mapping.Male;
import org.eclipse.persistence.testing.models.mapping.Phone;
import org.eclipse.persistence.testing.models.mapping.Shipment;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;

public class Employee
implements Serializable {
    public String firstName;
    public String lastName;
    public String sex;
    public java.util.Date dateAndTimeOfBirth;
    public java.util.Date joiningDate;
    public ValueHolderInterface policies = new ValueHolder(new Vector());
    private ValueHolderInterface designation = new ValueHolder();
    public JobDescription jobDescription;
    public Hardware computer;
    public Vector shipments = new Vector();
    public Vector managedEmployees = new Vector();
    public Employee manager;
    public ValueHolderInterface phoneNumbers = new ValueHolder(new Vector());
    public Gender gender;
    public Cubicle cubicle;

    public void addManagedEmployee(Employee employee) {
        this.managedEmployees.addElement(employee);
    }

    public void addPhoneNumber(Phone phoneNumber) {
        this.getPhoneNumbers().addElement(phoneNumber);
    }

    public static void addToDescriptor(ClassDescriptor des) {
        ExpressionBuilder computer = new ExpressionBuilder();
        OneToOneMapping computerMapping = (OneToOneMapping)des.getMappingForAttributeName("computer");
        computerMapping.setSelectionCriteria(computer.getField("MAP_HRW.EMP_FNAME").equal(computer.getParameter(new DatabaseField("MAP_EMP.FNAME"))).and(computer.getField("MAP_HRW.EMP_LNAME").equal(computer.getParameter(new DatabaseField("MAP_EMP.LNAME")))));
        ExpressionBuilder shipment = new ExpressionBuilder();
        Expression linkTable = shipment.getTable("MAP_EMSP");
        ManyToManyMapping shipmentMapping = (ManyToManyMapping)des.getMappingForAttributeName("shipments");
        shipmentMapping.setSelectionCriteria(linkTable.getField("MAP_EMSP.EMP_FNAME").equal(shipment.getParameter(new DatabaseField("MAP_EMP.FNAME"))).and(linkTable.getField("MAP_EMSP.EMP_LNAME").equal(shipment.getParameter(new DatabaseField("MAP_EMP.LNAME")))).and(linkTable.getField("MAP_EMSP.SP_TS").equal(shipment.getField("MAP_SHIP.SP_TS"))).and(linkTable.getField("MAP_EMSP.SP_TSMIL").equal(shipment.getField("MAP_SHIP.SP_TSMIL"))).and(linkTable.getField("MAP_EMSP.STATUS").equal(null)));
        DirectToFieldMapping genderType = new DirectToFieldMapping();
        ObjectTypeConverter genderConverter = new ObjectTypeConverter();
        genderType.setFieldName("GENDER");
        genderType.setAttributeName("gender");
        genderConverter.addConversionValue((Object)"M", (Object)Male.male);
        genderConverter.addConversionValue((Object)"F", (Object)Female.female);
        genderConverter.setDefaultAttributeValue((Object)Female.female);
        genderType.setConverter((Converter)genderConverter);
        des.addMapping((DatabaseMapping)genderType);
    }

    public static TableDefinition employeePhoneJoinTableDefinition() {
        TableDefinition definition = new TableDefinition();
        definition.setName("MAP_EMPH");
        definition.addPrimaryKeyField("FNAME", String.class, 20);
        definition.addPrimaryKeyField("LNAME", String.class, 20);
        definition.addPrimaryKeyField("P_ID", BigDecimal.class, 15);
        return definition;
    }

    public static Employee errorExample1() {
        Employee example = new Employee();
        Vector<String> empPolicies = new Vector<String>();
        example.firstName = "Dave";
        example.lastName = "Vadis";
        example.sex = "unknown";
        Calendar c = Calendar.getInstance();
        c.set(1974, 2, 14, 1, 1, 1);
        c.set(14, 0);
        example.dateAndTimeOfBirth = c.getTime();
        c = Calendar.getInstance();
        c.set(1994, 2, 14);
        example.joiningDate = c.getTime();
        example.designation.setValue((Object)"Executive");
        example.setJobDescription(JobDescription.example1());
        example.computer = Computer.example1(example);
        empPolicies.addElement("Health");
        empPolicies.addElement("Tenant");
        example.setPolicies(empPolicies);
        Shipment s1 = Shipment.example1();
        Shipment s2 = Shipment.example2();
        example.shipments.addElement(s1);
        example.shipments.addElement(s2);
        s1.employees.addElement(example);
        s2.employees.addElement(example);
        example.addPhoneNumber(Phone.example1());
        example.addPhoneNumber(Phone.example2());
        return example;
    }

    public static Employee example1() {
        Employee example = new Employee();
        Vector<String> empPolicies = new Vector<String>();
        example.firstName = "Dave";
        example.lastName = "Vadis";
        example.sex = "male";
        example.gender = Male.male;
        example.cubicle = Cubicle.example1();
        Calendar c = Calendar.getInstance();
        c.set(1974, 2, 14, 1, 1, 1);
        c.set(14, 0);
        example.dateAndTimeOfBirth = c.getTime();
        c.clear();
        c.set(1994, 2, 14, 1, 1, 1);
        example.joiningDate = c.getTime();
        example.designation.setValue((Object)"Executive");
        example.setJobDescription(JobDescription.example1());
        example.computer = Computer.example1(example);
        empPolicies.addElement("Health");
        empPolicies.addElement("Tenant");
        example.setPolicies(empPolicies);
        Shipment s1 = Shipment.example1();
        Shipment s2 = Shipment.example2();
        example.shipments.addElement(s1);
        example.shipments.addElement(s2);
        s1.employees.addElement(example);
        s2.employees.addElement(example);
        example.addPhoneNumber(Phone.example1());
        example.addPhoneNumber(Phone.example2());
        return example;
    }

    public static Employee example2() {
        Employee example = new Employee();
        Vector<String> empPolicies = new Vector<String>();
        example.firstName = "Tracy";
        example.lastName = "Chapman";
        example.sex = "female";
        example.gender = Female.female;
        example.cubicle = Cubicle.example2();
        Calendar c = Calendar.getInstance();
        c.set(1975, 1, 19, 2, 2, 2);
        c.set(14, 0);
        example.dateAndTimeOfBirth = c.getTime();
        c.clear();
        c.set(1995, 3, 14);
        example.joiningDate = c.getTime();
        example.designation.setValue((Object)"Non-Executive");
        example.setJobDescription(JobDescription.example2());
        example.computer = Computer.example2(example);
        empPolicies.addElement("Vehicle");
        empPolicies.addElement("Tenant");
        example.setPolicies(empPolicies);
        Shipment s1 = Shipment.example3();
        Shipment s2 = Shipment.example4();
        example.shipments.addElement(s1);
        example.shipments.addElement(s2);
        s1.employees.addElement(example);
        s1.employees.addElement(example);
        example.addPhoneNumber(Phone.example3());
        return example;
    }

    public static Employee example3() {
        Employee example = new Employee();
        Vector<String> empPolicies = new Vector<String>();
        example.firstName = "Edward";
        example.lastName = "White";
        example.sex = "male";
        example.gender = Male.male;
        example.cubicle = Cubicle.example1();
        Calendar c = Calendar.getInstance();
        c.set(1971, 11, 24, 3, 3, 3);
        c.set(14, 0);
        example.dateAndTimeOfBirth = c.getTime();
        c.clear();
        c.set(1995, 3, 14);
        example.joiningDate = c.getTime();
        example.designation.setValue((Object)"Non-Executive");
        example.setJobDescription(JobDescription.example3());
        example.computer = Computer.example3(example);
        empPolicies.addElement("Vehicle");
        empPolicies.addElement("House");
        example.setPolicies(empPolicies);
        example.addPhoneNumber(Phone.example4());
        example.addPhoneNumber(Phone.example5());
        return example;
    }

    public static Employee example4() {
        Employee example = new Employee();
        Vector<String> empPolicies = new Vector<String>();
        example.firstName = "Graham";
        example.lastName = "Gooch";
        example.sex = "male";
        example.gender = Male.male;
        example.cubicle = Cubicle.example2();
        Calendar c = Calendar.getInstance();
        c.set(1973, 2, 14, 1, 1, 1);
        c.set(14, 0);
        example.dateAndTimeOfBirth = c.getTime();
        c.clear();
        c.set(1992, 2, 14);
        example.joiningDate = c.getTime();
        example.designation.setValue((Object)"Executive");
        example.setJobDescription(JobDescription.example1());
        example.computer = Computer.example4(example);
        empPolicies.addElement("House");
        empPolicies.addElement("Land");
        example.setPolicies(empPolicies);
        Shipment s1 = Shipment.example3();
        Shipment s2 = Shipment.example4();
        example.shipments.addElement(s1);
        example.shipments.addElement(s2);
        s1.employees.addElement(example);
        s2.employees.addElement(example);
        example.addPhoneNumber(Phone.example7());
        example.addPhoneNumber(Phone.example8());
        return example;
    }

    public static Employee example5() {
        Employee example = new Employee();
        Vector<String> empPolicies = new Vector<String>();
        example.firstName = "Tracy";
        example.lastName = "Rue";
        example.sex = "female";
        example.gender = Female.female;
        Calendar c = Calendar.getInstance();
        c.set(1975, 1, 19, 2, 2, 2);
        c.set(14, 0);
        example.dateAndTimeOfBirth = c.getTime();
        c.clear();
        c.set(1992, 2, 14);
        example.joiningDate = c.getTime();
        example.designation.setValue((Object)"Non-Executive");
        example.setJobDescription(JobDescription.example2());
        example.computer = Computer.example5(example);
        empPolicies.addElement("Vehicle");
        empPolicies.addElement("Tenant");
        example.setPolicies(empPolicies);
        Shipment s1 = Shipment.example5();
        Shipment s2 = Shipment.example6();
        example.shipments.addElement(s1);
        example.shipments.addElement(s2);
        s1.employees.addElement(example);
        s2.employees.addElement(example);
        example.addPhoneNumber(Phone.example9());
        return example;
    }

    public static Employee example6() {
        Employee example = new Employee();
        Vector<String> empPolicies = new Vector<String>();
        example.firstName = "Norman";
        example.lastName = "Louis";
        example.sex = "male";
        example.gender = Male.male;
        Calendar c = Calendar.getInstance();
        c.set(1971, 11, 24, 3, 3, 3);
        c.set(14, 0);
        example.dateAndTimeOfBirth = c.getTime();
        c.clear();
        c.set(1992, 2, 14);
        example.joiningDate = c.getTime();
        example.designation.setValue((Object)"Non-Executive");
        example.setJobDescription(JobDescription.example3());
        example.computer = Computer.example6(example);
        empPolicies.addElement("Vehicle");
        empPolicies.addElement("House");
        example.setPolicies(empPolicies);
        example.addPhoneNumber(Phone.example10());
        example.addPhoneNumber(Phone.example11());
        return example;
    }

    public static Employee example7() {
        Employee example = new Employee();
        Vector<String> empPolicies = new Vector<String>();
        example.firstName = "Imran";
        example.lastName = "Khan";
        example.sex = "male";
        example.gender = Male.male;
        Calendar c = Calendar.getInstance();
        c.set(1971, 11, 24, 3, 3, 3);
        c.set(14, 0);
        example.dateAndTimeOfBirth = c.getTime();
        c.clear();
        c.set(1970, 2, 19);
        example.joiningDate = c.getTime();
        example.designation.setValue((Object)"Executive");
        example.setJobDescription(JobDescription.example3());
        example.computer = Computer.example7(example);
        empPolicies.addElement("Arms");
        empPolicies.addElement("Legs");
        example.setPolicies(empPolicies);
        example.addPhoneNumber(Phone.example13());
        example.addPhoneNumber(Phone.example14());
        return example;
    }

    public static Employee example8() {
        Employee example = new Employee();
        Vector<String> empPolicies = new Vector<String>();
        example.firstName = "Margaret";
        example.lastName = "Thatcher";
        example.sex = "female";
        example.gender = Female.female;
        Calendar c = Calendar.getInstance();
        c.set(1971, 11, 24, 3, 3, 3);
        c.set(14, 0);
        example.dateAndTimeOfBirth = c.getTime();
        c.clear();
        c.set(1901, 1, 1);
        example.joiningDate = c.getTime();
        example.designation.setValue((Object)"Non-Executive");
        example.setJobDescription(JobDescription.example4());
        example.computer = Computer.example8(example);
        empPolicies.addElement("House");
        empPolicies.addElement("Vehicle");
        example.setPolicies(empPolicies);
        example.addPhoneNumber(Phone.example15());
        example.addPhoneNumber(Phone.example16());
        return example;
    }

    public static Employee example9() {
        Employee example = new Employee();
        Vector<String> empPolicies = new Vector<String>();
        example.firstName = "Ace";
        example.lastName = "Ventura";
        example.sex = "male";
        example.gender = Male.male;
        Calendar c = Calendar.getInstance();
        c.set(1971, 11, 24, 3, 3, 3);
        c.set(14, 0);
        example.dateAndTimeOfBirth = c.getTime();
        c.clear();
        c.set(1901, 1, 1);
        example.joiningDate = c.getTime();
        example.designation.setValue((Object)"Executive");
        example.setJobDescription(JobDescription.example5());
        example.computer = Computer.example9(example);
        empPolicies.addElement("Pet");
        empPolicies.addElement("Vehicle");
        example.setPolicies(empPolicies);
        example.addPhoneNumber(Phone.example17());
        example.addPhoneNumber(Phone.example18());
        return example;
    }

    public Hardware getComputer() {
        return this.computer;
    }

    public Date getDate() {
        if (this.dateAndTimeOfBirth == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(this.dateAndTimeOfBirth);
        return new Date(c.getTime().getTime());
    }

    public ValueHolderInterface getDesignation() {
        return this.designation;
    }

    public JobDescription getJobDescription() {
        return this.jobDescription;
    }

    public Vector getManagedEmployees() {
        return this.managedEmployees;
    }

    public Vector getManagedEmployeesForTOPLink() {
        return (Vector)this.managedEmployees.clone();
    }

    public Employee getManager() {
        return this.manager;
    }

    public Vector getPhoneNumbers() {
        return (Vector)this.phoneNumbers.getValue();
    }

    public Vector getPolicies() {
        return (Vector)this.policies.getValue();
    }

    public Integer getRankFromObject() {
        Integer rank = null;
        if (this.getDesignation().getValue() == null) {
            return null;
        }
        if (this.getDesignation().getValue().equals("Executive")) {
            rank = 1;
        }
        if (this.getDesignation().getValue().equals("Non-Executive")) {
            rank = 2;
        }
        return rank;
    }

    public String getRankFromRow(DataRecord row, Session aSession) {
        if (row.get((Object)"ERANK") == null) {
            return null;
        }
        Integer value = ((Number)row.get((Object)"ERANK")).intValue();
        String rank = null;
        Employee employee = new Employee();
        if (value == 1) {
            rank = new String("Executive");
        }
        if (value == 2) {
            rank = new String("Non-Executive");
        }
        return rank;
    }

    public Vector getShipments() {
        return this.shipments;
    }

    public Time getTime() {
        if (this.dateAndTimeOfBirth == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(this.dateAndTimeOfBirth);
        return new Time(c.getTime().getTime());
    }

    public static TableDefinition joinTableDefinition() {
        TableDefinition definition = new TableDefinition();
        definition.setName("MAP_EMSP");
        definition.addPrimaryKeyField("EMP_FNAME", String.class, 20);
        definition.addPrimaryKeyField("EMP_LNAME", String.class, 20);
        definition.addPrimaryKeyField("SP_TS", Timestamp.class);
        definition.addPrimaryKeyField("SP_TSMIL", Integer.class);
        definition.addField("STATUS", Character.class);
        return definition;
    }

    void newMethod() {
    }

    public void removeManagedEmployee(Employee employee) {
        this.managedEmployees.removeElement(employee);
    }

    public void setComputer(Computer computer) {
        this.computer = computer;
    }

    public void setComputer(Hardware computer) {
        this.computer = computer;
    }

    public java.util.Date setDateAndTime(DataRecord row, Session session) {
        Date sqlDateOfBirth = (Date)ConversionManager.getDefaultManager().convertObject(row.get((Object)"BDAY"), Date.class);
        Time timeOfBirth = (Time)session.getLogin().getPlatform().convertObject(row.get((Object)"BTIME"), Time.class);
        if (timeOfBirth == null || sqlDateOfBirth == null) {
            return null;
        }
        Calendar calendarOfBirth = Calendar.getInstance();
        calendarOfBirth.setTime(sqlDateOfBirth);
        Calendar calendarTimeOfBirth = Calendar.getInstance();
        calendarTimeOfBirth.setTime(timeOfBirth);
        calendarOfBirth.set(11, calendarTimeOfBirth.get(11));
        calendarOfBirth.set(12, calendarTimeOfBirth.get(12));
        calendarOfBirth.set(13, calendarTimeOfBirth.get(13));
        java.util.Date utilDateOfBirth = calendarOfBirth.getTime();
        return utilDateOfBirth;
    }

    public void setDesignation(ValueHolderInterface value) {
        this.designation = value;
    }

    public void setJobDescription(JobDescription newJobDescription) {
        this.jobDescription = newJobDescription;
    }

    public void setManagedEmployees(Vector emps) {
        this.managedEmployees = emps;
    }

    public void setManagedEmployeesFromTOPLink(Vector emps) {
        this.managedEmployees = (Vector)emps.clone();
    }

    public void setManager(Employee manager) {
        this.manager = manager;
    }

    public void setPhoneNumbers(Vector v) {
        this.phoneNumbers.setValue((Object)v);
    }

    public void setPolicies(Vector theVector) {
        this.policies.setValue((Object)theVector);
    }

    public static TableDefinition tableDefinition() {
        TableDefinition definition = new TableDefinition();
        definition.setName("MAP_EMP");
        definition.addField("FNAME", String.class, 20);
        definition.addField("LNAME", String.class, 20);
        definition.addField("SEX", String.class, 10);
        definition.addField("BDAY", Date.class);
        definition.addField("BTIME", Time.class);
        definition.addField("JDAY", Date.class);
        definition.addField("ERANK", Integer.class);
        definition.addField("GENDER", String.class, 10);
        definition.addField("M_FNAME", String.class, 20);
        definition.addField("M_LNAME", String.class, 20);
        definition.addField("C_ID", String.class, 15);
        definition.addField("A_ID", BigDecimal.class, 15);
        definition.addForeignKeyConstraint("MAP_EMP_MAP_ADD", "A_ID", "A_ID", "MAP_ADD");
        definition.addForeignKeyConstraint("MAP_EMP_MAP_CUB", "C_ID", "C_ID", "MAP_CUB");
        definition.addForeignKeyConstraint("MAP_EMP_MAP_EMP", "M_FNAME,M_LNAME", "FNAME,LNAME", "MAP_EMP");
        return definition;
    }

    public String toString() {
        return "Employee(" + this.firstName + " " + this.lastName + ")";
    }
}

